/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public final class FloatingIslandStructure
extends StructureFeature<JigsawConfiguration> {
    public FloatingIslandStructure() {
        super(JigsawConfiguration.f_67756_, FloatingIslandStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        ChunkGenerator generator = context.f_197352_();
        return !generator.m_212265_(BuiltinStructureSets.f_209826_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10);
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!FloatingIslandStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        int topLandY = context.f_197352_().m_156174_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int targetHeight = Math.min(context.f_197357_().m_151558_() - 20, topLandY + 60);
        blockpos = blockpos.m_175288_(targetHeight);
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }
}

