/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures;

import com.tristankechlo.explorations.worlgen.structures.pieces.SlimeCaveStructurePiece;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public final class SlimeCaveStructure
extends StructureFeature<NoneFeatureConfiguration> {
    private static final ResourceLocation ID = new ResourceLocation("explorations", "slime_cave");

    public SlimeCaveStructure() {
        super(NoneFeatureConfiguration.f_67815_, SlimeCaveStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public static Optional<PieceGenerator<NoneFeatureConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        Random random = new Random(context.f_197354_());
        int highestY = context.f_197352_().m_6337_();
        if (highestY <= 30) {
            return Optional.empty();
        }
        int lowestY = context.f_197352_().m_142062_() + 5;
        int range = Math.abs((highestY -= 20) - lowestY);
        if (range < 10) {
            return Optional.empty();
        }
        int y = lowestY + random.nextInt(range);
        BlockPos pos = context.f_197355_().m_45615_().m_175288_(y);
        return Optional.of((builder, context2) -> SlimeCaveStructure.generatePieces(builder, (PieceGenerator.Context<NoneFeatureConfiguration>)context2, pos));
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context, BlockPos pos) {
        StructureManager templateManager = context.f_192704_();
        Random random = new Random(context.f_192709_());
        Rotation rotation = Rotation.m_55956_((Random)random);
        builder.m_142679_((StructurePiece)new SlimeCaveStructurePiece(templateManager, ID, pos, rotation));
    }
}

