/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public final class UndergroundTempleStructure
extends StructureFeature<JigsawConfiguration> {
    public UndergroundTempleStructure() {
        super(JigsawConfiguration.f_67756_, UndergroundTempleStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        Random random = new Random(context.f_197354_());
        return random.nextDouble() < 0.6;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!UndergroundTempleStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        Random random = new Random(context.f_197354_());
        int highestY = context.f_197352_().m_6337_();
        if (highestY <= 30) {
            return Optional.empty();
        }
        int lowestY = context.f_197352_().m_142062_() + 5;
        int range = Math.abs((highestY -= 15) - lowestY);
        if (range < 10) {
            return Optional.empty();
        }
        int y = lowestY + random.nextInt(range);
        BlockPos blockpos = context.f_197355_().m_45615_().m_175288_(y);
        boolean intersecting = false;
        boolean placeAtHeightMap = false;
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }
}

