/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.treedecorators;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worlgen.treedecorators.TreeDecoratorContext;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CaveVineDecorator
extends TreeDecorator {
    public static final Codec<CaveVineDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("start_chance").forGetter(decorator -> Float.valueOf(decorator.startProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("berry_chance").forGetter(decorator -> Float.valueOf(decorator.berrySpawnChance)), (App)Codec.intRange((int)0, (int)10).optionalFieldOf("max_vine_length", (Object)4).forGetter(decorator -> decorator.maxVineLength), (App)Codec.BOOL.optionalFieldOf("only_outer_leaves", (Object)true).forGetter(decorator -> decorator.onlyOuterLeaves)).apply((Applicative)builder, CaveVineDecorator::new));
    private final float startProbability;
    private final float berrySpawnChance;
    private final int maxVineLength;
    private final boolean onlyOuterLeaves;

    public CaveVineDecorator(float startProbability, float berrySpawnChance, int maxVineLength, boolean onlyOuterLeaves) {
        this.startProbability = startProbability;
        this.berrySpawnChance = berrySpawnChance;
        this.maxVineLength = maxVineLength;
        this.onlyOuterLeaves = onlyOuterLeaves;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModRegistry.CAVE_VINES.get();
    }

    public void m_142741_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> states, Random random, List<BlockPos> var4, List<BlockPos> leaves) {
        TreeDecoratorContext context = new TreeDecoratorContext(level, states, random, leaves);
        this.place(context);
    }

    private void place(TreeDecoratorContext context) {
        Random random = context.random();
        context.leaves().forEach(blockPosLeave -> {
            if (random.nextFloat() < this.startProbability) {
                if (this.onlyOuterLeaves && !CaveVineDecorator.isOuterBlock(blockPosLeave, context)) {
                    return;
                }
                BlockPos pos = blockPosLeave.m_7495_();
                if (context.isAir(pos)) {
                    CaveVineDecorator.addCaveVines(pos, context, this.berrySpawnChance, this.maxVineLength);
                }
            }
        });
    }

    private static boolean isOuterBlock(BlockPos startPos, TreeDecoratorContext context) {
        ImmutableList neighbours = ImmutableList.of((Object)startPos.m_142127_(), (Object)startPos.m_142126_(), (Object)startPos.m_142128_(), (Object)startPos.m_142125_());
        for (BlockPos pos : neighbours) {
            if (!context.isAir(pos)) continue;
            return true;
        }
        return false;
    }

    private static void addCaveVines(BlockPos startPos, TreeDecoratorContext context, float berryChance, int maxVineLength) {
        Random random = context.random();
        BlockPos blockpos = startPos;
        for (int i = maxVineLength; context.isAir(blockpos) && i > 0; --i) {
            BlockState state = Blocks.f_152538_.m_49966_();
            if (random.nextFloat() < berryChance) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_155977_, (Comparable)Boolean.TRUE);
            }
            context.setBlock(blockpos, state);
            blockpos = blockpos.m_7495_();
        }
    }
}

