/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worlgen.treedecorators.TreeDecoratorContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LanternDecorator
extends TreeDecorator {
    public static final Codec<LanternDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)IntProvider.m_146545_((int)0, (int)10).fieldOf("lantern_count").orElse((Object)ConstantInt.m_146483_((int)3)).forGetter(decorator -> decorator.count), (App)IntProvider.m_146545_((int)0, (int)10).fieldOf("chain_length").orElse((Object)ConstantInt.m_146483_((int)1)).forGetter(decorator -> decorator.chainLength)).apply((Applicative)builder, LanternDecorator::new));
    private final BlockState chain = (BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.Y);
    private final BlockState lantern = (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.TRUE);
    private final float probability;
    private final IntProvider count;
    private final IntProvider chainLength;

    public LanternDecorator(float probability, IntProvider count, IntProvider chainLength) {
        this.probability = probability;
        this.count = count;
        this.chainLength = chainLength;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModRegistry.LANTERN.get();
    }

    public void m_142741_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> states, Random random, List<BlockPos> var4, List<BlockPos> leaves) {
        TreeDecoratorContext context = new TreeDecoratorContext(level, states, random, leaves);
        this.place(context);
    }

    private void place(TreeDecoratorContext context) {
        Random random = context.random();
        if (random.nextFloat() > this.probability) {
            return;
        }
        int count = this.count.m_142270_(random);
        List<BlockPos> possible = LanternDecorator.getLeavesShuffled(context, count);
        for (int i = 0; i < possible.size(); ++i) {
            BlockPos blockpos = possible.get(i);
            for (int length = this.chainLength.m_142270_(random); context.isAir(blockpos) && length > 0; --length) {
                context.setBlock(blockpos, this.chain);
                blockpos = blockpos.m_7495_();
            }
            context.setBlock(blockpos, this.lantern);
        }
    }

    private static List<BlockPos> getLeavesShuffled(TreeDecoratorContext context, int maxCount) {
        Random random = context.random();
        List all = context.leaves().stream().map(pos -> pos.m_7495_()).filter(pos -> context.isAir((BlockPos)pos)).collect(Collectors.toList());
        HashSet<BlockPos> target = new HashSet<BlockPos>();
        for (int maxIndex = Math.min(maxCount, all.size()); maxIndex > 0 && all.size() > 0; --maxIndex) {
            BlockPos pos2 = (BlockPos)all.remove(random.nextInt(all.size()));
            target.add(pos2);
        }
        return new ArrayList<BlockPos>(target);
    }
}

