/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class StoneBrickAgingProcessor
extends StructureProcessor {
    public static final Codec<StoneBrickAgingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Chances.CODEC.fieldOf("chances").forGetter(processor -> processor.chances)).apply((Applicative)instance, StoneBrickAgingProcessor::new));
    private static final List<Block> STONE_BRICKS_REPLACEMENTS = List.of(Blocks.f_50223_, Blocks.f_50224_);
    private static final Map<Block, Block> BRICKS = Map.of(Blocks.f_50225_, Blocks.f_50224_, Blocks.f_152589_, Blocks.f_152594_, Blocks.f_152559_, Blocks.f_152595_);
    private final Chances chances;

    public StoneBrickAgingProcessor(Chances chances) {
        this.chances = chances;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos var2, BlockPos var3, StructureTemplate.StructureBlockInfo var4, StructureTemplate.StructureBlockInfo var5, StructurePlaceSettings var6) {
        BlockState old = var5.f_74676_;
        BlockState replacement = null;
        RandomSource random = var6.m_230326_(var5.f_74675_);
        if (old.m_60713_(Blocks.f_50222_)) {
            Block block = (Block)Util.m_214621_(STONE_BRICKS_REPLACEMENTS, (RandomSource)random);
            replacement = this.tryReplacing(block, old, random, this.chances.bricks());
        } else if (old.m_60713_(Blocks.f_50194_)) {
            replacement = this.tryReplacing(Blocks.f_50631_, old, random, this.chances.stairs());
        } else if (old.m_60713_(Blocks.f_50411_)) {
            replacement = this.tryReplacing(Blocks.f_50645_, old, random, this.chances.slabs());
        } else if (old.m_60713_(Blocks.f_50609_)) {
            replacement = this.tryReplacing(Blocks.f_50607_, old, random, this.chances.walls());
        } else if (BRICKS.containsKey(old.m_60734_())) {
            Block temp = BRICKS.get(old.m_60734_());
            replacement = this.tryReplacing(temp, old, random, this.chances.bricks());
        }
        if (replacement == null) {
            return var5;
        }
        return new StructureTemplate.StructureBlockInfo(var5.f_74675_, replacement, var5.f_74677_);
    }

    private BlockState tryReplacing(Block block, BlockState defaultState, RandomSource random, float chance) {
        if (random.m_188501_() < chance) {
            BlockState state = block.m_49966_();
            for (Property property : defaultState.m_61147_()) {
                if (!state.m_61138_(property)) continue;
                state = StoneBrickAgingProcessor.copyProperty(defaultState, state, property);
            }
            return state;
        }
        return defaultState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }

    protected StructureProcessorType<?> m_6953_() {
        return ModRegistry.STONE_BRICK_AGING_PROCESSOR.get();
    }

    private record Chances(float bricks, float walls, float stairs, float slabs) {
        public static final Codec<Chances> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("bricks").orElse((Object)Float.valueOf(0.25f)).forGetter(Chances::bricks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("walls").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::walls), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stairs").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::stairs), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("slabs").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::slabs)).apply((Applicative)instance, Chances::new));
    }
}

