/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.Map;
import me.pandadev.fallingtrees.entity.TreeEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TreeRenderer
extends EntityRenderer<TreeEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public TreeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.m_234597_();
    }

    public void render(TreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float falltime = this.getBob(entity, partialTick) / 10.0f;
        poseStack.m_85836_();
        Map blocks = (Map)entity.m_20088_().m_135370_(TreeEntity.BLOCKS);
        float time = falltime * falltime / 15.0f;
        float fallDirection = ((Float)entity.m_20088_().m_135370_(TreeEntity.ROTATION)).floatValue();
        Vector3f rotation = new Vector3f(-Math.toRadians((float)Math.lerp((float)90.0f, (float)0.0f, (float)Math.abs((float)(Math.sin((float)time) / time)))), 0.0f, 0.0f);
        rotation.rotateY(fallDirection);
        Quaternionf quaternionf = new Quaternionf().identity().rotateXYZ(rotation.x, rotation.y, rotation.z);
        poseStack.m_85845_(new Quaternion(quaternionf.x, quaternionf.y, quaternionf.z, quaternionf.w));
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        for (Map.Entry entry : blocks.entrySet()) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)((BlockPos)entry.getKey()).m_123341_(), (double)((BlockPos)entry.getKey()).m_123342_(), (double)((BlockPos)entry.getKey()).m_123343_());
            this.blockRenderer.m_110912_((BlockState)entry.getValue(), poseStack, buffer, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(TreeEntity entity) {
        return null;
    }

    protected float getBob(Entity livingEntity, float f) {
        return (float)livingEntity.f_19797_ + f;
    }
}

