/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.pandadev.fallingtrees.FallingTrees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeUtils {
    public static boolean isLog(Block block) {
        if (FallingTrees.serverConfig.blacklisted_log_blocks.contains(Registry.f_122824_.m_7981_((Object)block).toString())) {
            return false;
        }
        if (FallingTrees.serverConfig.whitelisted_log_blocks.contains(Registry.f_122824_.m_7981_((Object)block).toString())) {
            return true;
        }
        return block.m_49966_().m_204343_().anyMatch(blockTagKey -> FallingTrees.serverConfig.whitelisted_log_block_tags.contains(blockTagKey.f_203868_().toString()));
    }

    public static boolean isLeaves(Block block) {
        if (FallingTrees.serverConfig.blacklisted_leaves_blocks.contains(Registry.f_122824_.m_7981_((Object)block).toString())) {
            return false;
        }
        if (FallingTrees.serverConfig.whitelisted_leaves_blocks.contains(Registry.f_122824_.m_7981_((Object)block).toString())) {
            return true;
        }
        return block.m_49966_().m_204343_().anyMatch(blockTagKey -> FallingTrees.serverConfig.whitelisted_leaves_block_tags.contains(blockTagKey.f_203868_().toString()));
    }

    public static boolean isMiningOneBlock(Player player) {
        return player.m_6047_();
    }

    public static List<BlockPos> getTreeBlocks(BlockPos startPos, Level level) {
        ArrayList<BlockPos> logBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leafBlocks = new ArrayList<BlockPos>();
        ArrayList decorativeBlocks = new ArrayList();
        HashSet<BlockPos> visitedLogs = new HashSet<BlockPos>();
        HashMap<BlockPos, Set<BlockPos>> visitedLeaves = new HashMap<BlockPos, Set<BlockPos>>();
        HashSet visitedDecorative = new HashSet();
        TreeUtils.getLogBlocksRecursive(startPos, level, logBlocks, visitedLogs);
        for (BlockPos logBlock : logBlocks) {
            visitedLeaves.put(logBlock, new HashSet());
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = logBlock.m_121955_(direction.m_122436_());
                if (!TreeUtils.isLeaves(level.m_8055_(neighborPos).m_60734_())) continue;
                TreeUtils.getLeavesBlocksRecursive(neighborPos, logBlock, level, leafBlocks, visitedLeaves);
            }
        }
        ArrayList<BlockPos> treeBlocks = new ArrayList<BlockPos>();
        treeBlocks.addAll(logBlocks);
        treeBlocks.addAll(leafBlocks);
        return treeBlocks;
    }

    private static void getLogBlocksRecursive(BlockPos pos, Level level, List<BlockPos> treeBlocks, Set<BlockPos> visited) {
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (TreeUtils.isLog(block)) {
            treeBlocks.add(pos);
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = pos.m_121955_((Vec3i)offset);
                TreeUtils.getLogBlocksRecursive(neighborPos, level, treeBlocks, visited);
            }
        }
    }

    private static void getLeavesBlocksRecursive(BlockPos pos, BlockPos logPos, Level level, List<BlockPos> leavesBlock, Map<BlockPos, Set<BlockPos>> visited) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!TreeUtils.isLeaves(block) || block instanceof LeavesBlock && ((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue() != logPos.m_123333_((Vec3i)pos) || visited.get(logPos).contains(pos)) {
            return;
        }
        visited.get(logPos).add(pos);
        if (!leavesBlock.contains(pos)) {
            leavesBlock.add(pos);
        }
        for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1))) {
            BlockPos neighborPos = pos.m_121955_((Vec3i)offset);
            TreeUtils.getLeavesBlocksRecursive(neighborPos, logPos, level, leavesBlock, visited);
        }
    }

    public static boolean isLogConnectedToGround(LevelAccessor level, BlockPos pos) {
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        if (blockBelow.m_60734_() instanceof LeavesBlock || blockBelow.m_60795_()) {
            return false;
        }
        if (blockBelow.m_60713_(level.m_8055_(pos).m_60734_())) {
            return TreeUtils.isLogConnectedToGround(level, pos.m_7495_());
        }
        return true;
    }
}

