/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.tree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.pandadev.fallingtrees.FallingTrees;
import me.pandadev.fallingtrees.FallingTreesConfig;
import me.pandadev.fallingtrees.tree.TreeUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.joml.Vector3i;

public record TreeCache(Vector3i pos, List<class_2338> treeBlocks, class_1937 level) {
    public static Map<String, Map<Integer, TreeCache>> CACHES = new HashMap<String, Map<Integer, TreeCache>>();

    public static Map<Integer, TreeCache> getCaches(String name) {
        if (!CACHES.containsKey(name)) {
            CACHES.put(name, new HashMap());
        }
        return CACHES.get(name);
    }

    public int getLogAmount() {
        int amount = 0;
        for (class_2338 treeBlock : this.treeBlocks) {
            if (!TreeUtils.isLog(this.level.method_8320(treeBlock).method_26204())) continue;
            ++amount;
        }
        return amount;
    }

    public boolean isTreeSizeToBig() {
        if (FallingTrees.serverConfig.tree_limit.tree_limit_method.equals((Object)FallingTreesConfig.TreeLimit.LimitMethodEnum.BLOCKS)) {
            return this.treeBlocks.size() > FallingTrees.serverConfig.tree_limit.tree_size_limit;
        }
        return this.treeBlocks.stream().filter(blockPos -> TreeUtils.isLog(this.level.method_8320(blockPos).method_26204())).count() > (long)FallingTrees.serverConfig.tree_limit.tree_size_limit;
    }

    public static TreeCache getOrCreateCache(String cacheName, class_2338 pos, class_1937 level, class_1657 player) {
        if (TreeCache.getCaches(cacheName).containsKey(player.method_5628()) && TreeCache.getCaches((String)cacheName).get((Object)Integer.valueOf((int)player.method_5628())).pos.equals(pos.method_10263(), pos.method_10264(), pos.method_10260())) {
            return TreeCache.getCaches(cacheName).get(player.method_5628());
        }
        return TreeCache.createCache(cacheName, pos, level, player);
    }

    public static TreeCache createCache(String cacheName, class_2338 pos, class_1937 level, class_1657 player) {
        TreeCache cache = new TreeCache(new Vector3i(pos.method_10263(), pos.method_10264(), pos.method_10260()), TreeUtils.getTreeBlocks(pos, level), level);
        TreeCache.getCaches(cacheName).put(player.method_5628(), cache);
        return cache;
    }
}

