/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.pandadev.fallingtrees.FallingTrees;
import me.pandadev.fallingtrees.FallingTreesConfig;
import me.pandadev.fallingtrees.entity.TreeEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.joml.Vector3d;

public class TreeUtils {
    public static boolean isLog(class_2248 block) {
        if (FallingTrees.serverConfig.blacklisted_log_blocks.contains(class_7923.field_41175.method_10221((Object)block).toString())) {
            return false;
        }
        if (FallingTrees.serverConfig.whitelisted_log_blocks.contains(class_7923.field_41175.method_10221((Object)block).toString())) {
            return true;
        }
        return block.method_9564().method_40144().anyMatch(blockTagKey -> FallingTrees.serverConfig.whitelisted_log_block_tags.contains(blockTagKey.comp_327().toString()));
    }

    public static boolean isLeaves(class_2248 block) {
        if (FallingTrees.serverConfig.blacklisted_leaves_blocks.contains(class_7923.field_41175.method_10221((Object)block).toString())) {
            return false;
        }
        if (FallingTrees.serverConfig.whitelisted_leaves_blocks.contains(class_7923.field_41175.method_10221((Object)block).toString())) {
            return true;
        }
        return block.method_9564().method_40144().anyMatch(blockTagKey -> FallingTrees.serverConfig.whitelisted_leaves_block_tags.contains(blockTagKey.comp_327().toString()));
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isMiningOneBlock(class_1657 player) {
        if (((FallingTreesConfig)FallingTrees.configHolder.getConfig()).one_block_mining_method.equals((Object)FallingTreesConfig.OneBlockMiningEnum.CROUCH)) {
            return player.method_18276();
        }
        return ((FallingTreesConfig)FallingTrees.configHolder.getConfig()).is_mining_one_block;
    }

    public static List<class_2338> getTreeBlocks(class_2338 startPos, class_1937 level) {
        ArrayList<class_2338> logBlocks = new ArrayList<class_2338>();
        ArrayList<class_2338> leafBlocks = new ArrayList<class_2338>();
        ArrayList decorativeBlocks = new ArrayList();
        HashSet<class_2338> visitedLogs = new HashSet<class_2338>();
        HashMap<class_2338, Set<class_2338>> visitedLeaves = new HashMap<class_2338, Set<class_2338>>();
        HashSet visitedDecorative = new HashSet();
        TreeUtils.getLogBlocksRecursive(startPos, level, logBlocks, visitedLogs);
        for (class_2338 logBlock : logBlocks) {
            visitedLeaves.put(logBlock, new HashSet());
            for (class_2350 direction : class_2350.values()) {
                class_2338 neighborPos = logBlock.method_10081(direction.method_10163());
                if (!TreeUtils.isLeaves(level.method_8320(neighborPos).method_26204())) continue;
                TreeUtils.getLeavesBlocksRecursive(neighborPos, logBlock, level, leafBlocks, visitedLeaves);
            }
        }
        ArrayList<class_2338> treeBlocks = new ArrayList<class_2338>();
        treeBlocks.addAll(logBlocks);
        treeBlocks.addAll(leafBlocks);
        return treeBlocks;
    }

    private static void getLogBlocksRecursive(class_2338 pos, class_1937 level, List<class_2338> treeBlocks, Set<class_2338> visited) {
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (TreeUtils.isLog(block)) {
            treeBlocks.add(pos);
            for (class_2338 offset : class_2338.method_10097((class_2338)new class_2338(-1, 0, -1), (class_2338)new class_2338(1, 1, 1))) {
                class_2338 neighborPos = pos.method_10081((class_2382)offset);
                TreeUtils.getLogBlocksRecursive(neighborPos, level, treeBlocks, visited);
            }
        }
    }

    private static void getLeavesBlocksRecursive(class_2338 pos, class_2338 logPos, class_1937 level, List<class_2338> leavesBlock, Map<class_2338, Set<class_2338>> visited) {
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (!TreeUtils.isLeaves(block) || block instanceof class_2397 && ((Integer)state.method_11654((class_2769)class_2397.field_11199)).intValue() != logPos.method_19455((class_2382)pos) || visited.get(logPos).contains(pos)) {
            return;
        }
        visited.get(logPos).add(pos);
        if (!leavesBlock.contains(pos)) {
            leavesBlock.add(pos);
        }
        for (class_2338 offset : class_2338.method_10097((class_2338)new class_2338(-1, -1, -1), (class_2338)new class_2338(1, 1, 1))) {
            class_2338 neighborPos = pos.method_10081((class_2382)offset);
            TreeUtils.getLeavesBlocksRecursive(neighborPos, logPos, level, leavesBlock, visited);
        }
    }

    public static boolean isLogConnectedToGround(class_1936 level, class_2338 pos) {
        class_2680 blockBelow = level.method_8320(pos.method_10074());
        if (blockBelow.method_26204() instanceof class_2397 || blockBelow.method_26215()) {
            return false;
        }
        if (blockBelow.method_27852(level.method_8320(pos).method_26204())) {
            return TreeUtils.isLogConnectedToGround(level, pos.method_10074());
        }
        return true;
    }

    public static int getAmountOfLogs(Map<class_2338, class_2680> blocks) {
        return (int)blocks.values().stream().filter(state1 -> TreeUtils.isLog(state1.method_26204())).count();
    }

    public static void breakTree(class_1657 player, class_1937 level, class_2338 blockPos) {
        class_2680 blockState = level.method_8320(blockPos);
        if (TreeUtils.isLog(blockState.method_26204())) {
            List<class_2338> tree = TreeUtils.getTreeBlocks(blockPos, level);
            HashMap<class_2338, class_2680> treeBlocks = new HashMap<class_2338, class_2680>();
            for (class_2338 pos : tree) {
                class_2680 state2 = level.method_8320(pos);
                treeBlocks.put(pos.method_10059((class_2382)blockPos), state2);
            }
            if (treeBlocks.values().stream().anyMatch(state -> TreeUtils.isLeaves(state.method_26204()) && (!(state.method_26204() instanceof class_2397) || (Boolean)state.method_11654((class_2769)class_2397.field_11200) == false))) {
                class_1799 usedItem;
                TreeEntity treeEntity = new TreeEntity((class_1299)FallingTrees.TREE_ENTITY.get(), level).setBlocks(treeBlocks);
                Vector3d position = new Vector3d((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
                treeEntity.method_5814(position.x, position.y, position.z);
                treeEntity.usedItem = usedItem = player.method_6047();
                treeEntity.setRotationY((float)Math.atan2(player.method_23317() - position.x, player.method_23321() - position.z));
                level.method_8649((class_1297)treeEntity);
                if (FallingTrees.serverConfig.sound_effect) {
                    level.method_8396(null, blockPos, (class_3414)FallingTrees.TREE_FALL.get(), class_3419.field_15245, 0.25f * FallingTrees.serverConfig.sound_effect_volume, 1.0f);
                }
                int LogAmount = TreeUtils.getAmountOfLogs(treeBlocks);
                if (usedItem.method_7963()) {
                    usedItem.method_7956((int)((float)LogAmount * FallingTrees.serverConfig.item_damage_multiplier), (class_1309)player, player1 -> {});
                }
                player.method_7322(0.005f * (float)LogAmount * FallingTrees.serverConfig.food_exhaustion_multiplier);
                for (Map.Entry entry : treeBlocks.entrySet()) {
                    player.method_7259(class_3468.field_15427.method_14956((Object)((class_2680)entry.getValue()).method_26204()));
                    level.method_8501(((class_2338)entry.getKey()).method_10081((class_2382)blockPos), class_2246.field_10124.method_9564());
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean shouldTreeFall(class_1657 player) {
        if (FallingTrees.serverConfig.tree_limit.only_fall_on_tool_use) {
            return player.method_6047().method_7909() instanceof class_1743 && (!FallingTrees.serverConfig.allow_one_block_mining || !TreeUtils.isMiningOneBlock(player));
        }
        return !FallingTrees.serverConfig.allow_one_block_mining || !TreeUtils.isMiningOneBlock(player);
    }
}

