/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees;

import com.google.gson.Gson;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import me.pandadev.fallingtrees.FallingTreesConfig;
import me.pandadev.fallingtrees.client.renderer.TreeRenderer;
import me.pandadev.fallingtrees.entity.TreeEntity;
import me.pandadev.fallingtrees.network.PacketHandler;
import me.pandadev.fallingtrees.registries.Keybindings;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;

public class FallingTrees {
    public static final String MOD_ID = "fallingtrees";
    public static ConfigHolder<FallingTreesConfig> configHolder;
    public static FallingTreesConfig serverConfig;
    public static final DeferredRegister<SoundEvent> SOUNDS;
    public static final RegistrySupplier<SoundEvent> TREE_FALL;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final RegistrySupplier<EntityType<TreeEntity>> TREE_ENTITY;
    public static final EntityDataSerializer<Map<BlockPos, BlockState>> BLOCK_MAP;

    public static void init() {
        AutoConfig.register(FallingTreesConfig.class, GsonConfigSerializer::new);
        configHolder = AutoConfig.getConfigHolder(FallingTreesConfig.class);
        serverConfig = (FallingTreesConfig)configHolder.getConfig();
        SOUNDS.register();
        ENTITIES.register();
        if (Platform.getEnv() == Dist.CLIENT) {
            FallingTrees.clientInit();
            Keybindings.init();
        }
        PlayerEvent.PLAYER_JOIN.register(FallingTrees::onPlayerJoin);
        PacketHandler.init();
        EntityDataSerializers.m_135050_(BLOCK_MAP);
    }

    private static void onPlayerJoin(ServerPlayer serverPlayer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130087_(new Gson().toJson((Object)configHolder.getConfig()).getBytes());
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)PacketHandler.CONFIG_PACKET_ID, (FriendlyByteBuf)buf);
    }

    public static void clientInit() {
        EntityRendererRegistry.register(TREE_ENTITY, TreeRenderer::new);
    }

    static {
        SOUNDS = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_256840_);
        TREE_FALL = SOUNDS.register("tree_fall", () -> SoundEvent.m_262856_((ResourceLocation)new ResourceLocation(MOD_ID, "tree_fall"), (float)16.0f));
        ENTITIES = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_256939_);
        TREE_ENTITY = ENTITIES.register("tree", () -> EntityType.Builder.m_20704_(TreeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20719_().m_20712_("tree"));
        BLOCK_MAP = new EntityDataSerializer<Map<BlockPos, BlockState>>(){

            public void write(FriendlyByteBuf buffer, Map<BlockPos, BlockState> value) {
                buffer.m_236831_(value, FriendlyByteBuf::m_130064_, (friendlyByteBuf, state) -> friendlyByteBuf.m_130130_(Block.m_49956_((BlockState)state)));
            }

            public Map<BlockPos, BlockState> read(FriendlyByteBuf buffer) {
                return buffer.m_236847_(FriendlyByteBuf::m_130135_, buf -> Block.m_49803_((int)buf.m_130242_()));
            }

            public Map<BlockPos, BlockState> copy(Map<BlockPos, BlockState> value) {
                return new HashMap<BlockPos, BlockState>(value);
            }
        };
    }
}

