/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.mixin;

import me.pandadev.fallingtrees.FallingTrees;
import me.pandadev.fallingtrees.tree.TreeCache;
import me.pandadev.fallingtrees.tree.TreeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockBehaviourMixin {
    @Shadow
    protected abstract BlockState m_7160_();

    @Inject(method={"getDestroyProgress"}, at={@At(value="RETURN")}, cancellable=true)
    public void getDestroyProgress(Player player, BlockGetter level, BlockPos pos, CallbackInfoReturnable<Float> cir) {
        if (TreeUtils.isLog(this.m_7160_().m_60734_())) {
            TreeCache cache = TreeCache.getOrCreateCache("tree_breaking", pos, player.m_9236_(), player);
            if (!FallingTrees.serverConfig.tree_mining_speed_by_log_amount || cache.isTreeSizeToBig()) {
                return;
            }
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() / (float)cache.getLogAmount() * FallingTrees.serverConfig.tree_mining_speed_multiplier));
        }
    }
}

