/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.tree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.pandadev.fallingtrees.FallingTrees;
import me.pandadev.fallingtrees.FallingTreesConfig;
import me.pandadev.fallingtrees.tree.TreeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3i;

public record TreeCache(Vector3i pos, List<BlockPos> treeBlocks, Level level) {
    public static Map<String, Map<Integer, TreeCache>> CACHES = new HashMap<String, Map<Integer, TreeCache>>();

    public static Map<Integer, TreeCache> getCaches(String name) {
        if (!CACHES.containsKey(name)) {
            CACHES.put(name, new HashMap());
        }
        return CACHES.get(name);
    }

    public int getLogAmount() {
        int amount = 0;
        for (BlockPos treeBlock : this.treeBlocks) {
            if (!TreeUtils.isLog(this.level.m_8055_(treeBlock).m_60734_())) continue;
            ++amount;
        }
        return amount;
    }

    public boolean isTreeSizeToBig() {
        if (FallingTrees.serverConfig.tree_limit.tree_limit_method.equals((Object)FallingTreesConfig.TreeLimit.LimitMethodEnum.BLOCKS)) {
            return this.treeBlocks.size() > FallingTrees.serverConfig.tree_limit.tree_size_limit;
        }
        return this.treeBlocks.stream().filter(blockPos -> TreeUtils.isLog(this.level.m_8055_(blockPos).m_60734_())).count() > (long)FallingTrees.serverConfig.tree_limit.tree_size_limit;
    }

    public static TreeCache getOrCreateCache(String cacheName, BlockPos pos, Level level, Player player) {
        if (TreeCache.getCaches(cacheName).containsKey(player.m_19879_()) && TreeCache.getCaches((String)cacheName).get((Object)Integer.valueOf((int)player.m_19879_())).pos.equals(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return TreeCache.getCaches(cacheName).get(player.m_19879_());
        }
        return TreeCache.createCache(cacheName, pos, level, player);
    }

    public static TreeCache createCache(String cacheName, BlockPos pos, Level level, Player player) {
        TreeCache cache = new TreeCache(new Vector3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), TreeUtils.getTreeBlocks(pos, level), level);
        TreeCache.getCaches(cacheName).put(player.m_19879_(), cache);
        return cache;
    }
}

