/*
 * Decompiled with CFR 0.152.
 */
package me.pandadev.fallingtrees.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.pandadev.fallingtrees.FallingTrees;
import me.pandadev.fallingtrees.FallingTreesConfig;
import me.pandadev.fallingtrees.entity.TreeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;

public class TreeUtils {
    public static boolean isLog(Block block) {
        if (FallingTrees.serverConfig.blacklisted_log_blocks.contains(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString())) {
            return false;
        }
        if (FallingTrees.serverConfig.whitelisted_log_blocks.contains(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString())) {
            return true;
        }
        return block.m_49966_().m_204343_().anyMatch(blockTagKey -> FallingTrees.serverConfig.whitelisted_log_block_tags.contains(blockTagKey.f_203868_().toString()));
    }

    public static boolean isLeaves(Block block) {
        if (FallingTrees.serverConfig.blacklisted_leaves_blocks.contains(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString())) {
            return false;
        }
        if (FallingTrees.serverConfig.whitelisted_leaves_blocks.contains(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString())) {
            return true;
        }
        return block.m_49966_().m_204343_().anyMatch(blockTagKey -> FallingTrees.serverConfig.whitelisted_leaves_block_tags.contains(blockTagKey.f_203868_().toString()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isMiningOneBlock(Player player) {
        if (((FallingTreesConfig)FallingTrees.configHolder.getConfig()).one_block_mining_method.equals((Object)FallingTreesConfig.OneBlockMiningEnum.CROUCH)) {
            return player.m_6047_();
        }
        return ((FallingTreesConfig)FallingTrees.configHolder.getConfig()).is_mining_one_block;
    }

    public static List<BlockPos> getTreeBlocks(BlockPos startPos, Level level) {
        ArrayList<BlockPos> logBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leafBlocks = new ArrayList<BlockPos>();
        ArrayList decorativeBlocks = new ArrayList();
        HashSet<BlockPos> visitedLogs = new HashSet<BlockPos>();
        HashMap<BlockPos, Set<BlockPos>> visitedLeaves = new HashMap<BlockPos, Set<BlockPos>>();
        HashSet visitedDecorative = new HashSet();
        TreeUtils.getLogBlocksRecursive(startPos, level, logBlocks, visitedLogs);
        for (BlockPos logBlock : logBlocks) {
            visitedLeaves.put(logBlock, new HashSet());
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = logBlock.m_121955_(direction.m_122436_());
                if (!TreeUtils.isLeaves(level.m_8055_(neighborPos).m_60734_())) continue;
                TreeUtils.getLeavesBlocksRecursive(neighborPos, logBlock, level, leafBlocks, visitedLeaves);
            }
        }
        ArrayList<BlockPos> treeBlocks = new ArrayList<BlockPos>();
        treeBlocks.addAll(logBlocks);
        treeBlocks.addAll(leafBlocks);
        return treeBlocks;
    }

    private static void getLogBlocksRecursive(BlockPos pos, Level level, List<BlockPos> treeBlocks, Set<BlockPos> visited) {
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (TreeUtils.isLog(block)) {
            treeBlocks.add(pos);
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = pos.m_121955_((Vec3i)offset);
                TreeUtils.getLogBlocksRecursive(neighborPos, level, treeBlocks, visited);
            }
        }
    }

    private static void getLeavesBlocksRecursive(BlockPos pos, BlockPos logPos, Level level, List<BlockPos> leavesBlock, Map<BlockPos, Set<BlockPos>> visited) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!TreeUtils.isLeaves(block) || block instanceof LeavesBlock && ((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue() != logPos.m_123333_((Vec3i)pos) || visited.get(logPos).contains(pos)) {
            return;
        }
        visited.get(logPos).add(pos);
        if (!leavesBlock.contains(pos)) {
            leavesBlock.add(pos);
        }
        for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1))) {
            BlockPos neighborPos = pos.m_121955_((Vec3i)offset);
            TreeUtils.getLeavesBlocksRecursive(neighborPos, logPos, level, leavesBlock, visited);
        }
    }

    public static boolean isLogConnectedToGround(LevelAccessor level, BlockPos pos) {
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        if (blockBelow.m_60734_() instanceof LeavesBlock || blockBelow.m_60795_()) {
            return false;
        }
        if (blockBelow.m_60713_(level.m_8055_(pos).m_60734_())) {
            return TreeUtils.isLogConnectedToGround(level, pos.m_7495_());
        }
        return true;
    }

    public static int getAmountOfLogs(Map<BlockPos, BlockState> blocks) {
        return (int)blocks.values().stream().filter(state1 -> TreeUtils.isLog(state1.m_60734_())).count();
    }

    public static void breakTree(Player player, Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        if (TreeUtils.isLog(blockState.m_60734_())) {
            List<BlockPos> tree = TreeUtils.getTreeBlocks(blockPos, level);
            HashMap<BlockPos, BlockState> treeBlocks = new HashMap<BlockPos, BlockState>();
            for (BlockPos pos : tree) {
                BlockState state2 = level.m_8055_(pos);
                treeBlocks.put(pos.m_121996_((Vec3i)blockPos), state2);
            }
            if (treeBlocks.values().stream().anyMatch(state -> TreeUtils.isLeaves(state.m_60734_()) && (!(state.m_60734_() instanceof LeavesBlock) || (Boolean)state.m_61143_((Property)LeavesBlock.f_54419_) == false))) {
                ItemStack usedItem;
                TreeEntity treeEntity = new TreeEntity((EntityType)FallingTrees.TREE_ENTITY.get(), level).setBlocks(treeBlocks);
                Vector3d position = new Vector3d((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                treeEntity.m_6034_(position.x, position.y, position.z);
                treeEntity.usedItem = usedItem = player.m_21205_();
                treeEntity.setRotationY((float)Math.atan2(player.m_20185_() - position.x, player.m_20189_() - position.z));
                level.m_7967_((Entity)treeEntity);
                if (FallingTrees.serverConfig.sound_effect) {
                    level.m_5594_(null, blockPos, (SoundEvent)FallingTrees.TREE_FALL.get(), SoundSource.BLOCKS, 0.25f * FallingTrees.serverConfig.sound_effect_volume, 1.0f);
                }
                int LogAmount = TreeUtils.getAmountOfLogs(treeBlocks);
                if (usedItem.m_41763_()) {
                    usedItem.m_41622_((int)((float)LogAmount * FallingTrees.serverConfig.item_damage_multiplier), (LivingEntity)player, player1 -> {});
                }
                player.m_36399_(0.005f * (float)LogAmount * FallingTrees.serverConfig.food_exhaustion_multiplier);
                for (Map.Entry entry : treeBlocks.entrySet()) {
                    player.m_36246_(Stats.f_12949_.m_12902_((Object)((BlockState)entry.getValue()).m_60734_()));
                    level.m_46597_(((BlockPos)entry.getKey()).m_121955_((Vec3i)blockPos), Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean shouldTreeFall(Player player) {
        if (FallingTrees.serverConfig.tree_limit.only_fall_on_tool_use) {
            return player.m_21205_().m_41720_() instanceof AxeItem && (!FallingTrees.serverConfig.allow_one_block_mining || !TreeUtils.isMiningOneBlock(player));
        }
        return !FallingTrees.serverConfig.allow_one_block_mining || !TreeUtils.isMiningOneBlock(player);
    }
}

