/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gnumus.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.gnumus.world.features.GnumusBonfireFeature;
import net.mcreator.gnumus.world.features.GnumusCampFeature;
import net.mcreator.gnumus.world.features.GnumusFarmFeature;
import net.mcreator.gnumus.world.features.GnumusRuinsFeature;
import net.mcreator.gnumus.world.features.GnumusSettlementFeature;
import net.mcreator.gnumus.world.features.GnumusStatueFeature;
import net.mcreator.gnumus.world.features.LargeGnumusSettlementFeature;
import net.mcreator.gnumus.world.features.SmallGnumusRuinsFeature;
import net.mcreator.gnumus.world.features.SmallGnumusSettlementFeature;
import net.mcreator.gnumus.world.features.SmallRuinsFeature;
import net.mcreator.gnumus.world.features.TradersRestFeature;
import net.mcreator.gnumus.world.features.ores.GnumusClayBlockFeature;
import net.mcreator.gnumus.world.features.plants.ScionWeedFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class GnumusModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"gnumus");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> GNUMUS_CLAY_BLOCK = GnumusModFeatures.register("gnumus_clay_block", GnumusClayBlockFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, GnumusClayBlockFeature.GENERATE_BIOMES, GnumusClayBlockFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SCION_WEED = GnumusModFeatures.register("scion_weed", ScionWeedFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, ScionWeedFeature.GENERATE_BIOMES, ScionWeedFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SMALL_RUINS = GnumusModFeatures.register("small_ruins", SmallRuinsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SmallRuinsFeature.GENERATE_BIOMES, SmallRuinsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SMALL_GNUMUS_RUINS = GnumusModFeatures.register("small_gnumus_ruins", SmallGnumusRuinsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SmallGnumusRuinsFeature.GENERATE_BIOMES, SmallGnumusRuinsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GNUMUS_RUINS = GnumusModFeatures.register("gnumus_ruins", GnumusRuinsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GnumusRuinsFeature.GENERATE_BIOMES, GnumusRuinsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GNUMUS_STATUE = GnumusModFeatures.register("gnumus_statue", GnumusStatueFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GnumusStatueFeature.GENERATE_BIOMES, GnumusStatueFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GNUMUS_CAMP = GnumusModFeatures.register("gnumus_camp", GnumusCampFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GnumusCampFeature.GENERATE_BIOMES, GnumusCampFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SMALL_GNUMUS_SETTLEMENT = GnumusModFeatures.register("small_gnumus_settlement", SmallGnumusSettlementFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SmallGnumusSettlementFeature.GENERATE_BIOMES, SmallGnumusSettlementFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GNUMUS_SETTLEMENT = GnumusModFeatures.register("gnumus_settlement", GnumusSettlementFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GnumusSettlementFeature.GENERATE_BIOMES, GnumusSettlementFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GNUMUS_BONFIRE = GnumusModFeatures.register("gnumus_bonfire", GnumusBonfireFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GnumusBonfireFeature.GENERATE_BIOMES, GnumusBonfireFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LARGE_GNUMUS_SETTLEMENT = GnumusModFeatures.register("large_gnumus_settlement", LargeGnumusSettlementFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LargeGnumusSettlementFeature.GENERATE_BIOMES, LargeGnumusSettlementFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GNUMUS_FARM = GnumusModFeatures.register("gnumus_farm", GnumusFarmFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GnumusFarmFeature.GENERATE_BIOMES, GnumusFarmFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TRADERS_REST = GnumusModFeatures.register("traders_rest", TradersRestFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, TradersRestFeature.GENERATE_BIOMES, TradersRestFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

