/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.damage_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageServerEvents {
    public static final List<String> BLACKLIST_DAMAGE_SOURCES = List.of("lava", "inFire", "cactus", "inWall", "hotFloor", "lightningBolt", "sweetBerryBush", "outOfWorld");
    public static final List<String> BLACKLIST_ENTITY_TYPES = List.of("minecraft:slime", "minecraft:ender_dragon", "minecraft:magma_cube");

    @SubscribeEvent
    public static void onTakeDamage(LivingDamageEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && DamageServerEvents.testDamageSource(event.getSource())) {
            event.getEntity().f_19802_ = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if ((double)player.m_36403_(0.0f) < (Double)ServerConfigs.MINIMUM_ATTACK_STRENGTH.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyKnockback(LivingKnockBackEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            event.setStrength((float)((double)event.getStrength() * (Double)ServerConfigs.KNOCKBACK_MODIFIER.get()));
        }
    }

    private static boolean testDamageSource(DamageSource source) {
        if (((List)ServerConfigs.DAMAGE_MODULE_DAMAGE_SOURCE_BLACKLIST.get()).contains(source.m_19385_())) {
            return false;
        }
        if (source.m_7639_() != null) {
            String entityType = EntityType.m_20613_((EntityType)source.m_7639_().m_6095_()).toString();
            if (((List)ServerConfigs.DAMAGE_MODULE_ENTITY_BLACKLIST.get()).contains(entityType)) {
                return false;
            }
        }
        return true;
    }
}

