/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.enchantment_module;

import io.redspace.ironsrpgtweaks.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class EnchantHelper {
    public static final String hideEnchantsNBT = "hideEnchantments";

    public static boolean shouldHideEnchantments(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null || !compoundtag.m_128441_(hideEnchantsNBT)) {
            return false;
        }
        return compoundtag.m_128471_(hideEnchantsNBT);
    }

    @Nullable
    public static ListTag getEnchantments(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return null;
        }
        if (compoundtag.m_128441_("StoredEnchantments")) {
            return compoundtag.m_128437_("StoredEnchantments", 10);
        }
        if (compoundtag.m_128441_("Enchantments")) {
            return compoundtag.m_128437_("Enchantments", 10);
        }
        return null;
    }

    public static void unhideEnchantments(ItemStack stack, @Nullable Entity entity) {
        if (EnchantHelper.shouldHideEnchantments(stack)) {
            stack.m_41784_().m_128379_(hideEnchantsNBT, false);
            if (entity != null) {
                entity.m_9236_().m_6269_(null, entity, (SoundEvent)SoundRegistry.IDENTIFY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public static void hideEnchantments(ItemStack stack) {
        stack.m_41784_().m_128379_(hideEnchantsNBT, true);
    }

    public static List<ItemStack> getEnchantedEquipmentItems(Mob mob) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(mob.m_6844_(EquipmentSlot.HEAD));
        list.add(mob.m_6844_(EquipmentSlot.CHEST));
        list.add(mob.m_6844_(EquipmentSlot.LEGS));
        list.add(mob.m_6844_(EquipmentSlot.FEET));
        list.add(mob.m_6844_(EquipmentSlot.MAINHAND));
        list.add(mob.m_6844_(EquipmentSlot.OFFHAND));
        return list.stream().filter(itemStack -> !itemStack.m_41619_() && EnchantHelper.getEnchantments(itemStack) != null).toList();
    }
}

