/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.enchantment_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.enchantment_module.EnchantHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EnchantmentServerEvents {
    @SubscribeEvent
    public static void identifyOnEquip(LivingEquipmentChangeEvent event) {
        if (!((Boolean)ServerConfigs.IDENTIFY_ON_EQUIP.get()).booleanValue() || !(event.getEntity() instanceof Player)) {
            return;
        }
        EquipmentSlot slot = event.getSlot();
        if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
            EnchantHelper.unhideEnchantments(event.getTo(), (Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void disableEnchantmentTableInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.getEntity().m_9236_().m_8055_(event.getHitVec().m_82425_()).m_60713_(Blocks.f_50201_) && ((Boolean)ServerConfigs.ENCHANT_MODULE_ENABLED.get()).booleanValue()) {
                boolean canceled = (Boolean)ServerConfigs.DISABLE_ENCHANTING_TABLE.get();
                MutableComponent message = Component.m_237115_((String)"ui.irons_rpg_tweaks.enchanting_table_error.disabled").m_130940_(ChatFormatting.RED);
                if (((Boolean)ServerConfigs.IDENTIFY_ON_ENCHANTING_TABLE.get()).booleanValue() && !event.getEntity().m_21120_(event.getHand()).m_41619_()) {
                    boolean identified;
                    ItemStack itemStack = event.getEntity().m_21120_(event.getHand());
                    boolean enchanted = EnchantHelper.getEnchantments(itemStack) != null;
                    boolean bl = identified = !EnchantHelper.shouldHideEnchantments(itemStack);
                    if (enchanted && identified) {
                        message = Component.m_237115_((String)"ui.irons_rpg_tweaks.enchanting_table_error.identified").m_130940_(ChatFormatting.LIGHT_PURPLE);
                    } else if (enchanted && !identified) {
                        EnchantHelper.unhideEnchantments(itemStack, (Entity)serverPlayer);
                        message = Component.m_237110_((String)"ui.irons_rpg_tweaks.enchanting_table_success", (Object[])new Object[]{itemStack.m_41786_().getString()}).m_130940_(ChatFormatting.GREEN);
                        canceled = true;
                    }
                }
                if (canceled) {
                    event.setCanceled(true);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
                }
            }
        }
    }

    @SubscribeEvent
    public static void hideOnMobSpawn(MobSpawnEvent event) {
        EnchantHelper.getEnchantedEquipmentItems(event.getEntity()).forEach(itemStack -> {
            if (!itemStack.m_41784_().m_128441_("hideEnchantments")) {
                EnchantHelper.hideEnchantments(itemStack);
            }
        });
    }
}

