/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.enchantment_module;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsrpgtweaks.enchantment_module.EnchantHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class HideEnchantsLootModifier
extends LootModifier {
    public static final Supplier<Codec<HideEnchantsLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> HideEnchantsLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HideEnchantsLootModifier::new)));

    protected HideEnchantsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (ItemStack itemStack : generatedLoot) {
            ListTag enchants = EnchantHelper.getEnchantments(itemStack);
            if (enchants == null) continue;
            EnchantHelper.hideEnchantments(itemStack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

