/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.entity;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.registry.EntityRegistry;
import io.redspace.ironsrpgtweaks.registry.SoundRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidType;

public class XpCatalyst
extends Entity {
    UUID ownerUUID;
    int storedXp;

    public XpCatalyst(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public XpCatalyst(Level level) {
        this((EntityType)EntityRegistry.XP_CATALYST.get(), level);
    }

    @Nullable
    public static XpCatalyst createXpCatalyst(ServerPlayer deadPlayer) {
        if (deadPlayer.f_36078_ == 0 && deadPlayer.f_36080_ == 0.0f) {
            return null;
        }
        XpCatalyst xpCatalyst = new XpCatalyst((Level)deadPlayer.m_9236_());
        xpCatalyst.storedXp = (int)(deadPlayer.f_36080_ * (float)deadPlayer.m_36323_());
        int level = deadPlayer.f_36078_;
        for (int i = level - 1; i > 0; --i) {
            xpCatalyst.storedXp += xpCatalyst.getXpNeededForLevel(i);
        }
        xpCatalyst.ownerUUID = deadPlayer.m_20148_();
        xpCatalyst.m_146884_(deadPlayer.m_20182_().m_82520_(0.0, 0.75, 0.0));
        deadPlayer.m_9236_().m_7967_((Entity)xpCatalyst);
        return xpCatalyst;
    }

    public int getXpNeededForLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public float getVisualYOffset(float partialTick) {
        return Mth.m_14031_((float)(((float)this.f_19797_ + partialTick) * 0.04f)) * 0.25f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123767_, this.m_20208_(0.125), this.m_20187_(), this.m_20262_(0.125), 0.0, 0.07, 0.0);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_20148_().equals(this.ownerUUID) || !((Boolean)ServerConfigs.XP_ONLY_ALLOW_OWNER.get()).booleanValue()) {
                player.m_6756_(this.storedXp);
                this.m_216990_((SoundEvent)SoundRegistry.RETRIEVE_XP.get());
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_rpg_tweaks.xp_retrieve_error").m_130940_(ChatFormatting.RED)));
        }
        return super.m_6096_(player, hand);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_142391_() {
        return true;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        this.storedXp = tag.m_128451_("StoredXp");
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128405_("StoredXp", this.storedXp);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

