/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.handler.EntityEventsHandler;
import fuzs.mutantmonsters.handler.PlayerEventsHandler;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CAnimationMessage;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTossCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.init.v2.PotionBrewingRegistry;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5483;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutantMonsters
implements ModConstructor {
    public static final String MOD_ID = "mutantmonsters";
    public static final String MOD_NAME = "Mutant Monsters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mutant Monsters");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"mutantmonsters").common(CommonConfig.class);
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"mutantmonsters");

    public static class_2960 id(String name) {
        return new class_2960(MOD_ID, name);
    }

    public void onConstructMod() {
        ModRegistry.touch();
        MutantMonsters.registerMessages();
        MutantMonsters.registerHandlers();
    }

    private static void registerMessages() {
        NETWORK.register(C2SCreeperMinionTrackerMessage.class, C2SCreeperMinionTrackerMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CMutantLevelParticlesMessage.class, S2CMutantLevelParticlesMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SCreeperMinionNameMessage.class, C2SCreeperMinionNameMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CAnimationMessage.class, S2CAnimationMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(S2CSeismicWaveFluidParticlesMessage.class, S2CSeismicWaveFluidParticlesMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(S2CMutantEndermanHeldBlockMessage.class, S2CMutantEndermanHeldBlockMessage::new, MessageDirection.TO_CLIENT);
    }

    private static void registerHandlers() {
        LivingHurtCallback.EVENT.register(EntityEventsHandler::onLivingHurt);
        UseItemEvents.TICK.register(PlayerEventsHandler::onItemUseTick);
        ArrowLooseCallback.EVENT.register(PlayerEventsHandler::onArrowLoose);
        PlayerInteractEvents.USE_ENTITY.register(EntityEventsHandler::onEntityInteract);
        PlayerTickEvents.END.register(PlayerEventsHandler::onPlayerTick$End);
        ServerEntityLevelEvents.LOAD.register(EntityEventsHandler::onEntityJoinServerLevel);
        LivingDropsCallback.EVENT.register(EntityEventsHandler::onLivingDrops);
        ItemTossCallback.EVENT.register(PlayerEventsHandler::onItemToss);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        context.enqueueWork(() -> PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8985, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModRegistry.ENDERSOUL_HAND_ITEM.get(), (class_1935)ModRegistry.HULK_HAMMER_ITEM.get(), (class_1935)ModRegistry.CREEPER_SHARD_ITEM.get(), (class_1935)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get()}), (class_1842)ModRegistry.CHEMICAL_X_POTION.get()));
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get(), CreeperMinion.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get(), EndersoulClone.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get(), MutantCreeper.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get(), MutantEnderman.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get(), MutantSnowGolem.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), SpiderPig.registerAttributes());
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isForge()) {
            context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), MutantSkeleton.registerAttributes());
            context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), MutantZombie.registerAttributes());
        }
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MutantEnderman::canSpawn);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13197, class_1429::method_20663);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> true, biomeModificationContext -> {
            MobSpawnSettingsContext spawnSettings = biomeModificationContext.mobSpawnSettings();
            CommonConfig config = (CommonConfig)CONFIG.get(CommonConfig.class);
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantCreeperSpawnWeight, class_1311.field_6302, class_1299.field_6046, (class_1299)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantEndermanSpawnWeight, class_1311.field_6302, class_1299.field_6091, (class_1299)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantSkeletonSpawnWeight, class_1311.field_6302, class_1299.field_6137, (class_1299)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantZombieSpawnWeight, class_1311.field_6302, class_1299.field_6051, (class_1299)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get());
        });
    }

    private static void addMutantSpawn(MobSpawnSettingsContext spawnSettings, double spawnWeight, class_1311 mobCategory, class_1299<?> entityType, class_1299<?> mutantEntityType) {
        if (spawnWeight == 0.0) {
            return;
        }
        spawnSettings.getSpawnerData(mobCategory).stream().filter(data -> data.field_9389 == entityType).findAny().ifPresent(spawnerData -> spawnSettings.addSpawn(mobCategory, new class_5483.class_1964(mutantEntityType, Math.max(1, (int)((double)spawnerData.method_34979().method_34976() * spawnWeight)), 1, 1)));
        class_5483.class_5265 mobSpawnCost = spawnSettings.getSpawnCost(entityType);
        if (mobSpawnCost != null) {
            spawnSettings.setSpawnCost(mutantEntityType, mobSpawnCost.method_27838() / spawnWeight, mobSpawnCost.method_27837() * spawnWeight);
        }
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new class_1799((class_1935)ModRegistry.ENDERSOUL_HAND_ITEM.get())).displayItems(output -> {
            output.accept((class_1935)ModRegistry.CREEPER_MINION_TRACKER_ITEM.get());
            output.accept((class_1935)ModRegistry.CREEPER_SHARD_ITEM.get());
            output.accept((class_1935)ModRegistry.ENDERSOUL_HAND_ITEM.get());
            output.accept((class_1935)ModRegistry.HULK_HAMMER_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_ARMS_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_LIMB_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_PELVIS_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_RIB_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_RIB_CAGE_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_LEGGINGS_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_BOOTS_ITEM.get());
            output.accept((class_1935)ModRegistry.CREEPER_MINION_SPAWN_EGG_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_CREEPER_SPAWN_EGG_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_ENDERMAN_SPAWN_EGG_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SKELETON_SPAWN_EGG_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_SNOW_GOLEM_SPAWN_EGG_ITEM.get());
            output.accept((class_1935)ModRegistry.MUTANT_ZOMBIE_SPAWN_EGG_ITEM.get());
            output.accept((class_1935)ModRegistry.SPIDER_PIG_SPAWN_EGG_ITEM.get());
        }).appendEnchantmentsAndPotions());
    }
}

