/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class EndersoulFragment
extends class_1297 {
    public static final Predicate<class_1297> IS_VALID_TARGET = class_1301.field_6156.and(entity -> {
        class_1299 type = entity.method_5864();
        return type != class_1299.field_6052 && type != class_1299.field_6044 && type != class_1299.field_6110 && type != class_1299.field_6116 && type != class_1299.field_6091 && type != ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get() && type != ModRegistry.ENDERSOUL_FRAGMENT_ENTITY_TYPE.get() && type != ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get();
    });
    private static final class_2940<Boolean> TAMED = class_2945.method_12791(EndersoulFragment.class, (class_2941)class_2943.field_13323);
    public final float[][] stickRotations = new float[8][3];
    private int explodeTick = 20 + this.field_5974.nextInt(20);
    private WeakReference<MutantEnderman> spawner;
    private class_1657 owner;

    public EndersoulFragment(class_1299<? extends EndersoulFragment> type, class_1937 world) {
        super(type, world);
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.field_5974.nextFloat() * 2.0f * (float)Math.PI;
            }
        }
    }

    public EndersoulFragment(class_1937 world, MutantEnderman spawner) {
        this((class_1299<? extends EndersoulFragment>)((class_1299)ModRegistry.ENDERSOUL_FRAGMENT_ENTITY_TYPE.get()), world);
        this.spawner = new WeakReference<MutantEnderman>(spawner);
    }

    protected void method_5693() {
        this.field_6011.method_12784(TAMED, (Object)false);
    }

    public class_1657 getOwner() {
        return this.owner;
    }

    public boolean isTamed() {
        return (Boolean)this.field_6011.method_12789(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_6011.method_12778(TAMED, (Object)tamed);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public boolean method_5810() {
        return this.method_5805();
    }

    public void method_5711(byte id) {
        if (id == 3) {
            EntityUtil.spawnEndersoulParticles(this, this.field_5974, 64, 0.8f);
        }
    }

    public void method_5773() {
        super.method_5773();
        class_243 vec3d = this.method_18798();
        if (this.owner == null && vec3d.field_1351 > (double)-0.05f && !this.method_5740()) {
            this.method_18800(vec3d.field_1352, Math.max((double)-0.05f, vec3d.field_1351 - (double)0.1f), vec3d.field_1350);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.9));
        if (this.owner != null && (!this.owner.method_5805() || this.owner.method_7325())) {
            this.owner = null;
        }
        if (!this.field_6002.field_9236) {
            if (!this.isTamed() && --this.explodeTick == 0) {
                this.explode();
            }
            if (this.owner != null && this.method_5858((class_1297)this.owner) > 9.0) {
                float scale = 0.05f;
                this.method_5762((this.owner.method_23317() - this.method_23317()) * (double)scale, (this.owner.method_23318() + (double)(this.owner.method_5751() / 3.0f) - this.method_23318()) * (double)scale, (this.owner.method_23321() - this.method_23321()) * (double)scale);
            }
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.isTamed()) {
            if (this.owner == null && !player.method_21823()) {
                this.owner = player;
                this.method_5783(class_3417.field_15210, 1.0f, 1.0f);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (this.owner == player && player.method_21823()) {
                this.owner = null;
                this.method_5783(class_3417.field_15210, 1.0f, 1.5f);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            return class_1269.field_5811;
        }
        if (!this.field_6002.field_9236) {
            this.setTamed(true);
        }
        this.owner = player;
        this.method_5783(class_3417.field_15210, 1.0f, 1.5f);
        return class_1269.method_29236((boolean)this.field_6002.field_9236);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.field_6002.field_9236 && this.method_5805() && this.field_6012 > 0) {
            this.explode();
        }
        return true;
    }

    private void explode() {
        this.method_5783((class_3414)ModRegistry.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE_SOUND_EVENT.get(), 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
        this.field_6002.method_8421((class_1297)this, (byte)3);
        for (class_1297 entity : this.field_6002.method_8333((class_1297)this, this.method_5829().method_1014(5.0), IS_VALID_TARGET)) {
            boolean hitChance;
            if (!(this.method_5858(entity) <= 25.0)) continue;
            boolean bl = hitChance = this.field_5974.nextInt(3) != 0;
            if (EndersoulFragment.isProtected(entity)) {
                hitChance = this.field_5974.nextInt(3) == 0;
            } else {
                double x = entity.method_23317() - this.method_23317();
                double z = entity.method_23321() - this.method_23321();
                double d = Math.sqrt(x * x + z * z);
                entity.method_18800((double)0.8f * x / d, (double)(this.field_5974.nextFloat() * 0.6f - 0.1f), (double)0.8f * z / d);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
            if (!hitChance) continue;
            entity.method_5643(class_1282.method_5524((class_1297)this, (class_1297)(this.spawner != null ? (class_1297)this.spawner.get() : this)).method_5508(), 1.0f);
        }
        this.method_31472();
    }

    public static boolean isProtected(class_1297 entity) {
        return entity instanceof class_1309 && ((class_1309)entity).method_24518((class_1792)ModRegistry.ENDERSOUL_HAND_ITEM.get());
    }

    public class_3419 method_5634() {
        return this.isTamed() ? class_3419.field_15254 : class_3419.field_15251;
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10556("Tamed", this.isTamed());
        compound.method_10569("ExplodeTick", this.explodeTick);
    }

    protected void method_5749(class_2487 compound) {
        this.setTamed(compound.method_10577("Collected") || compound.method_10577("Tamed"));
        if (compound.method_10545("ExplodeTick")) {
            this.explodeTick = compound.method_10550("ExplodeTick");
        }
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }
}

