/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.animation.AnimatedEntity;
import fuzs.mutantmonsters.animation.Animation;
import fuzs.mutantmonsters.core.SeismicWave;
import fuzs.mutantmonsters.core.ZombieResurrection;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import fuzs.puzzleslib.api.entity.v1.AdditionalAddEntityData;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1368;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1439;
import net.minecraft.class_1528;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class MutantZombie
extends class_1588
implements AnimatedEntity {
    private static final class_2940<Integer> LIVES = class_2945.method_12791(MutantZombie.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> THROW_ATTACK_STATE = class_2945.method_12791(MutantZombie.class, (class_2941)class_2943.field_13319);
    public static final int MAX_VANISH_TIME = 100;
    public static final int MAX_DEATH_TIME = 140;
    public static final Animation SLAM_GROUND_ANIMATION = new Animation(25);
    public static final Animation THROW_ANIMATION = new Animation(15);
    public static final Animation ROAR_ANIMATION = new Animation(120);
    private static final Animation[] ANIMATIONS = new Animation[]{SLAM_GROUND_ANIMATION, THROW_ANIMATION, ROAR_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private final List<SeismicWave> seismicWaveList = new ArrayList<SeismicWave>();
    private final List<ZombieResurrection> resurrectionList = new ArrayList<ZombieResurrection>();
    private class_1282 deathCause;

    public MutantZombie(class_1299<? extends MutantZombie> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6013 = 1.0f;
        this.field_6194 = 30;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SlamGroundGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RoarGoal(this));
        this.field_6201.method_6277(0, (class_1352)new ThrowAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.2).setMaxAttackTick(0));
        this.field_6201.method_6277(2, (class_1352)new AvoidDamageGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1368((class_1314)this, 1.0, true, 4, () -> false));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HurtByNearestTargetGoal((class_1314)this, class_1528.class).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
    }

    public static class_5132.class_5133 registerAttributes() {
        return MutantZombie.method_26918().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.26).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LIVES, (Object)3);
        this.field_6011.method_12784(THROW_ATTACK_STATE, (Object)0);
    }

    public int getLives() {
        return (Integer)this.field_6011.method_12789(LIVES);
    }

    private void setLives(int lives) {
        this.field_6011.method_12778(LIVES, (Object)lives);
    }

    public boolean hasThrowAttackHit() {
        return ((Byte)this.field_6011.method_12789(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean hit) {
        byte b0 = (Byte)this.field_6011.method_12789(THROW_ATTACK_STATE);
        this.field_6011.method_12778(THROW_ATTACK_STATE, (Object)(hit ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isThrowAttackFinished() {
        return ((Byte)this.field_6011.method_12789(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean finished) {
        byte b0 = (Byte)this.field_6011.method_12789(THROW_ATTACK_STATE);
        this.field_6011.method_12778(THROW_ATTACK_STATE, (Object)(finished ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return 2.8f;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new MutantGroundPathNavigation((class_1308)this, worldIn);
    }

    protected float method_6031(float renderYawOffset, float distance) {
        return this.field_6213 > 0 ? distance : super.method_6031(renderYawOffset, distance);
    }

    public int method_5945() {
        return 1;
    }

    public int method_5850() {
        return this.method_5968() != null ? (int)this.method_5739((class_1297)this.method_5968()) : 3;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public boolean method_5810() {
        return !this.method_6101();
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 itemInHand = player.method_5998(hand);
        class_1799 itemInHandCopy = itemInHand.method_7972();
        class_1269 interactionResult = this.deadMobInteract(player, hand);
        if (interactionResult.method_23665()) {
            if (player.method_31549().field_7477 && itemInHand == player.method_5998(hand) && itemInHand.method_7947() < itemInHandCopy.method_7947()) {
                itemInHand.method_7939(itemInHandCopy.method_7947());
            }
            if (itemInHand.method_7960() && !player.method_31549().field_7477) {
                player.method_6122(hand, class_1799.field_8037);
            }
            return interactionResult;
        }
        return super.method_5664(player, vec, hand);
    }

    private class_1269 deadMobInteract(class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (!(!itemInHand.method_31574(class_1802.field_8884) && !itemInHand.method_31574(class_1802.field_8814) || this.method_5805() || this.method_5809() || this.method_5721())) {
            this.field_6002.method_8465(player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15145, this.method_5634(), 1.0f, this.field_5974.nextFloat() * 0.4f + 0.8f);
            if (!this.field_6002.field_9236) {
                this.method_5639(8);
                if (!itemInHand.method_7963()) {
                    itemInHand.method_7934(1);
                } else {
                    itemInHand.method_7956(1, (class_1309)player, livingEntity -> livingEntity.method_20236(hand));
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)itemInHand.method_7909()));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean method_6121(class_1297 entityIn) {
        if (!this.isAnimationPlaying()) {
            if (entityIn.method_5854() != this && this.field_5974.nextInt(5) != 0) {
                if (this.field_5952 || !this.method_36601().method_26227().method_15769()) {
                    this.animation = SLAM_GROUND_ANIMATION;
                }
            } else {
                this.animation = THROW_ANIMATION;
            }
        }
        return true;
    }

    protected void method_5958() {
        if (!this.isAnimationPlaying() && this.method_5968() != null && Math.abs(this.method_23318() - this.method_5968().method_23318()) <= 1.0 && this.method_5858((class_1297)this.method_5968()) <= 49.0 && this.field_5974.nextInt(20) == 0) {
            this.animation = SLAM_GROUND_ANIMATION;
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        class_1297 entity = source.method_5529();
        return (entity == null || this.canHarm(entity) && (this.animation != THROW_ANIMATION || entity != this.method_5968())) && super.method_5643(source, amount);
    }

    protected void method_16827() {
    }

    public void method_5773() {
        super.method_5773();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        if (this.field_6002.method_23886() && this.field_6012 % 100 == 0 && this.method_5805() && this.method_6032() < this.method_6063()) {
            this.method_6025(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove((Object)zr);
        }
        if (this.method_6032() > 0.0f) {
            this.field_6213 = 0;
            this.vanishTime = 0;
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.field_6241 - this.field_6283; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.animation == SLAM_GROUND_ANIMATION) {
            offset = 0.2f;
        }
        this.field_6283 += yaw * offset;
    }

    private void updateAnimation() {
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.field_6002.field_9236) {
            if (this.animation == THROW_ANIMATION) {
                if (this.hasThrowAttackHit()) {
                    if (this.throwHitTick == -1) {
                        this.throwHitTick = 0;
                    }
                    ++this.throwHitTick;
                }
                if (this.isThrowAttackFinished()) {
                    if (this.throwFinishTick == -1) {
                        this.throwFinishTick = 0;
                    }
                    ++this.throwFinishTick;
                }
            } else {
                this.throwHitTick = -1;
                this.throwFinishTick = -1;
            }
        }
    }

    private void updateMeleeGrounds() {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(this.field_6002, (class_1297)this);
            class_238 box = new class_238((double)wave.method_10263(), (double)wave.method_10264() + 1.0, (double)wave.method_10260(), (double)wave.method_10263() + 1.0, (double)wave.method_10264() + 2.0, (double)wave.method_10260() + 1.0);
            if (wave.isFirst()) {
                double addScale = this.field_5974.nextDouble() * 0.75;
                box = box.method_1009(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            class_1282 source = class_1282.method_5511((class_1309)this).method_5509();
            for (class_1297 entity : this.field_6002.method_8333((class_1297)this, box, class_1301.field_6156.and(this::canHarm))) {
                if (entity instanceof class_1309 && entity.method_5643(source, wave.isFirst() ? (float)(9 + this.field_5974.nextInt(4)) : (float)(6 + this.field_5974.nextInt(3))) && this.field_5974.nextInt(5) == 0) {
                    ((class_1309)entity).method_6092(new class_1293(class_1294.field_5903, 160, 1));
                }
                double x = entity.method_23317() - this.method_23317();
                double z = entity.method_23321() - this.method_23321();
                double d = Math.sqrt(x * x + z * z);
                entity.method_18800(x / d * 0.3, 0.04, z / d * 0.3);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
        }
    }

    public class_238 method_5830() {
        return this.method_5829().method_1014(1.0);
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected void method_6060(class_1309 livingEntity) {
        livingEntity.field_6037 = true;
    }

    public void method_6078(class_1282 cause) {
        if (!this.field_6002.field_9236) {
            this.deathCause = cause;
            this.field_6201.method_19048().forEach(class_4135::method_6270);
            this.method_6114((class_1297)this.method_6065());
            this.field_6002.method_8421((class_1297)this, (byte)3);
            if (this.field_6238 > 0) {
                this.field_6238 += 140;
            }
        }
    }

    protected void method_6108() {
        if (this.field_6213 <= 25 || !this.method_5809() || this.field_6213 >= 100) {
            ++this.field_6213;
        }
        if (this.method_5809()) {
            if (this.vanishTime == 0) {
                EntityUtil.sendMetadataPacket((class_1297)this);
            }
            ++this.vanishTime;
        } else {
            this.vanishTime = Math.max(0, this.vanishTime - 1);
        }
        if (this.field_6213 >= 140) {
            this.field_6213 = 0;
            this.vanishTime = 0;
            this.deathCause = null;
            this.setLives(this.getLives() - 1);
            if (this.method_6052() != null) {
                this.method_6052().method_6015((class_1309)this);
            }
            this.method_6033(Math.round(this.method_6063() / 3.75f));
        }
        if (this.vanishTime >= 100 || this.getLives() <= 0 && this.field_6213 > 25) {
            if (!this.field_6002.field_9236) {
                super.method_6078(this.deathCause != null ? this.deathCause : class_1282.field_5869);
            }
            for (int i = 0; i < 30; ++i) {
                double d0 = this.field_5974.nextGaussian() * 0.02;
                double d1 = this.field_5974.nextGaussian() * 0.02;
                double d2 = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)(this.method_5809() ? class_2398.field_11240 : class_2398.field_11203), this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
            }
            this.method_31472();
        }
    }

    public void method_5768() {
        super.method_5768();
        this.setLives(0);
    }

    private boolean canHarm(class_1297 entity) {
        return entity.method_5864() != class_1299.field_6051 && entity.method_5864() != class_1299.field_6054 && entity.method_5864() != class_1299.field_6071 && entity.method_5864() != class_1299.field_6123 && !(entity instanceof MutantZombie);
    }

    public void method_5874(class_3218 serverWorld, class_1309 livingEntity) {
        if ((serverWorld.method_8407() == class_1267.field_5802 && this.field_5974.nextBoolean() || serverWorld.method_8407() == class_1267.field_5807) && livingEntity instanceof class_1646) {
            EntityUtil.convertMobWithNBT(livingEntity, class_1299.field_6054, false);
            if (!livingEntity.method_5701()) {
                serverWorld.method_8444(null, 1026, livingEntity.method_24515(), 0);
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Lives", this.getLives());
        compound.method_10575("VanishTime", (short)this.vanishTime);
        if (!this.resurrectionList.isEmpty()) {
            class_2499 listnbt = new class_2499();
            for (ZombieResurrection resurrection : this.resurrectionList) {
                class_2487 compoundNBT = class_2512.method_10692((class_2338)resurrection);
                compoundNBT.method_10569("Tick", resurrection.getTick());
                listnbt.add((Object)compoundNBT);
            }
            compound.method_10566("Resurrections", (class_2520)listnbt);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Lives")) {
            this.setLives(compound.method_10550("Lives"));
        }
        this.vanishTime = compound.method_10568("VanishTime");
        class_2499 listNBT = compound.method_10554("Resurrections", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            class_2487 compoundNBT = listNBT.method_10602(i);
            this.resurrectionList.add(i, new ZombieResurrection(this.field_6002, class_2512.method_10691((class_2487)compoundNBT), compoundNBT.method_10550("Tick")));
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_ZOMBIE_AMBIENT_SOUND_EVENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModRegistry.ENTITY_MUTANT_ZOMBIE_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_ZOMBIE_DEATH_SOUND_EVENT.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        if (this.field_6213 == 0) {
            this.method_5783(class_3417.field_14621, 0.15f, 1.0f);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(class_2540 buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.method_10804(this.field_6213);
        buffer.method_10804(this.vanishTime);
        buffer.method_10804(this.throwHitTick);
        buffer.method_10804(this.throwFinishTick);
    }

    @Override
    public void readAdditionalAddEntityData(class_2540 additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.field_6213 = additionalData.method_10816();
        this.vanishTime = additionalData.method_10816();
        this.throwHitTick = additionalData.method_10816();
        this.throwFinishTick = additionalData.method_10816();
    }

    public class_2596<class_2602> method_18002() {
        return AdditionalAddEntityData.getPacket((class_1297)this);
    }

    static class SlamGroundGoal
    extends AnimationGoal<MutantZombie> {
        private double dirX = -1.0;
        private double dirZ = -1.0;
        private class_1309 attackTarget;

        public SlamGroundGoal(MutantZombie mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected Animation getAnimation() {
            return SLAM_GROUND_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            this.attackTarget = ((MutantZombie)this.mob).method_5968();
            return this.attackTarget != null && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            ((MutantZombie)this.mob).field_6191 = -((MutantZombie)this.mob).method_5970();
            ((MutantZombie)this.mob).method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ZOMBIE_ATTACK_SOUND_EVENT.get(), 0.3f, 0.8f + ((MutantZombie)this.mob).field_5974.nextFloat() * 0.4f);
        }

        public void method_6268() {
            ((MutantZombie)this.mob).method_5942().method_6340();
            if (((MutantZombie)this.mob).animationTick < 8) {
                ((MutantZombie)this.mob).field_6206.method_6226((class_1297)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 8) {
                double x = this.attackTarget.method_23317() - ((MutantZombie)this.mob).method_23317();
                double z = this.attackTarget.method_23321() - ((MutantZombie)this.mob).method_23321();
                double d = Math.sqrt(x * x + z * z);
                this.dirX = x / d;
                this.dirZ = z / d;
            }
            if (((MutantZombie)this.mob).animationTick == 12) {
                int x = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23317() + this.dirX * 2.0));
                int y = class_3532.method_15357((double)((MutantZombie)this.mob).method_5829().field_1322);
                int z = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23321() + this.dirZ * 2.0));
                int x1 = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23317() + this.dirX * 8.0));
                int z1 = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23321() + this.dirZ * 8.0));
                SeismicWave.createWaves(((MutantZombie)this.mob).field_6002, ((MutantZombie)this.mob).seismicWaveList, x, z, x1, z1, y);
                ((MutantZombie)this.mob).method_5783(class_3417.field_15152, 0.5f, 0.8f + ((MutantZombie)this.mob).field_5974.nextFloat() * 0.4f);
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.dirX = -1.0;
            this.dirZ = -1.0;
            this.attackTarget = null;
        }
    }

    static class RoarGoal
    extends AnimationGoal<MutantZombie> {
        public RoarGoal(MutantZombie mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected Animation getAnimation() {
            return ROAR_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            return ((MutantZombie)this.mob).field_6012 % 3 == 0 && !((MutantZombie)this.mob).isAnimationPlaying() && ((MutantZombie)this.mob).method_5968() != null && ((MutantZombie)this.mob).field_5952 && ((MutantZombie)this.mob).resurrectionList.isEmpty() && ((MutantZombie)this.mob).method_5858((class_1297)((MutantZombie)this.mob).method_5968()) > 16.0 && ((MutantZombie)this.mob).field_5974.nextFloat() * 100.0f < 0.35f;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            ((MutantZombie)this.mob).field_6008 = 20;
            ((MutantZombie)this.mob).field_6191 = -((MutantZombie)this.mob).method_5970();
        }

        public void method_6268() {
            ((MutantZombie)this.mob).method_5942().method_6340();
            if (((MutantZombie)this.mob).animationTick < 75 && ((MutantZombie)this.mob).method_5968() != null) {
                ((MutantZombie)this.mob).field_6206.method_6226((class_1297)((MutantZombie)this.mob).method_5968(), 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 10) {
                ((MutantZombie)this.mob).method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ZOMBIE_ROAR_SOUND_EVENT.get(), 3.0f, 0.7f + ((MutantZombie)this.mob).field_5974.nextFloat() * 0.2f);
                for (class_1297 entity : ((MutantZombie)this.mob).field_6002.method_8335((class_1297)this.mob, ((MutantZombie)this.mob).method_5829().method_1009(12.0, 8.0, 12.0))) {
                    if (!((MutantZombie)this.mob).canHarm(entity) || !(((MutantZombie)this.mob).method_5858(entity) <= 196.0)) continue;
                    double x = entity.method_23317() - ((MutantZombie)this.mob).method_23317();
                    double z = entity.method_23321() - ((MutantZombie)this.mob).method_23321();
                    double d = Math.sqrt(x * x + z * z);
                    entity.method_18800(x / d * (double)0.7f, (double)0.3f, z / d * (double)0.7f);
                    entity.method_5643(class_1282.method_5511((class_1309)this.mob).method_5508().method_5509(), (float)(2 + ((MutantZombie)this.mob).field_5974.nextInt(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (((MutantZombie)this.mob).animationTick >= 20 && ((MutantZombie)this.mob).animationTick < 80 && ((MutantZombie)this.mob).animationTick % 10 == 0) {
                int x = class_3532.method_15357((double)((MutantZombie)this.mob).method_23317());
                int y = class_3532.method_15357((double)((MutantZombie)this.mob).method_5829().field_1322);
                int z = class_3532.method_15357((double)((MutantZombie)this.mob).method_23321());
                y = ZombieResurrection.getSuitableGround(((MutantZombie)this.mob).field_6002, x += (1 + ((MutantZombie)this.mob).field_5974.nextInt(8)) * (((MutantZombie)this.mob).field_5974.nextBoolean() ? 1 : -1), y - 1, z += (1 + ((MutantZombie)this.mob).field_5974.nextInt(8)) * (((MutantZombie)this.mob).field_5974.nextBoolean() ? 1 : -1));
                if (y != -1) {
                    ((MutantZombie)this.mob).resurrectionList.add(new ZombieResurrection(((MutantZombie)this.mob).field_6002, x, y, z));
                }
            }
        }
    }

    static class ThrowAttackGoal
    extends AnimationGoal<MutantZombie> {
        private class_1309 attackTarget;
        private int finish = -1;

        public ThrowAttackGoal(MutantZombie mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            this.attackTarget = ((MutantZombie)this.mob).method_5968();
            return this.attackTarget != null && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.attackTarget.method_5848();
            double x = this.attackTarget.method_23317() - ((MutantZombie)this.mob).method_23317();
            double z = this.attackTarget.method_23321() - ((MutantZombie)this.mob).method_23321();
            double d = Math.sqrt(x * x + z * z);
            this.attackTarget.method_18800(x / d * (double)0.8f, (double)1.6f, z / d * (double)0.8f);
            EntityUtil.sendPlayerVelocityPacket((class_1297)this.attackTarget);
        }

        @Override
        public boolean method_6266() {
            return super.method_6264() && this.finish < 10;
        }

        public void method_6268() {
            ((MutantZombie)this.mob).method_5942().method_6340();
            ((MutantZombie)this.mob).field_6206.method_6226((class_1297)this.attackTarget, 30.0f, 30.0f);
            if (((MutantZombie)this.mob).animationTick == THROW_ANIMATION.duration()) {
                ((MutantZombie)this.mob).field_17046 = class_243.field_1353;
                double d1 = this.attackTarget.method_23317() - ((MutantZombie)this.mob).method_23317();
                double d2 = this.attackTarget.method_23318() - ((MutantZombie)this.mob).method_23318();
                double x = this.attackTarget.method_23321() - ((MutantZombie)this.mob).method_23321();
                double z = Math.sqrt(d1 * d1 + d2 * d2 + x * x);
                ((MutantZombie)this.mob).method_18800(d1 / z * (double)3.4f, d2 / z * (double)1.4f, x / z * (double)3.4f);
            } else if (((MutantZombie)this.mob).animationTick > THROW_ANIMATION.duration()) {
                double d1 = ((MutantZombie)this.mob).method_17681() * 2.0f * ((MutantZombie)this.mob).method_17681() * 2.0f;
                double d2 = ((MutantZombie)this.mob).method_5649(this.attackTarget.method_23317(), this.attackTarget.method_5829().field_1322, this.attackTarget.method_23321());
                if (d2 < d1 && !((MutantZombie)this.mob).hasThrowAttackHit()) {
                    ((MutantZombie)this.mob).setThrowAttackHit(true);
                    if (!this.attackTarget.method_5643(class_1282.method_5511((class_1309)this.mob), (float)((MutantZombie)this.mob).method_26825(class_5134.field_23721))) {
                        EntityUtil.disableShield(this.attackTarget, 150);
                    }
                    double x = this.attackTarget.method_23317() - ((MutantZombie)this.mob).method_23317();
                    double z = this.attackTarget.method_23321() - ((MutantZombie)this.mob).method_23321();
                    double d = Math.sqrt(x * x + z * z);
                    this.attackTarget.method_18800(x / d * (double)0.6f, (double)-1.2f, z / d * (double)0.6f);
                    this.attackTarget.field_6008 = 10;
                    EntityUtil.sendPlayerVelocityPacket((class_1297)this.attackTarget);
                    EntityUtil.stunRavager(this.attackTarget);
                    ((MutantZombie)this.mob).method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ZOMBIE_GRUNT_SOUND_EVENT.get(), 0.3f, 0.8f + ((MutantZombie)this.mob).field_5974.nextFloat() * 0.4f);
                }
                if (!(!((MutantZombie)this.mob).field_5952 && ((MutantZombie)this.mob).method_36601().method_26227().method_15769() || ((MutantZombie)this.mob).isThrowAttackFinished())) {
                    this.finish = 0;
                    ((MutantZombie)this.mob).setThrowAttackFinished(true);
                }
                if (this.finish >= 0) {
                    ++this.finish;
                }
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.finish = -1;
            ((MutantZombie)this.mob).setThrowAttackHit(false);
            ((MutantZombie)this.mob).setThrowAttackFinished(false);
            this.attackTarget = null;
        }
    }
}

