/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.entity.SkullSpirit;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.level.ExplosionInteraction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutatedExplosion
extends class_1927 {
    private final class_1937 world;
    private final float size;

    private MutatedExplosion(class_1937 worldIn, @Nullable class_1297 exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, class_1927.class_4179 modeIn) {
        super(worldIn, exploderIn, null, null, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
        this.world = worldIn;
        this.size = sizeIn;
    }

    public void method_8348() {
        if (!(this.size <= 0.0f)) {
            double z;
            double y;
            double x;
            int l;
            int k;
            HashSet<class_2338> set = new HashSet<class_2338>();
            class_1297 exploder = CommonAbstractions.INSTANCE.getExplosionExploder(this);
            class_243 position = CommonAbstractions.INSTANCE.getExplosionPosition(this);
            class_5362 explosionContext = exploder == null ? new class_5362() : new class_5361(exploder);
            for (int j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    for (l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        x = position.field_1352;
                        y = position.field_1351;
                        z = position.field_1350;
                        float attenuation = 0.3f;
                        for (float intensity = this.size * (0.7f + this.world.field_9229.nextFloat() * 0.6f); intensity > 0.0f; intensity -= 0.22500001f) {
                            class_2338 blockpos = new class_2338(x, y, z);
                            class_2680 blockstate = this.world.method_8320(blockpos);
                            Optional optional = explosionContext.method_29555((class_1927)this, (class_1922)this.world, blockpos, blockstate, class_3612.field_15906.method_15785());
                            if (optional.isPresent()) {
                                intensity -= (((Float)optional.get()).floatValue() + attenuation) * attenuation;
                            }
                            if (intensity > 0.0f && explosionContext.method_29554((class_1927)this, (class_1922)this.world, blockpos, blockstate, intensity)) {
                                set.add(blockpos);
                            }
                            x += d0 * (double)attenuation;
                            y += d1 * (double)attenuation;
                            z += d2 * (double)attenuation;
                        }
                    }
                }
            }
            this.method_8346().addAll(set);
            float diameter = this.size * 2.0f;
            k = class_3532.method_15357((double)(position.field_1352 - (double)diameter - 1.0));
            l = class_3532.method_15357((double)(position.field_1352 + (double)diameter + 1.0));
            int minY = class_3532.method_15357((double)(position.field_1351 - (double)diameter - 1.0));
            int maxY = class_3532.method_15357((double)(position.field_1351 + (double)diameter + 1.0));
            int minZ = class_3532.method_15357((double)(position.field_1350 - (double)diameter - 1.0));
            int maxZ = class_3532.method_15357((double)(position.field_1350 + (double)diameter + 1.0));
            List list = this.world.method_8333(exploder, new class_238((double)k, (double)minY, (double)minZ, (double)l, (double)maxY, (double)maxZ), entityx -> {
                if (entityx.method_5659()) {
                    return false;
                }
                if (exploder instanceof SkullSpirit) {
                    SkullSpirit skullSpirit = (SkullSpirit)exploder;
                    if (entityx == skullSpirit.getTarget()) {
                        return !skullSpirit.isAttached();
                    }
                    return !(entityx instanceof class_1309) || ChemicalXMobEffect.IS_APPLICABLE.test((class_1309)entityx);
                }
                return true;
            });
            CommonAbstractions.INSTANCE.onExplosionDetonate(this.world, this, list, diameter);
            Iterator var11 = list.iterator();
            while (true) {
                class_1657 playerentity;
                double d0;
                if (!var11.hasNext()) {
                    return;
                }
                class_1297 entity = (class_1297)var11.next();
                double distance = class_3532.method_15355((float)((float)entity.method_5707(position))) / diameter;
                if (!(distance <= 1.0) || (d0 = (double)class_3532.method_15355((float)((float)((x = entity.method_23317() - position.field_1352) * x + (y = entity.method_23320() - position.field_1351) * y + (z = entity.method_23321() - position.field_1350) * z)))) == 0.0) continue;
                x /= d0;
                y /= d0;
                z /= d0;
                double impact = (1.0 - distance) * (double)MutatedExplosion.method_17752((class_243)position, (class_1297)entity);
                float damage = (int)((impact * impact + impact) / 2.0 * 6.0 * (double)diameter + 1.0);
                if (!entity.method_5643(this.method_8349(), damage) && exploder instanceof MutantCreeper) {
                    MutantCreeper mutantCreeper = (MutantCreeper)exploder;
                    if (entity instanceof class_1657) {
                        class_1657 player = (class_1657)entity;
                        if (((class_1657)entity).method_6039()) {
                            if (mutantCreeper.isJumpAttacking()) {
                                EntityUtil.disableShield((class_1309)player, mutantCreeper.isCharged() ? 200 : 100);
                                entity.method_5643(this.method_8349(), damage * 0.5f);
                            } else {
                                player.method_6030().method_7956((int)damage * 2, (class_1309)player, e -> e.method_20236(player.method_6058()));
                                entity.method_5643(this.method_8349(), damage * 0.5f);
                            }
                        }
                    }
                }
                double exposure = impact;
                if (entity instanceof class_1309) {
                    exposure = class_1900.method_8237((class_1309)((class_1309)entity), (double)impact);
                }
                if (!(entity instanceof MutantCreeper)) {
                    entity.method_18799(entity.method_18798().method_1031(x * exposure, y * exposure, z * exposure));
                }
                if (!(entity instanceof class_1657) || (playerentity = (class_1657)entity).method_7325() || playerentity.method_7337() && playerentity.method_31549().field_7479) continue;
                this.method_8351().put(playerentity, new class_243(x * impact, y * impact, z * impact));
            }
        }
    }

    public static MutatedExplosion create(@NotNull class_1297 exploderIn, float sizeIn, boolean causesFireIn, ExplosionInteraction interaction) {
        return MutatedExplosion.create(exploderIn.field_6002, exploderIn, exploderIn.method_23317(), exploderIn.method_23318(), exploderIn.method_23321(), sizeIn, causesFireIn, interaction);
    }

    public static MutatedExplosion create(class_1937 worldIn, @Nullable class_1297 exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, ExplosionInteraction interaction) {
        class_1927.class_4179 mode = MutatedExplosion.getExplosionInteraction(worldIn, exploderIn, interaction);
        MutatedExplosion explosion = new MutatedExplosion(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, mode);
        if (!CommonAbstractions.INSTANCE.onExplosionStart(worldIn, explosion) && worldIn instanceof class_3218) {
            explosion.method_8348();
            explosion.method_8350(false);
            if (mode == class_1927.class_4179.field_18685) {
                explosion.method_8352();
            }
            for (class_3222 serverplayerentity : ((class_3218)worldIn).method_18456()) {
                if (!(serverplayerentity.method_5649(xIn, yIn, zIn) < 4096.0)) continue;
                serverplayerentity.field_13987.method_14364((class_2596)new class_2664(xIn, yIn, zIn, sizeIn, explosion.method_8346(), (class_243)explosion.method_8351().get(serverplayerentity)));
            }
        }
        return explosion;
    }

    public static class_1927.class_4179 getExplosionInteraction(class_1937 level, @Nullable class_1297 entity, ExplosionInteraction interaction) {
        return switch (interaction) {
            default -> throw new IncompatibleClassChangeError();
            case ExplosionInteraction.NONE -> class_1927.class_4179.field_18685;
            case ExplosionInteraction.BLOCK -> class_1927.class_4179.field_18687;
            case ExplosionInteraction.MOB -> {
                if (CommonAbstractions.INSTANCE.getMobGriefingEvent(level, entity)) {
                    yield class_1927.class_4179.field_18687;
                }
                yield class_1927.class_4179.field_18685;
            }
            case ExplosionInteraction.TNT -> class_1927.class_4179.field_18686;
        };
    }
}

