/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CAnimationMessage;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import fuzs.puzzleslib.init.PotionBrewingRegistry;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.NetworkHandler;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5483;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutantMonsters
implements ModConstructor {
    public static final String MOD_ID = "mutantmonsters";
    public static final String MOD_NAME = "Mutant Monsters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mutant Monsters");
    public static final ConfigHolder CONFIG = CommonFactories.INSTANCE.commonConfig(CommonConfig.class, () -> new CommonConfig());
    public static final NetworkHandler NETWORK = CommonFactories.INSTANCE.network("mutantmonsters");

    public static class_2960 id(String name) {
        return new class_2960(MOD_ID, name);
    }

    public void onConstructMod() {
        CONFIG.bakeConfigs(MOD_ID);
        ModRegistry.touch();
        MutantMonsters.registerMessages();
    }

    public void onCommonSetup() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8985, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModRegistry.ENDERSOUL_HAND_ITEM.get(), (class_1935)ModRegistry.HULK_HAMMER_ITEM.get(), (class_1935)ModRegistry.CREEPER_SHARD_ITEM.get(), (class_1935)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get()}), (class_1842)ModRegistry.CHEMICAL_X_POTION.get());
    }

    private static void registerMessages() {
        NETWORK.register(C2SCreeperMinionTrackerMessage.class, C2SCreeperMinionTrackerMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CMutantLevelParticlesMessage.class, S2CMutantLevelParticlesMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SCreeperMinionNameMessage.class, C2SCreeperMinionNameMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CAnimationMessage.class, S2CAnimationMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(S2CSeismicWaveFluidParticlesMessage.class, S2CSeismicWaveFluidParticlesMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(S2CMutantEndermanHeldBlockMessage.class, S2CMutantEndermanHeldBlockMessage::new, MessageDirection.TO_CLIENT);
    }

    public void onEntityAttributeCreation(ModConstructor.EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get(), CreeperMinion.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get(), EndersoulClone.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get(), MutantCreeper.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get(), MutantEnderman.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get(), MutantSnowGolem.registerAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), SpiderPig.registerAttributes());
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isForge()) {
            context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), MutantSkeleton.registerAttributes());
            context.registerEntityAttributes((class_1299)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), MutantZombie.registerAttributes());
        }
    }

    public void onRegisterSpawnPlacements(ModConstructor.SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MutantEnderman::canSpawn);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13197, class_1429::method_20663);
    }

    public void onRegisterBiomeModifications(ModConstructor.BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> true, biomeModificationContext -> {
            MobSpawnSettingsContext spawnSettings = biomeModificationContext.mobSpawnSettings();
            CommonConfig config = (CommonConfig)CONFIG.get(CommonConfig.class);
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantCreeperSpawnWeight, class_1311.field_6302, class_1299.field_6046, (class_1299)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantEndermanSpawnWeight, class_1311.field_6302, class_1299.field_6091, (class_1299)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantSkeletonSpawnWeight, class_1311.field_6302, class_1299.field_6137, (class_1299)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantZombieSpawnWeight, class_1311.field_6302, class_1299.field_6051, (class_1299)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get());
        });
    }

    private static void addMutantSpawn(MobSpawnSettingsContext spawnSettings, double spawnWeight, class_1311 mobCategory, class_1299<?> entityType, class_1299<?> mutantEntityType) {
        if (spawnWeight == 0.0) {
            return;
        }
        spawnSettings.getSpawnerData(mobCategory).stream().filter(data -> data.field_9389 == entityType).findAny().ifPresent(spawnerData -> spawnSettings.addSpawn(mobCategory, new class_5483.class_1964(mutantEntityType, Math.max(1, (int)((double)spawnerData.method_34979().method_34976() * spawnWeight)), 1, 1)));
        class_5483.class_5265 mobSpawnCost = spawnSettings.getSpawnCost(entityType);
        if (mobSpawnCost != null) {
            spawnSettings.setSpawnCost(mutantEntityType, mobSpawnCost.method_27838() / spawnWeight, mobSpawnCost.method_27837() * spawnWeight);
        }
    }
}

