/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import fuzs.puzzleslib.config.serialization.ConfigDataSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class CommonConfig
implements ConfigCore {
    public double mutantCreeperSpawnWeight;
    public double mutantEndermanSpawnWeight;
    public double mutantSkeletonSpawnWeight;
    public double mutantZombieSpawnWeight;
    @Config(name="mutant_x_conversions", description={"When infested with a Mutant X potion, what mutant mob should the target transform into. Otherwise the target will ony explode and take damage.", "Format for every entry is \"<namespace>:<path>,<namespace>:<path>\" with the second id representing the mutant. Namespace may be omitted to use \"minecraft\" by default."})
    List<String> mutantXConversionsRaw = Lists.newArrayList((Object[])new String[]{"minecraft:creeper,mutantmonsters:mutant_creeper", "minecraft:enderman,mutantmonsters:mutant_enderman", "minecraft:skeleton,mutantmonsters:mutant_skeleton", "minecraft:snow_golem,mutantmonsters:mutant_snow_golem", "minecraft:zombie,mutantmonsters:mutant_zombie", "minecraft:pig,mutantmonsters:spider_pig"});
    public Map<class_1299<?>, class_1299<?>> mutantXConversions;

    public void addToBuilder(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Weight for mutant creeper spawns as a percentage of the vanilla creeper spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_creeper_spawn_weight", 0.05, 0.0, 1.0), v -> {
            this.mutantCreeperSpawnWeight = v;
        });
        callback.accept((Supplier)builder.comment("Weight for mutant enderman spawns as a percentage of the vanilla enderman spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_enderman_spawn_weight", 0.05, 0.0, 1.0), v -> {
            this.mutantEndermanSpawnWeight = v;
        });
        callback.accept((Supplier)builder.comment("Weight for mutant skeleton spawns as a percentage of the vanilla skeleton spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_skeleton_spawn_weight", 0.05, 0.0, 1.0), v -> {
            this.mutantSkeletonSpawnWeight = v;
        });
        callback.accept((Supplier)builder.comment("Weight for mutant zombie spawns as a percentage of the vanilla zombie spawn weight. Mutants can spawn in every biome and dimension where their vanilla counterparts can be found.").worldRestart().defineInRange("mutant_zombie_spawn_weight", 0.05, 0.0, 1.0), v -> {
            this.mutantZombieSpawnWeight = v;
        });
    }

    public void afterConfigReload() {
        ConfigDataSet configDataSet = ConfigDataSet.of((class_5321)class_2378.field_25107, this.mutantXConversionsRaw, (integer, o) -> true, (Class[])new Class[]{String.class});
        record MutantXConversion(class_1299<?> entityType, @Nullable class_2960 convertsTo) {
            public boolean isValid() {
                if (this.convertsTo != null && class_2378.field_11145.method_10250(this.convertsTo)) {
                    return true;
                }
                MutantMonsters.LOGGER.warn("Unable to parse mutated variant for entry {}", (Object)class_2378.field_11145.method_10221(this.entityType));
                return false;
            }

            public class_1299<?> convertsToType() {
                return (class_1299)class_2378.field_11145.method_10223(this.convertsTo);
            }
        }
        this.mutantXConversions = (Map)configDataSet.toMap().entrySet().stream().map(data -> new MutantXConversion((class_1299)data.getKey(), class_2960.method_12829((String)((String)((Object[])data.getValue())[0])))).filter(MutantXConversion::isValid).collect(ImmutableMap.toImmutableMap(MutantXConversion::entityType, MutantXConversion::convertsToType));
    }
}

