/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.capability.SeismicWavesCapability;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.core.SeismicWave;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3902;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    private static final int MAX_SEISMIC_WAVES_PER_PLAYER = 16;

    public static OptionalInt onItemUseTick(class_1309 entity, class_1799 item, int duration) {
        if (entity.method_6118(class_1304.field_6174).method_7909() == ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.get() && item.method_7909() instanceof class_1753 && item.method_7935() - duration < 20) {
            return OptionalInt.of(duration - 3);
        }
        return OptionalInt.empty();
    }

    public static Optional<class_3902> onArrowLoose(class_1657 player, class_1799 bow, class_1937 level, int charge, boolean hasAmmo) {
        if (player.method_6118(class_1304.field_6169).method_7909() == ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get() && hasAmmo) {
            boolean inAir = !player.method_24828() && !player.method_5799() && !player.method_5771();
            class_1799 ammo = player.method_18808(bow);
            if (!ammo.method_7960() || hasAmmo) {
                boolean infiniteArrows;
                if (ammo.method_7960()) {
                    ammo = new class_1799((class_1935)class_1802.field_8107);
                }
                float velocity = class_1753.method_7722((int)(bow.method_7935() - charge));
                boolean bl = infiniteArrows = player.method_31549().field_7477 || ammo.method_7909() instanceof class_1744 && CommonAbstractions.INSTANCE.isArrowInfinite((class_1744)ammo.method_7909(), ammo, bow, player);
                if (!level.field_9236) {
                    int k;
                    int j;
                    class_1744 arrowitem = (class_1744)(ammo.method_7909() instanceof class_1744 ? ammo.method_7909() : class_1802.field_8107);
                    class_1665 abstractarrowentity = arrowitem.method_7702(level, ammo, (class_1309)player);
                    abstractarrowentity = CommonAbstractions.INSTANCE.getCustomArrowShotFromBow((class_1753)bow.method_7909(), abstractarrowentity);
                    abstractarrowentity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, velocity * 3.0f, 1.0f);
                    if (velocity == 1.0f && inAir) {
                        abstractarrowentity.method_7439(true);
                    }
                    if ((j = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)bow)) > 0) {
                        abstractarrowentity.method_7438(abstractarrowentity.method_7448() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)bow)) > 0) {
                        abstractarrowentity.method_7449(k);
                    }
                    if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)bow) > 0) {
                        abstractarrowentity.method_5639(100);
                    }
                    abstractarrowentity.method_7438(abstractarrowentity.method_7448() * (inAir ? 2.0 : 0.5));
                    bow.method_7956(1, (class_1309)player, p_220009_1_ -> p_220009_1_.method_20236(player.method_6058()));
                    if (infiniteArrows || player.method_31549().field_7477 && (ammo.method_7909() == class_1802.field_8236 || ammo.method_7909() == class_1802.field_8087)) {
                        abstractarrowentity.field_7572 = class_1665.class_1666.field_7594;
                    }
                    level.method_8649((class_1297)abstractarrowentity);
                }
                level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (player.method_6051().method_43057() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!infiniteArrows && !player.method_31549().field_7477) {
                    ammo.method_7934(1);
                    if (ammo.method_7960()) {
                        player.method_31548().method_7378(ammo);
                    }
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)bow.method_7909()));
            }
            return Optional.of(class_3902.field_17274);
        }
        return Optional.empty();
    }

    public static void onPlayerTick$End(class_1657 player) {
        PlayerEventsHandler.playShoulderEntitySound(player, player.method_7356());
        PlayerEventsHandler.playShoulderEntitySound(player, player.method_7308());
        if (!player.field_6002.field_9236) {
            ModRegistry.SEISMIC_WAVES_CAPABILITY.maybeGet((Object)player).map(SeismicWavesCapability::getSeismicWaves).ifPresent(seismicWaves -> {
                while (seismicWaves.size() > 16) {
                    seismicWaves.poll();
                }
                if (!seismicWaves.isEmpty()) {
                    PlayerEventsHandler.handleSeismicWave(player, (SeismicWave)((Object)((Object)seismicWaves.poll())));
                }
            });
        }
    }

    private static void handleSeismicWave(class_1657 player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(player.field_6002, (class_1297)player);
        class_238 box = new class_238((double)seismicWave.method_10263(), (double)seismicWave.method_10264() + 1.0, (double)seismicWave.method_10260(), (double)seismicWave.method_10263() + 1.0, (double)seismicWave.method_10264() + 2.0, (double)seismicWave.method_10260() + 1.0);
        for (class_1309 livingEntity : player.field_6002.method_18467(class_1309.class, box)) {
            if (livingEntity == player || player.method_5854() == livingEntity) continue;
            livingEntity.method_5643(class_1282.method_5532((class_1657)player).method_5509(), (float)(6 + player.method_6051().method_43048(3)));
        }
    }

    private static void playShoulderEntitySound(class_1657 player, @Nullable class_2487 compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.method_10545("Silent")) break block2;
                if (compoundNBT.method_10577("Silent")) break block3;
            }
            class_1299.method_5898((String)compoundNBT.method_10558("id")).filter(((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get())::equals).ifPresent(entityType -> {
                if (player.field_6002.field_9229.method_43048(500) == 0) {
                    player.field_6002.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)ModRegistry.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.get(), player.method_5634(), 1.0f, (player.field_6002.field_9229.method_43057() - player.field_6002.field_9229.method_43057()) * 0.2f + 1.5f);
                }
            });
        }
    }

    public static Optional<class_3902> onItemToss(class_1542 entityItem, class_1657 player) {
        class_1937 world = player.field_6002;
        if (!world.field_9236) {
            boolean isHand;
            class_1799 stack = entityItem.method_6983();
            boolean bl = isHand = stack.method_7909() == ModRegistry.ENDERSOUL_HAND_ITEM.get() && stack.method_7986();
            if (stack.method_7909() == class_1802.field_8449 || isHand) {
                int count = 0;
                for (EndersoulFragment orb : world.method_18467(EndersoulFragment.class, player.method_5829().method_1014(8.0))) {
                    if (orb.getOwner() != player) continue;
                    ++count;
                    orb.method_31472();
                }
                if (count > 0) {
                    EntityUtil.sendParticlePacket((class_1297)player, (class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), 256);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.method_7919() - addDmg;
                        stack.method_7974(Math.max(dmg, 0));
                    } else {
                        class_1799 newStack = new class_1799((class_1935)ModRegistry.ENDERSOUL_HAND_ITEM.get());
                        newStack.method_7974(((class_1792)ModRegistry.ENDERSOUL_HAND_ITEM.get()).method_7841() - addDmg);
                        entityItem.method_6979(newStack);
                    }
                }
            }
        }
        return Optional.empty();
    }
}

