/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4050;

public class CreeperMinionEgg
extends class_1297 {
    private static final class_2940<Boolean> CHARGED = class_2945.method_12791(CreeperMinionEgg.class, (class_2941)class_2943.field_13323);
    private int health = 8;
    private int age = (60 + this.field_5974.method_43048(40)) * 1200;
    private int recentlyHit;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private UUID ownerUUID;
    private int dismountTicks;

    public CreeperMinionEgg(class_1299<? extends CreeperMinionEgg> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
    }

    public CreeperMinionEgg(MutantCreeper spawner, class_1297 owner) {
        this((class_1299<? extends CreeperMinionEgg>)((class_1299)ModRegistry.CREEPER_MINION_EGG_ENTITY_TYPE.get()), spawner.field_6002);
        this.ownerUUID = owner.method_5667();
        this.method_5814(spawner.method_23317(), spawner.method_23318(), spawner.method_23321());
        if (spawner.isCharged()) {
            this.setCharged(true);
        }
    }

    protected void method_5693() {
        this.field_6011.method_12784(CHARGED, (Object)false);
    }

    public boolean isCharged() {
        return (Boolean)this.field_6011.method_12789(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_6011.method_12778(CHARGED, (Object)charged);
    }

    public double method_5678() {
        return this.method_5854() instanceof class_1657 ? (double)this.method_17682() - (this.method_5854().method_18376() == class_4050.field_18081 ? 0.35 : 0.2) : 0.0;
    }

    public double method_5621() {
        return this.method_17682();
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_30949(class_1297 entity) {
        return class_1690.method_30959((class_1297)this, (class_1297)entity);
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public boolean method_5810() {
        return this.method_5805();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.method_5759(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        this.method_18800(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void method_5750(double x, double y, double z) {
        super.method_5750(x, y, z);
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
    }

    private void hatch() {
        class_1657 playerEntity;
        CreeperMinion minion = (CreeperMinion)((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get()).method_5883(this.field_6002);
        if (this.ownerUUID != null && (playerEntity = this.field_6002.method_18470(this.ownerUUID)) != null && !CommonAbstractions.INSTANCE.onAnimalTame((class_1429)minion, playerEntity)) {
            minion.method_6170(playerEntity);
            minion.method_24346(true);
        }
        if (this.isCharged()) {
            minion.setCharged(true);
        }
        minion.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
        this.field_6002.method_8649((class_1297)minion);
        this.method_5783((class_3414)ModRegistry.ENTITY_CREEPER_MINION_EGG_HATCH_SOUND_EVENT.get(), 0.7f, 0.9f + this.field_5974.method_43057() * 0.1f);
        this.method_31472();
    }

    public void method_5800(class_3218 serverWorld, class_1538 lightningBoltEntity) {
        super.method_5800(serverWorld, lightningBoltEntity);
        this.setCharged(true);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1023(0.0, 0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.98));
        if (this.field_5952) {
            this.method_18799(this.method_18798().method_18805(0.7, 0.0, 0.7));
        }
        if (this.method_5765()) {
            if (this.method_31483() != null) {
                this.dismountTicks = 10;
            } else if (this.dismountTicks > 0) {
                --this.dismountTicks;
            }
            class_1297 rootVehicle = this.method_5668();
            if (this.method_5757() || !rootVehicle.method_41328(class_4050.field_18076) && !rootVehicle.method_41328(class_4050.field_18081) || this.dismountTicks <= 0 && rootVehicle.method_5715() || rootVehicle.method_7325()) {
                this.method_5848();
                this.playMountSound(false);
            }
        }
        if (!this.field_6002.field_9236) {
            if (this.health < 8 && this.field_6012 - this.recentlyHit > 80 && this.field_6012 % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0) {
                this.hatch();
            }
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_21823() && player.method_41328(class_4050.field_18076)) {
            class_1297 topPassenger = this.getTopPassenger((class_1297)player);
            this.method_5873(topPassenger, true);
            this.playMountSound(true);
            if (this.field_6002.field_9236) {
                Proxy.INSTANCE.showDismountMessage();
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return class_1269.field_5811;
    }

    private class_1297 getTopPassenger(class_1297 entity) {
        List list = entity.method_5685();
        return !list.isEmpty() ? this.getTopPassenger((class_1297)list.get(0)) : entity;
    }

    private void playMountSound(boolean mount) {
        this.method_5783(class_3417.field_15197, 0.7f, (mount ? 0.6f : 0.3f) + this.field_5974.method_43057() * 0.1f);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.field_6002.field_9236 && this.method_5805()) {
            this.method_5785();
            if (source.method_5535()) {
                this.age = (int)((float)this.age - amount * 80.0f);
                EntityUtil.sendParticlePacket(this, (class_2394)class_2398.field_11201, (int)(amount / 2.0f));
                return false;
            }
            this.recentlyHit = this.field_6012;
            this.method_18800(0.0, 0.2, 0.0);
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                MutatedExplosion.create(this, this.isCharged() ? 2.0f : 0.0f, false, class_1927.class_4179.field_18686);
                if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                    if (!this.isCharged() && this.field_5974.method_43048(3) != 0) {
                        for (int i = 5 + this.field_5974.method_43048(6); i > 0; --i) {
                            this.method_5706((class_1935)class_1802.field_8054);
                        }
                    } else {
                        this.method_5706((class_1935)ModRegistry.CREEPER_SHARD_ITEM.get());
                    }
                }
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10569("Health", this.health);
        compound.method_10569("Age", this.age);
        compound.method_10569("RecentlyHit", this.recentlyHit);
        if (this.isCharged()) {
            compound.method_10556("Charged", true);
        }
        if (this.ownerUUID != null) {
            compound.method_25927("Owner", this.ownerUUID);
        }
        compound.method_10567("DismountTicks", (byte)this.dismountTicks);
    }

    protected void method_5749(class_2487 compound) {
        if (compound.method_10545("Health")) {
            this.health = compound.method_10550("Health");
        }
        if (compound.method_10545("Age")) {
            this.age = compound.method_10550("Age");
        }
        this.recentlyHit = compound.method_10550("RecentlyHit");
        this.setCharged(compound.method_10577("Charged"));
        if (compound.method_25928("OwnerUUID")) {
            this.ownerUUID = compound.method_25926("OwnerUUID");
        } else if (compound.method_25928("Owner")) {
            this.ownerUUID = compound.method_25926("Owner");
        }
        this.dismountTicks = compound.method_10571("DismountTicks");
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }
}

