/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.animation.AnimatedEntity;
import fuzs.mutantmonsters.animation.Animation;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import fuzs.puzzleslib.api.entity.v1.AdditionalAddEntityData;
import fuzs.puzzleslib.network.Message;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1510;
import net.minecraft.class_1542;
import net.minecraft.class_1559;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4135;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6862;

public class MutantEnderman
extends class_1588
implements class_5354,
AnimatedEntity {
    private static final class_2940<Optional<class_2338>> TELEPORT_POSITION = class_2945.method_12791(MutantEnderman.class, (class_2941)class_2943.field_13315);
    private static final class_2940<Byte> ACTIVE_ARM = class_2945.method_12791(MutantEnderman.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> CLONE = class_2945.method_12791(MutantEnderman.class, (class_2941)class_2943.field_13323);
    public static final Animation MELEE_ANIMATION = new Animation(10);
    public static final Animation THROW_ANIMATION = new Animation(14);
    public static final Animation STARE_ANIMATION = new Animation(100);
    public static final Animation TELEPORT_ANIMATION = new Animation(10);
    public static final Animation SCREAM_ANIMATION = new Animation(165);
    public static final Animation CLONE_ANIMATION = new Animation(600);
    public static final Animation TELESMASH_ANIMATION = new Animation(30);
    public static final Animation DEATH_ANIMATION = new Animation(280);
    private static final Animation[] ANIMATIONS = new Animation[]{MELEE_ANIMATION, THROW_ANIMATION, STARE_ANIMATION, TELEPORT_ANIMATION, SCREAM_ANIMATION, CLONE_ANIMATION, TELESMASH_ANIMATION, DEATH_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private int screamDelayTick;
    private int[] heldBlock = new int[4];
    private int[] heldBlockTick = new int[4];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    @Nullable
    private List<class_1297> capturedEntities;
    private class_1282 deathCause;
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public MutantEnderman(class_1299<? extends MutantEnderman> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6194 = 40;
        this.field_6013 = 1.4f;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new MeleeGoal(this));
        this.field_6201.method_6277(1, (class_1352)new ThrowBlockGoal(this));
        this.field_6201.method_6277(1, (class_1352)new StareGoal(this));
        this.field_6201.method_6277(1, (class_1352)new TeleportGoal(this));
        this.field_6201.method_6277(1, (class_1352)new ScreamGoal(this));
        this.field_6201.method_6277(1, (class_1352)new CloneGoal(this));
        this.field_6201.method_6277(1, (class_1352)new TeleSmashGoal(this));
        this.field_6201.method_6277(2, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.2).setMaxAttackTick(15));
        this.field_6201.method_6277(3, (class_1352)new AvoidDamageGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new FindTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1559.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_5398((class_1308)this, false));
    }

    public static class_5132.class_5133 registerAttributes() {
        return MutantEnderman.method_26918().method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23717, 96.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TELEPORT_POSITION, Optional.empty());
        this.field_6011.method_12784(ACTIVE_ARM, (Object)0);
        this.field_6011.method_12784(CLONE, (Object)false);
    }

    public Optional<class_2338> getTeleportPosition() {
        return (Optional)this.field_6011.method_12789(TELEPORT_POSITION);
    }

    private void setTeleportPosition(@Nullable class_2338 pos) {
        this.field_6011.method_12778(TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public int getHeldBlock(int index) {
        return this.heldBlock[index];
    }

    public void setHeldBlock(int index, int blockId, int tick) {
        this.heldBlock[index] = blockId;
        this.heldBlockTick[index] = tick;
        if (!this.field_6002.field_9236) {
            MutantMonsters.NETWORK.sendToAllTracking((Message)new S2CMutantEndermanHeldBlockMessage(this, blockId, index), (class_1297)this);
        }
    }

    public int getHeldBlockTick(int arm) {
        return this.heldBlockTick[arm];
    }

    public int getActiveArm() {
        return ((Byte)this.field_6011.method_12789(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.field_6011.method_12778(ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Boolean)this.field_6011.method_12789(CLONE);
    }

    private void setClone(boolean isClone) {
        this.field_6011.method_12778(CLONE, (Object)isClone);
        this.method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_MORPH_SOUND_EVENT.get(), 2.0f, this.method_6017());
        this.field_6002.method_8421((class_1297)this, (byte)0);
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return this.isClone() ? 2.55f : 3.9f;
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return this.isClone() ? ((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get()).method_18386() : super.method_18377(poseIn);
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new MutantGroundPathNavigation((class_1308)this, worldIn);
    }

    protected float method_6031(float renderYawOffset, float distance) {
        return this.field_6213 > 0 ? distance : super.method_6031(renderYawOffset, distance);
    }

    public int method_5945() {
        return 1;
    }

    public int method_5850() {
        return this.isClone() ? 3 : super.method_5850();
    }

    public boolean method_5863() {
        return super.method_5863() && this.animation != TELEPORT_ANIMATION;
    }

    protected void method_16827() {
    }

    public boolean method_29503() {
        return this.field_6012 % 100 == 0 && !this.isClone();
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (CLONE.equals(key)) {
            this.method_18382();
        }
        if (TELEPORT_POSITION.equals(key) && this.getTeleportPosition().isPresent() && this.field_6002.field_9236) {
            this.animation = TELEPORT_ANIMATION;
            this.animationTick = 0;
            this.spawnTeleportParticles();
        }
    }

    public void method_5980(@Nullable class_1309 entitylivingbaseIn) {
        super.method_5980(entitylivingbaseIn);
        this.method_19540(entitylivingbaseIn != null);
    }

    public float getArmScale(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        this.prevArmScale = this.armScale;
        if (this.method_6510()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.field_6002.field_9236) {
            boolean mobGriefing = CommonAbstractions.INSTANCE.getMobGriefingEvent(this.field_6002, (class_1297)this);
            for (int i = 0; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0 || this.heldBlockTick[i] != 0) continue;
                class_2338 startPos = new class_2338(this.method_23317() - 1.5 + this.field_5974.method_43058() * 4.0, this.method_23318() - 0.5 + this.field_5974.method_43058() * 2.5, this.method_23321() - 1.5 + this.field_5974.method_43058() * 4.0);
                class_2680 heldState = class_2248.method_9510((class_2680)class_2248.method_9531((int)this.heldBlock[i]), (class_1936)this.field_6002, (class_2338)startPos);
                if (mobGriefing && this.canPlaceBlock(this.field_6002, startPos, heldState, startPos.method_10074())) {
                    this.field_6002.method_8501(startPos, heldState);
                    class_2498 soundType = heldState.method_26231();
                    this.field_6002.method_8396(null, startPos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
                    this.setHeldBlock(i, 0, 0);
                    continue;
                }
                if (mobGriefing && this.field_5974.method_43048(50) != 0) continue;
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private boolean canPlaceBlock(class_1937 world, class_2338 startPos, class_2680 heldState, class_2338 belowPos) {
        return world.method_22347(startPos) && !world.method_22347(belowPos) && world.method_8320(belowPos).method_26234((class_1922)world, belowPos) && heldState.method_26184((class_4538)world, startPos) && world.method_8335((class_1297)this, new class_238(startPos)).isEmpty();
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.animation == SCREAM_ANIMATION && this.animationTick >= 40 && this.animationTick <= 160) {
            if (this.animationTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1009(20.0, 12.0, 20.0), EndersoulFragment.IS_VALID_TARGET);
            } else {
                Iterator<class_1297> iterator = this.capturedEntities.iterator();
                while (iterator.hasNext()) {
                    class_1297 entity = iterator.next();
                    if (!(this.method_5858(entity) > 400.0) && !entity.method_7325()) {
                        entity.method_36457(entity.method_36455() + (this.field_5974.method_43057() - 0.3f) * 6.0f);
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 0) {
            this.spawnTeleportParticles();
        } else {
            super.method_5711(id);
        }
    }

    public void method_6007() {
        this.field_6282 = false;
        super.method_6007();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == DEATH_ANIMATION) {
            this.field_6213 = this.animationTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        if (this.field_6002.field_9236 && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11214, this.method_23322(0.5), this.method_23319() + (double)(this.field_6213 > 0 ? 1.0f : 0.0f) - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.method_5968() != null && !this.isAnimationPlaying()) {
            if (this.blockFrenzy == 0 && (this.method_6081() instanceof class_1284 || this.field_5974.method_43048(!this.method_6150() ? 300 : 600) == 0)) {
                this.blockFrenzy = 200 + this.field_5974.method_43048(80);
            }
            if (this.blockFrenzy > 0 && this.field_5974.method_43048(8) == 0) {
                int index = this.getFavorableHand();
                class_2338 pos = new class_2338(this.method_23317() - 2.5 + this.field_5974.method_43058() * 5.0, this.method_23318() - 0.5 + this.field_5974.method_43058() * 3.0, this.method_23321() - 2.5 + this.field_5974.method_43058() * 5.0);
                class_2680 blockState = this.field_6002.method_8320(pos);
                if (index != -1 && MutantEnderman.canBlockBeHeld(this.field_6002, pos, blockState, ModRegistry.MUTANT_ENDERMAN_HOLDABLE_IMMUNE_BLOCK_TAG)) {
                    this.setHeldBlock(index, class_2248.method_9507((class_2680)blockState), 0);
                    if (CommonAbstractions.INSTANCE.getMobGriefingEvent(this.field_6002, (class_1297)this)) {
                        this.field_6002.method_8650(pos, false);
                    }
                }
            }
        }
    }

    public static boolean canBlockBeHeld(class_1937 level, class_2338 pos, class_2680 state, class_6862<class_2248> tag) {
        return state.method_26234((class_1922)level, pos) && !state.method_31709() && (state.method_27852(class_2246.field_10471) || !state.method_26164(tag));
    }

    private void updateTeleport() {
        class_1309 entity = this.method_5968();
        this.teleportByChance(entity == null ? 1600 : 800, (class_1297)entity);
        if (this.method_5799() || this.field_6017 > 3.0f || entity != null && (this.method_5794((class_1297)entity) || this.method_5858((class_1297)entity) > 1024.0 || !this.method_6150())) {
            this.teleportByChance(10, (class_1297)entity);
        }
    }

    protected void method_5958() {
        this.method_29510((class_3218)this.field_6002, true);
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.field_5974.method_43048(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.field_5974.method_43048(outer.size()));
        }
        return (Integer)inner.get(this.field_5974.method_43048(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.field_5974.method_43048(inner.size()));
        }
        return (Integer)outer.get(this.field_5974.method_43048(outer.size()));
    }

    public boolean method_6121(class_1297 entityIn) {
        if (!this.field_6002.field_9236 && !this.isAnimationPlaying()) {
            int arm = this.getAvailableHand();
            if (!this.teleportByChance(6, entityIn)) {
                if (arm != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[0] == 0 && this.heldBlock[1] == 0;
                    if (allHandsFree && entityIn.method_5864() != class_1299.field_6119 && this.field_5974.method_43048(10) == 0) {
                        this.animation = CLONE_ANIMATION;
                    } else if (allHandsFree && this.field_5974.method_43048(7) == 0) {
                        this.animation = TELESMASH_ANIMATION;
                    } else {
                        this.setActiveArm(arm);
                        this.animation = MELEE_ANIMATION;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            boolean flag = entityIn.method_5643(class_1282.method_5511((class_1309)this), (float)this.method_26825(class_5134.field_23721));
            if (!this.field_6002.field_9236 && this.field_5974.method_43048(2) == 0) {
                double x = entityIn.method_23317() + (this.field_5974.method_43058() - 0.5) * 24.0;
                double y = entityIn.method_23318() + (double)this.field_5974.method_43048(5) + 4.0;
                double z = entityIn.method_23321() + (this.field_5974.method_43058() - 0.5) * 24.0;
                this.teleportToPosition(x, y, z);
            }
            if (flag) {
                this.method_6025(2.0f);
                this.method_5723((class_1309)this, entityIn);
            }
            this.method_6104(class_1268.field_5808);
            return flag;
        }
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!(source.method_5529() instanceof class_1510) && !(source.method_5529() instanceof MutantEnderman)) {
            if ((this.animation == TELEPORT_ANIMATION || this.animation == SCREAM_ANIMATION) && source != class_1282.field_5849) {
                return false;
            }
            boolean damaged = super.method_5643(source, amount);
            if (damaged && this.animation == STARE_ANIMATION) {
                this.animation = Animation.NONE;
                return damaged;
            }
            if (!this.field_6002.field_9236 && !this.isAnimationPlaying() && this.method_5805()) {
                boolean betterDodge;
                class_1297 entity = source.method_5529();
                boolean bl = betterDodge = entity == null;
                if (source.method_5533() || source.method_5535() || source == class_1282.field_5868) {
                    betterDodge = true;
                }
                if (this.teleportByChance(betterDodge ? 3 : 6, entity) && source != class_1282.field_5849) {
                    if (entity instanceof class_1309) {
                        this.method_6015((class_1309)entity);
                    }
                    return false;
                }
                boolean betterTeleport = source == class_1282.field_5859 || source == class_1282.field_5855;
                this.teleportByChance(betterTeleport ? 3 : 5, entity);
            }
            return damaged;
        }
        return false;
    }

    public boolean method_37222(class_1293 effectInstanceIn, @Nullable class_1297 entity) {
        return !this.isClone() && super.method_37222(effectInstanceIn, entity);
    }

    private boolean teleportByChance(int chance, @Nullable class_1297 entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        if (this.field_5974.method_43048(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0 * radius;
        double y = this.method_23318() + (double)this.field_5974.method_43048((int)radius * 2) - radius;
        double z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0 * radius;
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToEntity(class_1297 entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (this.method_5858(entity) < 100.0) {
            x = entity.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0 * radius;
            y = entity.method_23318() + this.field_5974.method_43058() * radius;
            z = entity.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0 * radius;
        } else {
            class_243 vec = new class_243(this.method_23317() - entity.method_23317(), this.method_23323(0.5) - entity.method_23320(), this.method_23321() - entity.method_23321());
            vec = vec.method_1029();
            x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec.field_1352 * radius;
            y = this.method_23318() + (double)this.field_5974.method_43048(8) - vec.field_1351 * radius;
            z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec.field_1350 * radius;
        }
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToPosition(double x, double y, double z) {
        if (!this.method_6034()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((class_1308)this, x, y, z);
            if (flag) {
                this.method_5848();
                if (!this.method_5701()) {
                    this.field_6002.method_8486(this.field_6014, this.field_6036, this.field_5969, (class_3414)ModRegistry.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.get(), this.method_5634(), 1.0f, 1.0f, false);
                    this.method_5783((class_3414)ModRegistry.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.get(), 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (this.isAnimationPlaying()) {
            return false;
        }
        this.animation = TELEPORT_ANIMATION;
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        boolean success = false;
        if (this.field_6002.method_8477((class_2338)pos)) {
            do {
                pos.method_10098(class_2350.field_11033);
            } while (pos.method_10264() > this.field_6002.method_31607() && !this.field_6002.method_8320((class_2338)pos).method_26207().method_15801());
            pos.method_10098(class_2350.field_11036);
            class_238 bb = this.method_5864().method_17683((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            if (this.field_6002.method_8587((class_1297)this, bb) && !this.field_6002.method_22345(bb)) {
                success = true;
            }
        }
        if (!success) {
            this.animation = Animation.NONE;
            return false;
        }
        this.setTeleportPosition((class_2338)pos);
        return true;
    }

    public static void teleportAttack(class_1309 attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.method_6051().method_43048(60);
        class_1282 damageSource = class_1282.method_5511((class_1309)attacker);
        if (attacker instanceof class_1657) {
            radius = 2.0;
            duration = 100;
            damageSource = class_1282.method_5532((class_1657)((class_1657)attacker));
        }
        for (class_1297 entity : attacker.field_6002.method_8333((class_1297)attacker, attacker.method_5829().method_1014(radius), EndersoulFragment.IS_VALID_TARGET)) {
            if (entity instanceof class_1309 && entity.method_5643(damageSource, 4.0f) && attacker.method_6051().method_43048(3) == 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5919, duration));
            }
            double x = entity.method_23317() - attacker.method_23317();
            double z = entity.method_23321() - attacker.method_23321();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            entity.method_18800((radius * signX * 2.0 - x) * (double)0.2f, (double)0.2f, (radius * signZ * 2.0 - z) * (double)0.2f);
            EntityUtil.sendPlayerVelocityPacket(entity);
        }
    }

    private void spawnTeleportParticles() {
        class_2338 teleportPos = this.getTeleportPosition().orElse(null);
        int amount = teleportPos != null ? 512 : 256;
        for (int i = 0; i < amount; ++i) {
            boolean useCurrentPos = teleportPos == null || i < amount / 2;
            double tempX = (useCurrentPos ? this.method_23317() : (double)teleportPos.method_10263()) + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
            double tempY = (useCurrentPos ? this.method_23318() : (double)teleportPos.method_10264()) + (this.field_5974.method_43058() - 0.5) * (double)this.method_17682() + 1.5;
            double tempZ = (useCurrentPos ? this.method_23321() : (double)teleportPos.method_10260()) + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
            this.field_6002.method_8406((class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), tempX, tempY, tempZ, (this.field_5974.method_43058() - 0.5) * 1.8, (this.field_5974.method_43058() - 0.5) * 1.8, (this.field_5974.method_43058() - 0.5) * 1.8);
        }
    }

    public class_238 method_5830() {
        return this.method_5829().method_1014(3.0);
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected void method_6060(class_1309 livingEntity) {
        if (this.isClone()) {
            super.method_6060(livingEntity);
        } else {
            livingEntity.field_6037 = true;
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        this.capturedEntities = null;
        if (!this.field_6002.field_9236) {
            this.deathCause = cause;
            this.field_6201.method_19048().forEach(class_4135::method_6270);
            AnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION);
            if (this.field_6238 > 0) {
                this.field_6238 += DEATH_ANIMATION.duration();
            }
        }
    }

    protected void method_6108() {
        this.method_18800(0.0, Math.min(this.method_18798().field_1351, 0.0), 0.0);
        if (this.field_6213 == 80) {
            this.method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_DEATH_SOUND_EVENT.get(), 5.0f, this.method_6017());
        }
        if (this.field_6213 >= 60) {
            if (this.field_6213 < 80 && this.capturedEntities == null) {
                this.capturedEntities = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1009(10.0, 8.0, 10.0), EndersoulFragment.IS_VALID_TARGET);
            }
            if (!this.field_6002.field_9236 && this.field_5974.method_43048(3) != 0) {
                EndersoulFragment orb = new EndersoulFragment(this.field_6002, this);
                orb.method_5814(this.method_23317(), this.method_23318() + 3.8, this.method_23321());
                orb.method_18800((this.field_5974.method_43058() - 0.5) * 1.5, (this.field_5974.method_43058() - 0.5) * 1.5, (this.field_5974.method_43058() - 0.5) * 1.5);
                this.field_6002.method_8649((class_1297)orb);
            }
        }
        if (this.field_6213 >= 80 && this.field_6213 < DEATH_ANIMATION.duration() - 20 && this.capturedEntities != null) {
            Iterator<class_1297> iterator = this.capturedEntities.iterator();
            while (iterator.hasNext()) {
                class_1297 entity = iterator.next();
                if (entity.field_6017 > 4.5f) {
                    entity.field_6017 = 4.5f;
                }
                if (!(this.method_5858(entity) > 64.0)) continue;
                if (!EndersoulFragment.isProtected(entity) && !entity.method_7325()) {
                    double x = this.method_23317() - entity.method_23317();
                    double y = entity.method_18798().field_1351;
                    double z = this.method_23321() - entity.method_23321();
                    double d = Math.sqrt(x * x + z * z);
                    if (this.method_23318() + 4.0 > entity.method_23318()) {
                        y = Math.max(entity.method_18798().field_1351, (double)0.4f);
                    }
                    entity.method_18800((double)0.8f * x / d, y, (double)0.8f * z / d);
                    continue;
                }
                iterator.remove();
            }
        }
        if (!this.field_6002.field_9236 && this.field_6213 >= 100 && this.field_6213 < 150 && this.field_6213 % 6 == 0 && this.field_6002.method_8450().method_8355(class_1928.field_19391)) {
            super.method_16077(this.deathCause != null ? this.deathCause : class_1282.field_5869, this.field_6238 > 0);
        }
        if (this.field_6213 >= DEATH_ANIMATION.duration()) {
            this.method_23883();
            this.method_31472();
        }
    }

    protected void method_16077(class_1282 damageSourceIn, boolean attackedRecently) {
    }

    public boolean method_6054() {
        return this.field_6213 > 0;
    }

    public class_1542 method_5775(class_1799 stack) {
        return this.field_6213 > 0 ? this.method_5699(stack, 3.84f) : super.method_5775(stack);
    }

    public static boolean canSpawn(class_1299<MutantEnderman> type, class_5425 worldIn, class_3730 reason, class_2338 pos, class_5819 randomIn) {
        return randomIn.method_43048(3) == 0 && MutantEnderman.method_20680(type, (class_5425)worldIn, (class_3730)reason, (class_2338)pos, (class_5819)randomIn);
    }

    protected class_2561 method_23315() {
        return this.isClone() ? ((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get()).method_5897() : super.method_23315();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.method_29517(compound);
        compound.method_10569("BlockFrenzy", this.blockFrenzy);
        compound.method_10569("ScreamDelay", this.screamDelayTick);
        class_2499 listNBT = new class_2499();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            class_2487 compoundNBT = class_2512.method_10686((class_2680)class_2248.method_9531((int)this.heldBlock[i]));
            compound.method_10567("Index", (byte)i);
            compoundNBT.method_10569("Tick", this.heldBlockTick[i]);
            listNBT.add((Object)compoundNBT);
        }
        if (!listNBT.isEmpty()) {
            compound.method_10566("HeldBlocks", (class_2520)listNBT);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (this.field_6002 instanceof class_3218) {
            this.method_29512(this.field_6002, compound);
        }
        this.blockFrenzy = compound.method_10550("BlockFrenzy");
        this.screamDelayTick = compound.method_10550("ScreamDelay");
        if (compound.method_10573("HeldBlocks", 9)) {
            class_2499 listNBT = compound.method_10554("HeldBlocks", 9);
            for (int i = 0; i < listNBT.size(); ++i) {
                class_2487 compoundNBT = listNBT.method_10602(i);
                class_2680 blockState = class_2512.method_10681((class_2487)compoundNBT);
                this.setHeldBlock(compoundNBT.method_10571("Index"), class_2248.method_9507((class_2680)blockState), compound.method_10550("Tick"));
            }
        }
        if (this.field_6213 > 0) {
            this.animation = DEATH_ANIMATION;
            this.animationTick = this.field_6213;
        }
    }

    public int method_5970() {
        return 200;
    }

    public void method_5966() {
        if (!this.isClone()) {
            super.method_5966();
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_AMBIENT_SOUND_EVENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.get();
    }

    private boolean isBeingLookedAtBy(class_1309 target) {
        if (!(target instanceof class_1308)) {
            class_243 lookVec = target.method_5828(1.0f).method_1029();
            class_243 targetVec = new class_243(this.method_23317() - target.method_23317(), this.method_23320() - target.method_23320(), this.method_23321() - target.method_23321());
            double length = targetVec.method_1033();
            double d = lookVec.method_1026(targetVec = targetVec.method_1029());
            return d > 1.0 - 0.08 / length && target.method_6057((class_1297)this);
        }
        return ((class_1308)target).method_5968() == this && target.method_6057((class_1297)this);
    }

    @Override
    public void writeAdditionalAddEntityData(class_2540 buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.method_10804(this.hasTarget);
        buffer.method_10804(this.armScale);
        buffer.method_10806(this.heldBlock);
        buffer.method_10806(this.heldBlockTick);
    }

    @Override
    public void readAdditionalAddEntityData(class_2540 additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.hasTarget = additionalData.method_10816();
        this.armScale = additionalData.method_10816();
        this.heldBlock = additionalData.method_10787();
        this.heldBlockTick = additionalData.method_10787();
    }

    public class_2596<?> method_18002() {
        return AdditionalAddEntityData.getPacket((class_1297)this);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantEnderman> {
        public MeleeGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void method_6268() {
            if (((MutantEnderman)this.mob).animationTick == 3) {
                ((MutantEnderman)this.mob).method_5783(class_3417.field_14840, 1.0f, ((MutantEnderman)this.mob).method_6017());
                boolean lower = ((MutantEnderman)this.mob).getActiveArm() >= 2;
                float attackDamage = (float)((MutantEnderman)this.mob).method_26825(class_5134.field_23721);
                for (class_1309 livingEntity : ((MutantEnderman)this.mob).field_6002.method_18467(class_1309.class, ((MutantEnderman)this.mob).method_5829().method_1014(4.0))) {
                    if (livingEntity instanceof MutantEnderman || livingEntity instanceof EndersoulClone) continue;
                    double dist = ((MutantEnderman)this.mob).method_5739((class_1297)livingEntity);
                    double x = ((MutantEnderman)this.mob).method_23317() - livingEntity.method_23317();
                    double z = ((MutantEnderman)this.mob).method_23321() - livingEntity.method_23321();
                    if (!(((MutantEnderman)this.mob).method_5829().field_1322 <= livingEntity.method_5829().field_1325) || !(dist <= 4.0) || !(EntityUtil.getHeadAngle((class_1309)this.mob, x, z) < 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    livingEntity.method_5643(class_1282.method_5511((class_1309)this.mob), attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f);
                    float power = 0.4f + ((MutantEnderman)this.mob).field_5974.method_43057() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    livingEntity.method_18800(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((class_1297)livingEntity);
                }
            }
        }
    }

    static class ThrowBlockGoal
    extends AnimationGoal<MutantEnderman> {
        public ThrowBlockGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            if (((MutantEnderman)this.mob).isAnimationPlaying()) {
                return false;
            }
            if (!((MutantEnderman)this.mob).triggerThrowBlock && ((MutantEnderman)this.mob).method_6051().method_43048(28) != 0) {
                return false;
            }
            if (((MutantEnderman)this.mob).method_5968() != null && !((MutantEnderman)this.mob).method_6057((class_1297)((MutantEnderman)this.mob).method_5968())) {
                return false;
            }
            int id = ((MutantEnderman)this.mob).getThrowingHand();
            if (id == -1) {
                return false;
            }
            ((MutantEnderman)this.mob).setActiveArm(id);
            return true;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            int id = ((MutantEnderman)this.mob).getActiveArm();
            ((MutantEnderman)this.mob).field_6002.method_8649((class_1297)new ThrowableBlock((MutantEnderman)this.mob, id));
            ((MutantEnderman)this.mob).setHeldBlock(id, 0, 0);
        }

        @Override
        public void method_6270() {
            super.method_6270();
            ((MutantEnderman)this.mob).triggerThrowBlock = false;
        }
    }

    static class StareGoal
    extends AnimationGoal<MutantEnderman> {
        private class_1309 attackTarget;

        public StareGoal(MutantEnderman mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected Animation getAnimation() {
            return STARE_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            this.attackTarget = ((MutantEnderman)this.mob).method_5968();
            return this.attackTarget != null && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            ((MutantEnderman)this.mob).field_6191 = -((MutantEnderman)this.mob).method_5970();
            ((MutantEnderman)this.mob).field_6002.method_43129(null, (class_1297)this.mob, (class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_STARE_SOUND_EVENT.get(), ((MutantEnderman)this.mob).method_5634(), 2.5f, 0.7f + ((MutantEnderman)this.mob).field_5974.method_43057() * 0.2f);
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && this.attackTarget.method_5805() && ((MutantEnderman)this.mob).isBeingLookedAtBy(this.attackTarget);
        }

        public void method_6268() {
            ((MutantEnderman)this.mob).method_5942().method_6340();
            ((MutantEnderman)this.mob).field_6206.method_6226((class_1297)this.attackTarget, 45.0f, 45.0f);
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.attackTarget.method_5848();
            this.attackTarget.method_5643(class_1282.method_5511((class_1309)this.mob).method_5508().method_5509(), 2.0f);
            this.attackTarget.method_6092(new class_1293(class_1294.field_5919, 160 + ((MutantEnderman)this.mob).field_5974.method_43048(140)));
            double x = ((MutantEnderman)this.mob).method_23317() - this.attackTarget.method_23317();
            double z = ((MutantEnderman)this.mob).method_23321() - this.attackTarget.method_23321();
            this.attackTarget.method_18800(x * (double)0.1f, (double)0.3f, z * (double)0.1f);
            EntityUtil.sendPlayerVelocityPacket((class_1297)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class TeleportGoal
    extends AnimationGoal<MutantEnderman> {
        public TeleportGoal(MutantEnderman mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected Animation getAnimation() {
            return TELEPORT_ANIMATION;
        }

        @Override
        public void method_6269() {
            ((MutantEnderman)this.mob).animation = TELEPORT_ANIMATION;
            ((MutantEnderman)this.mob).animationTick = 0;
            MutantEnderman.teleportAttack((class_1309)this.mob);
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5));
            if (!((MutantEnderman)this.mob).method_5701()) {
                ((MutantEnderman)this.mob).field_6002.method_43128(null, ((MutantEnderman)this.mob).field_6014, ((MutantEnderman)this.mob).field_6036, ((MutantEnderman)this.mob).field_5969, (class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.get(), ((MutantEnderman)this.mob).method_5634(), 1.0f, 1.0f);
                ((MutantEnderman)this.mob).method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.get(), 1.0f, 1.0f);
            }
            MutantEnderman.teleportAttack((class_1309)this.mob);
            ((MutantEnderman)this.mob).method_5814(((MutantEnderman)this.mob).field_6014, ((MutantEnderman)this.mob).field_6036, ((MutantEnderman)this.mob).field_5969);
        }

        public void method_6268() {
            ((MutantEnderman)this.mob).method_5942().method_6340();
        }

        @Override
        public void method_6270() {
            ((MutantEnderman)this.mob).method_5848();
            ((MutantEnderman)this.mob).field_6017 = 0.0f;
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).method_5859((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5));
            super.method_6270();
            ((MutantEnderman)this.mob).setTeleportPosition(null);
        }
    }

    static class ScreamGoal
    extends AnimationGoal<MutantEnderman> {
        public ScreamGoal(MutantEnderman mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected Animation getAnimation() {
            return SCREAM_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            if (((MutantEnderman)this.mob).method_5968() != null && !((MutantEnderman)this.mob).isAnimationPlaying()) {
                return ((MutantEnderman)this.mob).screamDelayTick <= 0 && ((MutantEnderman)this.mob).method_5858((class_1297)((MutantEnderman)this.mob).method_5968()) < 400.0 && ((MutantEnderman)this.mob).field_5974.method_43048(((MutantEnderman)this.mob).method_5721() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void method_6268() {
            ((MutantEnderman)this.mob).method_5942().method_6340();
            if (((MutantEnderman)this.mob).animationTick == 40) {
                ((MutantEnderman)this.mob).field_6191 = -((MutantEnderman)this.mob).method_5970();
                ((MutantEnderman)this.mob).field_6002.method_8401().method_157(false);
                ((MutantEnderman)this.mob).field_6002.method_8421((class_1297)this.mob, (byte)0);
                ((MutantEnderman)this.mob).method_5783((class_3414)ModRegistry.ENTITY_MUTANT_ENDERMAN_SCREAM_SOUND_EVENT.get(), 5.0f, 0.7f + ((MutantEnderman)this.mob).field_5974.method_43057() * 0.2f);
                for (class_1297 entity : ((MutantEnderman)this.mob).field_6002.method_8333((class_1297)this.mob, ((MutantEnderman)this.mob).method_5829().method_1009(20.0, 12.0, 20.0), EndersoulFragment.IS_VALID_TARGET)) {
                    if (!(((MutantEnderman)this.mob).method_5858(entity) < 400.0)) continue;
                    entity.method_5643(class_1282.method_5511((class_1309)this.mob).method_5508().method_5509(), 4.0f);
                    if (!(entity instanceof class_1308)) continue;
                    class_1308 mobEntity = (class_1308)entity;
                    mobEntity.method_6092(new class_1293(class_1294.field_5909, 120, 3));
                    if (((MutantEnderman)this.mob).field_5974.method_43048(2) != 0) {
                        mobEntity.method_6092(new class_1293(class_1294.field_5899, 120 + ((MutantEnderman)this.mob).field_5974.method_43048(180), ((MutantEnderman)this.mob).field_5974.method_43048(2)));
                    }
                    if (((MutantEnderman)this.mob).field_5974.method_43048(4) != 0) {
                        mobEntity.method_6092(new class_1293(class_1294.field_5911, 300 + ((MutantEnderman)this.mob).field_5974.method_43048(300), ((MutantEnderman)this.mob).field_5974.method_43048(2)));
                    }
                    if (((MutantEnderman)this.mob).field_5974.method_43048(3) != 0) {
                        mobEntity.method_6092(new class_1293(class_1294.field_5903, 120 + ((MutantEnderman)this.mob).field_5974.method_43048(60), 10 + ((MutantEnderman)this.mob).field_5974.method_43048(2)));
                    }
                    if (((MutantEnderman)this.mob).field_5974.method_43048(4) == 0) continue;
                    mobEntity.method_6092(new class_1293(class_1294.field_5916, 120 + ((MutantEnderman)this.mob).field_5974.method_43048(400)));
                }
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            ((MutantEnderman)this.mob).screamDelayTick = 600;
        }
    }

    static class CloneGoal
    extends AnimationGoal<MutantEnderman> {
        private final List<EndersoulClone> cloneList = new ArrayList<EndersoulClone>();
        private class_1309 attackTarget;

        public CloneGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return CLONE_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            this.attackTarget = ((MutantEnderman)this.mob).method_5968();
            if (this.attackTarget == null) {
                return false;
            }
            if (this.attackTarget.method_5864() != class_1299.field_6119 && ((MutantEnderman)this.mob).heldBlock[0] == 0 && ((MutantEnderman)this.mob).heldBlock[1] == 0) {
                return ((MutantEnderman)this.mob).field_6235 == 0 && (super.method_6264() || !((MutantEnderman)this.mob).isAnimationPlaying() && ((MutantEnderman)this.mob).field_6012 % 3 == 0 && ((MutantEnderman)this.mob).field_5974.method_43048(300) == 0);
            }
            return false;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            ((MutantEnderman)this.mob).field_6008 = 20;
            ((MutantEnderman)this.mob).field_6013 = 1.0f;
            ((MutantEnderman)this.mob).setClone(true);
            ((MutantEnderman)this.mob).method_5646();
            ((MutantEnderman)this.mob).method_6012();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.method_23317() + (((MutantEnderman)this.mob).field_5974.method_43058() - 0.5) * 24.0;
                double y = this.attackTarget.method_23318() + 8.0;
                double z = this.attackTarget.method_23321() + (((MutantEnderman)this.mob).field_5974.method_43058() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            this.createClone(((MutantEnderman)this.mob).field_6014, ((MutantEnderman)this.mob).field_6036, ((MutantEnderman)this.mob).field_5969);
            double x = this.attackTarget.method_23317() + (((MutantEnderman)this.mob).field_5974.method_43058() - 0.5) * 24.0;
            double y = this.attackTarget.method_23318() + 8.0;
            double z = this.attackTarget.method_23321() + (((MutantEnderman)this.mob).field_5974.method_43058() - 0.5) * 24.0;
            ((MutantEnderman)this.mob).teleportToPosition(x, y, z);
            EntityUtil.divertAttackers(this.mob, (class_1309)this.getRandomClone());
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && ((MutantEnderman)this.mob).method_5968() != null && !this.cloneList.isEmpty() && ((MutantEnderman)this.mob).field_6235 == 0;
        }

        public void method_6268() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                EndersoulClone clone = this.cloneList.get(i);
                if (clone.method_5805() && clone.field_6002 == ((MutantEnderman)this.mob).field_6002) continue;
                this.cloneList.remove(i);
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            ((MutantEnderman)this.mob).setClone(false);
            ((MutantEnderman)this.mob).field_6013 = 1.4f;
            for (EndersoulClone clone : this.cloneList) {
                if (!clone.method_5805()) continue;
                clone.method_31472();
                EntityUtil.divertAttackers((class_1308)clone, (class_1309)this.mob);
            }
            this.cloneList.clear();
            ((MutantEnderman)this.mob).method_5942().method_6340();
            this.attackTarget.method_6015((class_1309)this.mob);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulClone clone = (EndersoulClone)((class_1299)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get()).method_5883(((MutantEnderman)this.mob).field_6002);
            clone.setCloner((MutantEnderman)this.mob);
            this.cloneList.add(clone);
            if (!EntityUtil.teleportTo((class_1308)clone, x, y, z)) {
                clone.method_5719((class_1297)this.mob);
            }
            ((MutantEnderman)this.mob).field_6002.method_8649((class_1297)clone);
        }

        private class_1308 getRandomClone() {
            return this.cloneList.isEmpty() ? this.mob : (class_1308)this.cloneList.get(((MutantEnderman)this.mob).field_5974.method_43048(this.cloneList.size()));
        }
    }

    static class TeleSmashGoal
    extends AnimationGoal<MutantEnderman> {
        private class_1309 attackTarget;

        public TeleSmashGoal(MutantEnderman mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        protected Animation getAnimation() {
            return TELESMASH_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            this.attackTarget = ((MutantEnderman)this.mob).method_5968();
            return this.attackTarget != null && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.attackTarget.method_6092(new class_1293(class_1294.field_5909, 20, 5));
            this.attackTarget.method_6092(new class_1293(class_1294.field_5916, 160 + this.attackTarget.method_6051().method_43048(160)));
        }

        public void method_6268() {
            ((MutantEnderman)this.mob).method_5942().method_6340();
            if (((MutantEnderman)this.mob).animationTick < 20) {
                ((MutantEnderman)this.mob).field_6206.method_6226((class_1297)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantEnderman)this.mob).animationTick == 17) {
                this.attackTarget.method_5848();
            }
            if (((MutantEnderman)this.mob).animationTick == 18) {
                double x = this.attackTarget.method_23317() + (this.attackTarget.method_6051().method_43058() - 0.5) * 14.0;
                double y = this.attackTarget.method_23318() + this.attackTarget.method_6051().method_43058() + (this.attackTarget instanceof class_1657 ? 13.0 : 7.0);
                double z = this.attackTarget.method_23321() + (this.attackTarget.method_6051().method_43058() - 0.5) * 14.0;
                EntityUtil.stunRavager(this.attackTarget);
                EntityUtil.sendParticlePacket((class_1297)this.attackTarget, (class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), 256);
                this.attackTarget.method_5859(x, y, z);
                ((MutantEnderman)this.mob).field_6002.method_43128(null, x, y, z, class_3417.field_15152, this.attackTarget.method_5634(), 1.2f, 0.9f + this.attackTarget.method_6051().method_43057() * 0.2f);
                this.attackTarget.method_5643(class_1282.method_5511((class_1309)this.mob).method_5508().method_5509(), 6.0f);
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.attackTarget = null;
        }
    }

    static class FindTargetGoal
    extends class_1400<class_1309> {
        public FindTargetGoal(MutantEnderman mutantEnderman) {
            super((class_1308)mutantEnderman, class_1309.class, 10, false, false, target -> (mutantEnderman.method_29515((class_1309)target) || mutantEnderman.isBeingLookedAtBy((class_1309)target) || EndersoulFragment.isProtected((class_1297)target)) && target.method_6102());
        }

        public boolean method_6264() {
            boolean flag;
            boolean bl = flag = !((MutantEnderman)this.field_6660).isAnimationPlaying() && super.method_6264();
            if (flag && ((MutantEnderman)this.field_6660).isBeingLookedAtBy(this.field_6644)) {
                ((MutantEnderman)this.field_6660).animation = STARE_ANIMATION;
            }
            return flag;
        }

        protected class_238 method_6321(double targetDistance) {
            return this.field_6660.method_5829().method_1009(targetDistance, targetDistance / 2.0, targetDistance);
        }
    }
}

