/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.FleeRainGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class MutantSnowGolem
extends AbstractGolem
implements RangedAttackMob,
Shearable {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(MutantSnowGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(MutantSnowGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolem(EntityType<? extends MutantSnowGolem> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SwimJumpGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FleeRainGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.1, 30, 12.0f));
        this.f_21345_.m_25352_(3, (Goal)new ThrowIceGoal());
        this.f_21345_.m_25352_(4, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, entity -> entity instanceof Enemy && (!(entity instanceof Creeper) || ((Creeper)entity).m_5448_() == this)));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantSnowGolem.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.26);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(STATUS, (Object)1);
    }

    @Nullable
    public Player getOwner() {
        return this.getOwnerId().map(arg_0 -> ((Level)this.f_19853_).m_46003_(arg_0)).orElse(null);
    }

    public Optional<UUID> getOwnerId() {
        return (Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean hasJackOLantern() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 1) != 0;
    }

    public void setJackOLantern(boolean jackOLantern) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        this.f_19804_.m_135381_(STATUS, (Object)(jackOLantern ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJumping) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        this.f_19804_.m_135381_(STATUS, (Object)(swimJumping ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.0f;
    }

    public boolean m_6779_(LivingEntity target) {
        return target instanceof Enemy && target.m_142066_();
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        if (((Biome)worldIn.m_204166_(pos).m_203334_()).m_198910_(pos)) {
            return -10.0f;
        }
        return worldIn.m_8055_(pos).m_60734_() == Blocks.f_50125_ ? 10.0f : 0.0f;
    }

    public void m_8119_() {
        int x;
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.getSwimJump()) {
            for (x = 0; x < 6; ++x) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50125_.m_49966_()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                d0 = this.f_19796_.m_188583_() * 0.02;
                d1 = this.f_19796_.m_188583_() * 0.02;
                d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
        if (this.isThrowing) {
            ++this.throwingTick;
            if (this.throwingTick >= 20) {
                this.isThrowing = false;
                this.throwingTick = 0;
            }
        }
        if (this.f_19853_.m_6042_().f_63857_() || ((Biome)this.f_19853_.m_204166_(this.m_20183_()).m_203334_()).m_198910_(this.m_20183_())) {
            if (this.f_19796_.m_188501_() > Math.min(80.0f, this.m_21223_()) * 0.01f) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, this.m_20208_(0.6), this.m_20187_() - 0.15, this.m_20262_(0.6), 0.0, 0.0, 0.0);
            }
            if (this.f_19797_ % 60 == 0) {
                this.m_6469_(DamageSource.f_19307_, 1.0f);
            }
        }
        if (this.f_19797_ % 80 == 0 && this.m_6084_() && this.m_21223_() < this.m_21233_() && this.isSnowingAt(this.m_20183_())) {
            this.m_5634_(1.0f);
        }
        if (!this.f_19853_.f_46443_ && this.f_19861_ && !this.f_19853_.m_6042_().f_63857_() && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.f_19853_, (Entity)this)) {
            x = Mth.m_14107_((double)this.m_20185_());
            int y = Mth.m_14107_((double)this.m_20191_().f_82289_);
            int z = Mth.m_14107_((double)this.m_20189_());
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    BlockPos pos = new BlockPos(x + i, y, z + j);
                    BlockPos posDown = pos.m_7495_();
                    BlockPos posAbove = pos.m_7494_();
                    boolean placeSnow = this.f_19853_.m_46859_(pos) && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)this.f_19853_, pos);
                    boolean placeIce = this.f_19853_.m_46801_(posDown);
                    if (this.f_19853_.m_6425_(pos).m_76152_() == Fluids.f_76192_) {
                        this.f_19853_.m_46597_(pos, Blocks.f_50126_.m_49966_());
                    }
                    if (this.f_19853_.m_6425_(posAbove).m_76152_() == Fluids.f_76192_) {
                        this.f_19853_.m_46597_(posAbove, Blocks.f_50126_.m_49966_());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.f_19796_.m_188503_(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.f_19796_.m_188503_(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.f_19796_.m_188503_(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.f_19796_.m_188503_(6) != 0)) continue;
                    if (placeSnow) {
                        this.f_19853_.m_46597_(pos, Blocks.f_50125_.m_49966_());
                    }
                    if (!placeIce) continue;
                    this.f_19853_.m_46597_(posDown, Blocks.f_50126_.m_49966_());
                }
            }
        }
    }

    private boolean isSnowingAt(BlockPos position) {
        if (!this.f_19853_.m_46471_()) {
            return false;
        }
        if (!this.f_19853_.m_45527_(position)) {
            return false;
        }
        if (this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, position).m_123342_() > position.m_123342_()) {
            return false;
        }
        Biome biome = (Biome)this.f_19853_.m_204166_(position).m_203334_();
        return biome.m_47530_() == Biome.Precipitation.SNOW && biome.m_198904_(position);
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_6220_() {
        return this.m_6084_() && this.hasJackOLantern();
    }

    public void m_5851_(SoundSource source) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12480_, source, 1.0f, 1.0f);
        if (!this.f_19853_.m_5776_()) {
            this.setJackOLantern(false);
            this.m_5552_(new ItemStack((ItemLike)Items.f_42055_), 1.7f);
        }
    }

    protected void m_8024_() {
        if (!this.m_21523_()) {
            Player owner = this.getOwner();
            if (owner != null && owner.m_6084_()) {
                this.m_21446_(owner.m_20183_(), this.m_5448_() == null ? 8 : 16);
            } else if (this.m_21536_()) {
                this.m_21446_(BlockPos.f_121853_, -1);
            }
        }
    }

    public boolean isThrowing() {
        return this.isThrowing;
    }

    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
        this.throwingTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(isThrowing ? 1 : 0));
    }

    public void m_7822_(byte id) {
        if (id != 0 && id != 1) {
            super.m_7822_(id);
            if (id == 2 || id == 33 || id == 36 || id == 37 || id == 44) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50125_.m_49966_()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else {
            this.isThrowing = id == 1;
            this.throwingTick = 0;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7640_() instanceof Snowball) {
            if (this.m_6084_() && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(1.0f);
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (!this.isThrowing) {
            this.setThrowing(true);
        }
    }

    public static boolean canHarm(Entity attacker, Entity target) {
        if (!(attacker instanceof MutantSnowGolem)) {
            return true;
        }
        if (target instanceof CreeperMinion) {
            return !((CreeperMinion)target).m_21824_();
        }
        return target instanceof Enemy || target instanceof Mob && ((Mob)target).m_5448_() == attacker || ((MutantSnowGolem)attacker).m_5448_() == target;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        InteractionResult actionresulttype = itemStack.m_41647_(player, (LivingEntity)this, hand);
        if (actionresulttype.m_19077_()) {
            return actionresulttype;
        }
        if (!(this.getOwnerId().isPresent() && player != this.getOwner() || itemStack.m_41720_() == Items.f_42452_)) {
            if (!this.f_19853_.f_46443_) {
                this.setOwnerId(!this.getOwnerId().isPresent() ? player.m_20148_() : null);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.9f * this.m_20192_()), (double)this.m_20205_() * (double)0.2f);
    }

    public void m_6667_(DamageSource cause) {
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(cause);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("JackOLantern", this.hasJackOLantern());
        this.getOwnerId().ifPresent(uuid -> compound.m_128362_("Owner", uuid));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Pumpkin") || compound.m_128441_("JackOLantern")) {
            this.setJackOLantern(compound.m_128471_("Pumpkin") || compound.m_128471_("JackOLantern"));
        }
        if (compound.m_128403_("OwnerUUID")) {
            this.setOwnerId(compound.m_128342_("OwnerUUID"));
        } else if (compound.m_128403_("Owner")) {
            this.setOwnerId(compound.m_128342_("Owner"));
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_SNOW_GOLEM_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_SNOW_GOLEM_DEATH_SOUND_EVENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12483_, 0.15f, 1.0f);
    }

    static class SwimJumpGoal
    extends Goal {
        private final MutantSnowGolem golem;
        private int jumpTick = 20;
        private boolean waterReplaced;
        private BlockPos.MutableBlockPos prevPos;

        public SwimJumpGoal(MutantSnowGolem golem) {
            this.golem = golem;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            golem.f_21344_.m_7008_(true);
        }

        public boolean m_8036_() {
            return this.golem.m_20069_();
        }

        public void m_8056_() {
            this.prevPos = new BlockPos.MutableBlockPos(this.golem.m_20185_(), this.golem.m_20191_().f_82289_ - 1.0, this.golem.m_20189_());
            this.golem.m_20334_((this.golem.f_19796_.m_188501_() - this.golem.f_19796_.m_188501_()) * 0.9f, 1.5, (this.golem.f_19796_.m_188501_() - this.golem.f_19796_.m_188501_()) * 0.9f);
            this.golem.m_6469_(DamageSource.f_19312_, 16.0f);
            this.golem.setSwimJump(true);
        }

        public boolean m_8045_() {
            return this.jumpTick > 0;
        }

        public void m_8037_() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.m_20069_() && this.jumpTick < 17 && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.golem.f_19853_, (Entity)this.golem)) {
                this.prevPos.m_142448_(this.getWaterSurfaceHeight(this.golem.f_19853_, (BlockPos)this.prevPos));
                if ((double)this.prevPos.m_123342_() > this.golem.m_20186_()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos pos;
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2) || !this.golem.f_19853_.m_46859_(pos = this.prevPos.m_7918_(x, y, z)) && !this.golem.f_19853_.m_46801_(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.f_19796_.m_188503_(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.f_19796_.m_188503_(3) == 0)) continue;
                            this.golem.f_19853_.m_46597_(pos, Blocks.f_50126_.m_49966_());
                        }
                    }
                }
                BlockPos topPos = this.prevPos.m_6630_(2);
                if (this.golem.f_19853_.m_46859_(topPos)) {
                    this.golem.f_19853_.m_46597_(topPos, Blocks.f_50126_.m_49966_());
                }
                this.waterReplaced = true;
            }
        }

        public void m_8041_() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.golem.setSwimJump(false);
            this.prevPos = null;
        }

        private int getWaterSurfaceHeight(Level world, BlockPos coord) {
            int y = coord.m_123342_();
            while (world.m_46801_(new BlockPos(coord.m_123341_(), y + 1, coord.m_123343_()))) {
                ++y;
            }
            return y;
        }
    }

    class ThrowIceGoal
    extends Goal {
        private LivingEntity attackTarget;

        ThrowIceGoal() {
        }

        public boolean m_8036_() {
            this.attackTarget = MutantSnowGolem.this.m_5448_();
            return this.attackTarget != null && MutantSnowGolem.this.isThrowing;
        }

        public boolean m_8045_() {
            return MutantSnowGolem.this.isThrowing && MutantSnowGolem.this.throwingTick < 20;
        }

        public void m_8037_() {
            MutantSnowGolem.this.m_21573_().m_26573_();
            MutantSnowGolem.this.f_20883_ = MutantSnowGolem.this.m_146908_();
            if (MutantSnowGolem.this.throwingTick == 7) {
                ThrowableBlock block = new ThrowableBlock(MutantSnowGolem.this);
                double x = this.attackTarget.m_20185_() - block.m_20185_();
                double y = this.attackTarget.m_20186_() - block.m_20186_();
                double z = this.attackTarget.m_20189_() - block.m_20189_();
                double xz = Math.sqrt(x * x + z * z);
                block.m_6686_(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                MutantSnowGolem.this.f_19853_.m_7967_((Entity)block);
            }
        }

        public void m_8041_() {
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

