/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1360;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1404;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1471;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class CreeperMinion
extends class_1471 {
    private static final class_2940<Byte> CREEPER_MINION_FLAGS = class_2945.method_12791(CreeperMinion.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> EXPLODE_STATE = class_2945.method_12791(CreeperMinion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> EXPLOSION_RADIUS = class_2945.method_12791(CreeperMinion.class, (class_2941)class_2943.field_13320);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private final int fuseTime = 26;

    public CreeperMinion(class_1299<? extends CreeperMinion> type, class_1937 worldIn) {
        super(type, worldIn);
        this.setDestroyBlocks(true);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new CreeperMinionSwellGoal());
        this.field_6201.method_6277(3, (class_1352)new AvoidDamageGoal((class_1314)this, 1.2));
        this.field_6201.method_6277(3, (class_1352)new class_1338<class_1429>((class_1314)this, class_1429.class, 6.0f, 1.0, 1.2, EntityUtil::isFeline){

            public boolean method_6264() {
                return !CreeperMinion.this.method_6181() && super.method_6264();
            }
        });
        this.field_6201.method_6277(4, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.2));
        this.field_6201.method_6277(5, (class_1352)new CreeperMinionFollowOwnerGoal());
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1360(this){

            public boolean method_6264() {
                return CreeperMinion.this.method_6181() && CreeperMinion.this.method_6177() instanceof class_1657 && super.method_6264();
            }
        });
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new OwnerTargetGoal((class_1321)this));
        this.field_6185.method_6277(1, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1404((class_1321)this, class_1657.class, true, null));
    }

    public static class_5132.class_5133 registerAttributes() {
        return CreeperMinion.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CREEPER_MINION_FLAGS, (Object)0);
        this.field_6011.method_12784(EXPLODE_STATE, (Object)-1);
        this.field_6011.method_12784(EXPLOSION_RADIUS, (Object)Float.valueOf(2.0f));
    }

    @Nullable
    public class_1309 method_6177() {
        UUID uuid = this.method_6139();
        if (uuid == null) {
            return null;
        }
        class_1657 entity = this.field_6002.method_18470(uuid);
        if (entity == null && this.field_6002 instanceof class_3218) {
            entity = ((class_3218)this.field_6002).method_14190(uuid);
        }
        return entity instanceof class_1309 ? (class_1309)entity : null;
    }

    public int getExplodeState() {
        return (Integer)this.field_6011.method_12789(EXPLODE_STATE);
    }

    public void setExplodeState(int state) {
        this.field_6011.method_12778(EXPLODE_STATE, (Object)state);
    }

    public boolean isCharged() {
        return ((Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS) & 1) != 0;
    }

    public void setCharged(boolean charged) {
        byte b0 = (Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(CREEPER_MINION_FLAGS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasIgnited() {
        return ((Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS) & 4) != 0;
    }

    public void ignite() {
        byte b0 = (Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(CREEPER_MINION_FLAGS, (Object)((byte)(b0 | 4)));
    }

    public boolean canExplodeContinuously() {
        return ((Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS) & 8) != 0;
    }

    public void setCanExplodeContinuously(boolean continuously) {
        byte b0 = (Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(CREEPER_MINION_FLAGS, (Object)(continuously ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    public boolean canDestroyBlocks() {
        return ((Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS) & 0x10) != 0;
    }

    public void setDestroyBlocks(boolean destroy) {
        byte b0 = (Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(CREEPER_MINION_FLAGS, (Object)(destroy ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF)));
    }

    public boolean canRideOnShoulder() {
        return ((Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS) & 0x20) != 0;
    }

    public void setCanRideOnShoulder(boolean canRide) {
        byte b0 = (Byte)this.field_6011.method_12789(CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(CREEPER_MINION_FLAGS, (Object)(canRide ? (byte)(b0 | 0x20) : (byte)(b0 & 0xFFFFFFDF)));
    }

    public float getExplosionRadius() {
        return ((Float)this.field_6011.method_12789(EXPLOSION_RADIUS)).floatValue();
    }

    public void setExplosionRadius(float radius) {
        this.field_6011.method_12778(EXPLOSION_RADIUS, (Object)Float.valueOf(radius));
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (field_6322.equals(key)) {
            this.method_18382();
        }
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new MutantGroundPathNavigation((class_1308)this, worldIn);
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return this.method_6172() ? super.method_18377(poseIn).method_19539(1.0f, 0.75f) : super.method_18377(poseIn);
    }

    public boolean method_6109() {
        return false;
    }

    public boolean method_6626() {
        return super.method_6626() && this.canRideOnShoulder() && this.method_5968() == null && this.getExplodeState() <= 0;
    }

    public void method_5800(class_3218 serverWorld, class_1538 lightningBoltEntity) {
        super.method_5800(serverWorld, lightningBoltEntity);
        this.setCharged(true);
    }

    protected boolean method_23734() {
        return !this.method_6181();
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        boolean hasFallen = super.method_5747(distance, damageMultiplier, source);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return hasFallen;
    }

    public void method_5773() {
        if (this.method_5805()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setExplodeState(1);
            }
            if ((i = this.getExplodeState()) > 0 && this.timeSinceIgnited == 0) {
                this.method_5783((class_3414)ModRegistry.ENTITY_CREEPER_MINION_PRIMED_SOUND_EVENT.get(), 1.0f, this.method_6017());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = 0;
                if (!this.field_6002.field_9236) {
                    MutatedExplosion.create((class_1297)this, this.getExplosionRadius() + (this.isCharged() ? 2.0f : 0.0f), false, this.canDestroyBlocks() ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888);
                    if (!this.canExplodeContinuously()) {
                        if (this.field_6002.method_8450().method_8355(class_1928.field_19398) && this.method_6177() instanceof class_3222) {
                            this.method_6177().method_43496((class_2561)class_2561.method_43469((String)"death.attack.explosion", (Object[])new Object[]{this.method_5476()}));
                        }
                        this.field_6272 = true;
                        this.method_31472();
                        EntityUtil.spawnLingeringCloud((class_1309)this);
                    }
                }
                this.setExplodeState(-this.fuseTime);
            }
            if (this.method_18798().method_1027() > (double)0.8f && this.method_5968() != null && this.method_5829().method_18804(this.method_18798()).method_1014(0.5).method_994(this.method_5968().method_5829())) {
                this.timeSinceIgnited = this.fuseTime;
            }
        }
        super.method_5773();
    }

    public float getFlashIntensity(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (this.method_6181()) {
            if (item == ModRegistry.CREEPER_MINION_TRACKER_ITEM.get()) {
                if (this.field_6002.field_9236) {
                    Proxy.INSTANCE.displayCreeperMinionTrackerGUI(this);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (this.method_6171((class_1309)player)) {
                if (item == class_1802.field_8054) {
                    if (this.method_6032() < this.method_6063()) {
                        this.method_6025(1.0f);
                        itemstack.method_7934(1);
                        double d0 = this.field_5974.method_43059() * 0.02;
                        double d1 = this.field_5974.method_43059() * 0.02;
                        double d2 = this.field_5974.method_43059() * 0.02;
                        this.field_6002.method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d0, d1, d2);
                        return class_1269.method_29236((boolean)this.field_6002.field_9236);
                    }
                    if (this.method_6063() < 20.0f) {
                        this.method_5996(class_5134.field_23716).method_6192((double)(this.method_6063() + 1.0f));
                        itemstack.method_7934(1);
                        double d0 = this.field_5974.method_43059() * 0.02;
                        double d1 = this.field_5974.method_43059() * 0.02;
                        double d2 = this.field_5974.method_43059() * 0.02;
                        this.field_6002.method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d0, d1, d2);
                        return class_1269.method_29236((boolean)this.field_6002.field_9236);
                    }
                } else {
                    if (item != class_1802.field_8626) {
                        if (!this.field_6002.field_9236) {
                            this.method_24346(!this.method_24345());
                            this.method_6015(null);
                            this.method_5980(null);
                        }
                        return class_1269.method_29236((boolean)this.field_6002.field_9236);
                    }
                    if (!this.canExplodeContinuously()) {
                        this.field_5947 += 15;
                        this.setCanExplodeContinuously(true);
                        itemstack.method_7934(1);
                        return class_1269.method_29236((boolean)this.field_6002.field_9236);
                    }
                    float explosionRadius = this.getExplosionRadius();
                    if (explosionRadius < 4.0f) {
                        this.field_5947 += 10;
                        this.setExplosionRadius(explosionRadius + 0.11f);
                        itemstack.method_7934(1);
                        return class_1269.method_29236((boolean)this.field_6002.field_9236);
                    }
                }
            }
            return class_1269.field_5811;
        }
        if (item == class_1802.field_8884 && !this.hasIgnited()) {
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            this.field_6002.method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15145, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.field_6002.field_9236) {
                this.ignite();
                itemstack.method_7956(1, (class_1309)player, livingEntity -> livingEntity.method_20236(hand));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (player.method_7337() && item == ModRegistry.CREEPER_MINION_TRACKER_ITEM.get() && this.method_6177() == null) {
            if (!this.field_6002.field_9236) {
                this.method_6173(true);
                this.method_6174(player.method_5667());
                player.method_43496((class_2561)class_2561.method_43469((String)(((class_1792)ModRegistry.CREEPER_MINION_TRACKER_ITEM.get()).method_7876() + ".tame_success"), (Object[])new Object[]{this.method_5476(), player.method_5476()}));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        return EntityUtil.shouldAttackEntity((class_1321)this, target, owner, true);
    }

    public boolean method_6121(class_1297 entityIn) {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_5535()) {
            if (this.method_6181()) {
                return false;
            }
            if (amount >= 2.0f) {
                amount = 2.0f;
            }
        }
        this.method_24346(false);
        return super.method_5643(source, amount);
    }

    public boolean method_5659() {
        return this.method_6181();
    }

    public boolean method_5931(class_1657 player) {
        return super.method_5931(player) && this.method_6181();
    }

    public boolean method_5973(class_1299<?> typeIn) {
        return super.method_5973(typeIn) && typeIn != ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_6181();
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.72f * this.method_5751()), (double)(this.method_17681() * 0.2f));
    }

    @Nullable
    public class_270 method_5781() {
        class_1309 owner = this.method_6177();
        return owner != null ? owner.method_5781() : super.method_5781();
    }

    public boolean method_5722(class_1297 entityIn) {
        class_1309 owner = this.method_6177();
        return owner != null && (entityIn == owner || owner.method_5722(entityIn)) || super.method_5722(entityIn);
    }

    public class_1296 method_5613(class_3218 p_241840_1_, class_1296 p_241840_2_) {
        return null;
    }

    public void method_5966() {
        if (this.method_5968() == null && this.getExplodeState() <= 0) {
            super.method_5966();
        }
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.5f;
    }

    protected class_3414 method_5994() {
        return (class_3414)ModRegistry.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModRegistry.ENTITY_CREEPER_MINION_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.ENTITY_CREEPER_MINION_DEATH_SOUND_EVENT.get();
    }

    public class_3419 method_5634() {
        return this.method_6181() ? class_3419.field_15254 : class_3419.field_15251;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Tamed", this.method_6181());
        compound.method_10556("ExplodesContinuously", this.canExplodeContinuously());
        compound.method_10556("DestroysBlocks", this.canDestroyBlocks());
        compound.method_10556("CanRideOnShoulder", this.canRideOnShoulder());
        compound.method_10556("Ignited", this.hasIgnited());
        compound.method_10548("ExplosionRadius", this.getExplosionRadius());
        if (this.isCharged()) {
            compound.method_10556("Powered", true);
        }
        for (String s : new String[]{"Age", "ForcedAge", "InLove", "LoveCause"}) {
            compound.method_10551(s);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.method_6173(compound.method_10577("Tamed"));
        this.setCanExplodeContinuously(compound.method_10577("ExplodesContinuously"));
        this.setDestroyBlocks(compound.method_10577("DestroysBlocks"));
        this.setCanRideOnShoulder(compound.method_10577("CanRideOnShoulder"));
        this.setCharged(compound.method_10577("Powered"));
        if (compound.method_10545("ExplosionRadius")) {
            this.setExplosionRadius(compound.method_10583("ExplosionRadius"));
        }
        if (compound.method_10577("Ignited")) {
            this.ignite();
        }
    }

    class CreeperMinionSwellGoal
    extends class_1352 {
        public CreeperMinionSwellGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingentity = CreeperMinion.this.method_5968();
            return !CreeperMinion.this.method_24345() && (CreeperMinion.this.getExplodeState() > 0 || livingentity != null && CreeperMinion.this.method_5858((class_1297)livingentity) < 9.0 && CreeperMinion.this.method_6057((class_1297)livingentity));
        }

        public void method_6268() {
            CreeperMinion.this.setExplodeState(CreeperMinion.this.method_5968() != null && !(CreeperMinion.this.method_5858((class_1297)CreeperMinion.this.method_5968()) > 36.0) && CreeperMinion.this.method_5985().method_6369((class_1297)CreeperMinion.this.method_5968()) ? 1 : -1);
        }

        public void method_6269() {
            CreeperMinion.this.method_5942().method_6340();
        }
    }

    class CreeperMinionFollowOwnerGoal
    extends class_1350 {
        public CreeperMinionFollowOwnerGoal() {
            super((class_1321)CreeperMinion.this, 1.2, 10.0f, 5.0f, false);
        }

        public void method_6268() {
            if (!CreeperMinion.this.method_6181()) {
                if (CreeperMinion.this.method_6177() != null) {
                    CreeperMinion.this.method_5942().method_6335((class_1297)CreeperMinion.this.method_6177(), 1.2);
                }
            } else {
                super.method_6268();
            }
        }
    }
}

