/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.MutantMonstersClient;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.EndersoulLayer;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MutantEndermanRenderer
extends AlternateMobRenderer<MutantEnderman, EntityModel<MutantEnderman>> {
    private static final ResourceLocation TEXTURE = MutantMonstersClient.entityTexture("mutant_enderman/mutant_enderman");
    private static final ResourceLocation DEATH_TEXTURE = MutantMonstersClient.entityTexture("mutant_enderman/death");
    private static final RenderType EYES_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonstersClient.entityTexture("mutant_enderman/eyes"));
    private static final RenderType DEATH_RENDER_TYPE = RenderType.m_110479_((ResourceLocation)TEXTURE);
    private final MutantEndermanModel endermanModel;
    private final EndermanModel<MutantEnderman> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(EntityRendererProvider.Context context) {
        super(context, new MutantEndermanModel(context.m_174023_(ClientModRegistry.MUTANT_ENDERMAN)), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.f_115290_;
        this.cloneModel = new EndermanModel(context.m_174023_(ClientModRegistry.ENDERMAN_CLONE));
        this.m_115326_(new EyesLayer((RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>>)this));
        this.m_115326_(new SoulLayer((RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>>)this));
        this.m_115326_(new HeldBlocksLayer((RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>>)this, context.m_234597_()));
    }

    public boolean shouldRender(MutantEnderman livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_((Mob)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            AABB teleportBoundingBox = livingEntityIn.getTeleportPosition().map(Vec3::m_82539_).map(arg_0 -> ((EntityDimensions)livingEntityIn.m_6095_().m_20680_()).m_20393_(arg_0)).orElseThrow();
            return camera.m_113029_(teleportBoundingBox);
        }
        return false;
    }

    public void render(MutantEnderman entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.isClone()) {
            this.f_115290_ = this.cloneModel;
            this.cloneModel.f_102577_ = entityIn.m_5912_();
            this.f_114477_ = 0.5f;
            this.f_114478_ = 0.5f;
        } else {
            this.f_115290_ = this.endermanModel;
            this.f_114477_ = 0.8f;
            this.f_114478_ = entityIn.f_20919_ > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(entityIn) : 1.0f;
        }
        this.teleportAttack = false;
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entityIn.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            this.teleportAttack = true;
            entityIn.getTeleportPosition().ifPresent(pos -> {
                matrixStackIn.m_85836_();
                double d0 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
                double d1 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
                double d2 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
                matrixStackIn.m_85837_((double)pos.m_123341_() + 0.5 - d0, (double)pos.m_123342_() - d1, (double)pos.m_123343_() + 0.5 - d2);
                super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.m_85849_();
            });
        }
    }

    @Override
    protected boolean hasAlternateRender(MutantEnderman mob, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (mob.f_20919_ > 80) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_173235_((ResourceLocation)DEATH_TEXTURE));
            this.f_115290_.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, MutantEndermanRenderer.getDeathProgress(mob));
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(DEATH_RENDER_TYPE);
            this.f_115290_.m_7695_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public Vec3 getRenderOffset(MutantEnderman entityIn, float partialTicks) {
        boolean death;
        boolean stare = entityIn.getAnimation() == MutantEnderman.STARE_ANIMATION;
        boolean scream = entityIn.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
        boolean clone = entityIn.isClone() && entityIn.m_5912_();
        boolean telesmash = entityIn.getAnimation() == MutantEnderman.TELESMASH_ANIMATION && entityIn.getAnimationTick() < 18;
        boolean bl = death = entityIn.getAnimation() == MutantEnderman.DEATH_ANIMATION;
        if (!(stare || scream || clone || telesmash || death)) {
            return super.m_7860_((Entity)entityIn, partialTicks);
        }
        double shake = 0.03;
        if (clone) {
            shake = 0.02;
        } else if (death) {
            shake = entityIn.getAnimationTick() < 80 ? (double)0.02f : (double)0.05f;
        } else if (entityIn.getAnimationTick() >= 40) {
            shake *= 0.5;
        }
        return new Vec3(entityIn.m_217043_().m_188583_() * shake, 0.0, entityIn.m_217043_().m_188583_() * shake);
    }

    protected float getFlipDegrees(MutantEnderman livingEntity) {
        return 0.0f;
    }

    protected RenderType getRenderType(MutantEnderman livingEntity, boolean isVisible, boolean visibleToSpectator, boolean isGlowing) {
        return livingEntity.isClone() ? null : super.m_7225_((LivingEntity)livingEntity, isVisible, visibleToSpectator, isGlowing);
    }

    private static float getDeathProgress(MutantEnderman mutantEnderman) {
        return (float)(mutantEnderman.f_20919_ - 80) / (float)(MutantEnderman.DEATH_ANIMATION.duration() - 80);
    }

    public ResourceLocation getTextureLocation(MutantEnderman entity) {
        return TEXTURE;
    }

    static class EyesLayer
    extends RenderLayer<MutantEnderman, EntityModel<MutantEnderman>> {
        public EyesLayer(RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MutantEnderman entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.isClone()) {
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(EYES_RENDER_TYPE);
                this.m_117386_().m_7695_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, entity.f_20919_ > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(entity) : 1.0f);
            }
        }
    }

    class SoulLayer
    extends EndersoulLayer<MutantEnderman, EntityModel<MutantEnderman>> {
        public SoulLayer(RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>> entityRendererIn) {
            super(entityRendererIn);
        }

        @Override
        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MutantEnderman entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean teleport = entity.getAnimation() == MutantEnderman.TELEPORT_ANIMATION && entity.getAnimationTick() < 10;
            boolean scream = entity.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
            boolean clone = entity.isClone();
            if (teleport || scream || clone) {
                float scale = 0.0f;
                if (teleport) {
                    scale = 1.2f + ((float)entity.getAnimationTick() + partialTicks) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        scale = 2.2f - ((float)entity.getAnimationTick() + partialTicks) / 10.0f;
                    }
                }
                if (scream) {
                    scale = entity.getAnimationTick() < 40 ? 1.2f + ((float)entity.getAnimationTick() + partialTicks) / 40.0f : (entity.getAnimationTick() < 160 ? 2.2f : Math.max(0.0f, 2.2f - ((float)entity.getAnimationTick() + partialTicks) / 10.0f));
                }
                matrixStackIn.m_85836_();
                if (!clone) {
                    matrixStackIn.m_85841_(scale, scale * 0.8f, scale);
                }
                super.render(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                matrixStackIn.m_85849_();
            }
        }

        @Override
        protected float getAlpha(MutantEnderman entity, float partialTicks) {
            float alpha = 1.0f;
            if (entity.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
                if (!MutantEndermanRenderer.this.teleportAttack && entity.getAnimationTick() >= 8) {
                    alpha -= ((float)entity.getAnimationTick() - 8.0f + partialTicks) / 2.0f;
                }
                if (MutantEndermanRenderer.this.teleportAttack && entity.getAnimationTick() < 2) {
                    alpha = ((float)entity.getAnimationTick() + partialTicks) / 2.0f;
                }
            }
            if (entity.getAnimation() == MutantEnderman.SCREAM_ANIMATION) {
                if (entity.getAnimationTick() < 40) {
                    alpha = ((float)entity.getAnimationTick() + partialTicks) / 40.0f;
                } else if (entity.getAnimationTick() >= 160) {
                    alpha = 1.0f - ((float)entity.getAnimationTick() + partialTicks) / 40.0f;
                }
            }
            return alpha;
        }
    }

    static class HeldBlocksLayer
    extends RenderLayer<MutantEnderman, EntityModel<MutantEnderman>> {
        private final BlockRenderDispatcher blockRenderer;

        public HeldBlocksLayer(RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>> entityRendererIn, BlockRenderDispatcher blockRenderer) {
            super(entityRendererIn);
            this.blockRenderer = blockRenderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MutantEnderman entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.getAnimation() != MutantEnderman.CLONE_ANIMATION) {
                for (int i = 0; i < 4; ++i) {
                    if (entity.getHeldBlock(i) <= 0) continue;
                    matrixStackIn.m_85836_();
                    ((MutantEndermanModel)this.m_117386_()).translateRotateArm(matrixStackIn, i);
                    matrixStackIn.m_85837_(0.0, 1.2, 0.0);
                    float tick = (float)entity.f_19797_ + (float)(i + 1) * 2.0f * (float)Math.PI + partialTicks;
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(tick * 10.0f));
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tick * 8.0f));
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(tick * 6.0f));
                    matrixStackIn.m_85841_(-0.75f, -0.75f, 0.75f);
                    matrixStackIn.m_85837_(-0.5, -0.5, 0.5);
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    this.blockRenderer.m_110912_(Block.m_49803_((int)entity.getHeldBlock(i)), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_);
                    matrixStackIn.m_85849_();
                }
            }
        }
    }
}

