/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.MutantMonstersClient;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantZombieModel;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class MutantZombieRenderer
extends AlternateMobRenderer<MutantZombie, MutantZombieModel> {
    private static final ResourceLocation TEXTURE = MutantMonstersClient.entityTexture("mutant_zombie");

    public MutantZombieRenderer(EntityRendererProvider.Context context) {
        super(context, new MutantZombieModel(context.m_174023_(ClientModRegistry.MUTANT_ZOMBIE)), 1.0f);
    }

    protected void scale(MutantZombie livingEntity, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(1.3f, 1.3f, 1.3f);
    }

    protected void setupRotations(MutantZombie livingEntity, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (livingEntity.f_20919_ > 0) {
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
            int pitch = Math.min(20, livingEntity.f_20919_);
            boolean reviving = false;
            if (livingEntity.f_20919_ > 100) {
                pitch = 140 - livingEntity.f_20919_;
                reviving = true;
            }
            if (pitch > 0) {
                float f = ((float)pitch + partialTicks - 1.0f) / 20.0f * 1.6f;
                if (reviving) {
                    f = ((float)pitch - partialTicks) / 40.0f * 1.6f;
                }
                if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(f * this.getFlipDegrees(livingEntity)));
            }
        } else {
            super.m_7523_((LivingEntity)livingEntity, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected float getFlipDegrees(MutantZombie livingEntity) {
        return 80.0f;
    }

    protected RenderType getRenderType(MutantZombie livingEntity, boolean isVisible, boolean visibleToSpectator, boolean glowing) {
        return super.m_7225_((LivingEntity)livingEntity, isVisible, visibleToSpectator | livingEntity.vanishTime > 0, glowing);
    }

    @Override
    protected float getAlpha(MutantZombie mob, float partialTicks) {
        return mob.vanishTime > 0 ? 1.0f - ((float)mob.vanishTime + partialTicks) / 100.0f * 0.6f : 1.0f;
    }

    @Override
    protected boolean showsHurtColor(MutantZombie mob) {
        return super.showsHurtColor(mob) || mob.f_20919_ > 0 && mob.getLives() <= 0;
    }

    public ResourceLocation getTextureLocation(MutantZombie entity) {
        return TEXTURE;
    }
}

