/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.capability.SeismicWavesCapability;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.core.SeismicWave;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    private static final int MAX_SEISMIC_WAVES_PER_PLAYER = 16;

    public static EventResult onItemUseTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.get() && useItem.m_41720_() instanceof BowItem && useItem.m_41779_() - useItemRemaining.getAsInt() < 20) {
            useItemRemaining.mapInt(i -> i - 3);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(Player player, ItemStack stack, Level level, MutableInt charge, boolean hasAmmo) {
        if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get() && hasAmmo) {
            boolean inAir = !player.m_20096_() && !player.m_20069_() && !player.m_20077_();
            ItemStack ammo = player.m_6298_(stack);
            if (!ammo.m_41619_() || hasAmmo) {
                boolean infiniteArrows;
                if (ammo.m_41619_()) {
                    ammo = new ItemStack((ItemLike)Items.f_42412_);
                }
                float velocity = BowItem.m_40661_((int)(stack.m_41779_() - charge.getAsInt()));
                boolean bl = infiniteArrows = player.m_150110_().f_35937_ || ammo.m_41720_() instanceof ArrowItem && CommonAbstractions.INSTANCE.isArrowInfinite((ArrowItem)ammo.m_41720_(), ammo, stack, player);
                if (!level.f_46443_) {
                    int k;
                    int j;
                    ArrowItem arrowitem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
                    AbstractArrow abstractarrowentity = arrowitem.m_6394_(level, ammo, (LivingEntity)player);
                    abstractarrowentity = CommonAbstractions.INSTANCE.getCustomArrowShotFromBow((BowItem)stack.m_41720_(), abstractarrowentity);
                    abstractarrowentity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity * 3.0f, 1.0f);
                    if (velocity == 1.0f && inAir) {
                        abstractarrowentity.m_36762_(true);
                    }
                    if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                        abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        abstractarrowentity.m_36735_(k);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        abstractarrowentity.m_20254_(100);
                    }
                    abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() * (inAir ? 2.0 : 0.5));
                    stack.m_41622_(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.m_21190_(player.m_7655_()));
                    if (infiniteArrows || player.m_150110_().f_35937_ && (ammo.m_41720_() == Items.f_42737_ || ammo.m_41720_() == Items.f_42738_)) {
                        abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.m_7967_((Entity)abstractarrowentity);
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (player.m_217043_().m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!infiniteArrows && !player.m_150110_().f_35937_) {
                    ammo.m_41774_(1);
                    if (ammo.m_41619_()) {
                        player.m_150109_().m_36057_(ammo);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onPlayerTick$End(Player player) {
        PlayerEventsHandler.playShoulderEntitySound(player, player.m_36331_());
        PlayerEventsHandler.playShoulderEntitySound(player, player.m_36332_());
        if (!player.f_19853_.f_46443_) {
            ModRegistry.SEISMIC_WAVES_CAPABILITY.maybeGet((Object)player).map(SeismicWavesCapability::seismicWaves).ifPresent(seismicWaves -> {
                while (seismicWaves.size() > 16) {
                    seismicWaves.poll();
                }
                if (!seismicWaves.isEmpty()) {
                    PlayerEventsHandler.handleSeismicWave(player, (SeismicWave)((Object)((Object)seismicWaves.poll())));
                }
            });
        }
    }

    private static void handleSeismicWave(Player player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(player.f_19853_, (Entity)player);
        AABB box = new AABB((double)seismicWave.m_123341_(), (double)seismicWave.m_123342_() + 1.0, (double)seismicWave.m_123343_(), (double)seismicWave.m_123341_() + 1.0, (double)seismicWave.m_123342_() + 2.0, (double)seismicWave.m_123343_() + 1.0);
        for (LivingEntity livingEntity : player.f_19853_.m_45976_(LivingEntity.class, box)) {
            if (livingEntity == player || player.m_20202_() == livingEntity) continue;
            livingEntity.m_6469_(DamageSource.m_19344_((Player)player).m_19382_(), (float)(6 + player.m_217043_().m_188503_(3)));
        }
    }

    private static void playShoulderEntitySound(Player player, @Nullable CompoundTag compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.m_128441_("Silent")) break block2;
                if (compoundNBT.m_128471_("Silent")) break block3;
            }
            EntityType.m_20632_((String)compoundNBT.m_128461_("id")).filter(((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get())::equals).ifPresent(entityType -> {
                if (player.f_19853_.f_46441_.m_188503_(500) == 0) {
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.get(), player.m_5720_(), 1.0f, (player.f_19853_.f_46441_.m_188501_() - player.f_19853_.f_46441_.m_188501_()) * 0.2f + 1.5f);
                }
            });
        }
    }

    public static EventResult onItemToss(ItemEntity entityItem, Player player) {
        Level world = player.f_19853_;
        if (!world.f_46443_) {
            boolean isHand;
            ItemStack stack = entityItem.m_32055_();
            boolean bl = isHand = stack.m_41720_() == ModRegistry.ENDERSOUL_HAND_ITEM.get() && stack.m_41768_();
            if (stack.m_41720_() == Items.f_42545_ || isHand) {
                int count = 0;
                for (EndersoulFragment orb : world.m_45976_(EndersoulFragment.class, player.m_20191_().m_82400_(8.0))) {
                    if (orb.getOwner() != player) continue;
                    ++count;
                    orb.m_146870_();
                }
                if (count > 0) {
                    EntityUtil.sendParticlePacket((Entity)player, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), 256);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.m_41773_() - addDmg;
                        stack.m_41721_(Math.max(dmg, 0));
                    } else {
                        ItemStack newStack = new ItemStack((ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.get());
                        newStack.m_41721_(((Item)ModRegistry.ENDERSOUL_HAND_ITEM.get()).m_41462_() - addDmg);
                        entityItem.m_32045_(newStack);
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

