/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CreeperMinionEgg
extends Entity {
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(CreeperMinionEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int health = 8;
    private int age = (60 + this.f_19796_.m_188503_(40)) * 1200;
    private int recentlyHit;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private UUID ownerUUID;
    private int dismountTicks;

    public CreeperMinionEgg(EntityType<? extends CreeperMinionEgg> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public CreeperMinionEgg(MutantCreeper spawner, Entity owner) {
        this((EntityType<? extends CreeperMinionEgg>)((EntityType)ModRegistry.CREEPER_MINION_EGG_ENTITY_TYPE.get()), spawner.f_19853_);
        this.ownerUUID = owner.m_20148_();
        this.m_6034_(spawner.m_20185_(), spawner.m_20186_(), spawner.m_20189_());
        if (spawner.isCharged()) {
            this.setCharged(true);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CHARGED, (Object)false);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(CHARGED, (Object)charged);
    }

    public double m_6049_() {
        return this.m_20202_() instanceof Player ? (double)this.m_20206_() - (this.m_20202_().m_20089_() == Pose.CROUCHING ? 0.35 : 0.2) : 0.0;
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_7337_(Entity entity) {
        return Boat.m_38323_((Entity)this, (Entity)entity);
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        this.m_20334_(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void m_6001_(double x, double y, double z) {
        super.m_6001_(x, y, z);
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
    }

    private void hatch() {
        Player playerEntity;
        CreeperMinion minion = (CreeperMinion)((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get()).m_20615_(this.f_19853_);
        if (this.ownerUUID != null && (playerEntity = this.f_19853_.m_46003_(this.ownerUUID)) != null && !CommonAbstractions.INSTANCE.onAnimalTame((Animal)minion, playerEntity)) {
            minion.m_21828_(playerEntity);
            minion.m_21839_(true);
        }
        if (this.isCharged()) {
            minion.setCharged(true);
        }
        minion.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.f_19853_.m_7967_((Entity)minion);
        this.m_5496_((SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_EGG_HATCH_SOUND_EVENT.get(), 0.7f, 0.9f + this.f_19796_.m_188501_() * 0.1f);
        this.m_146870_();
    }

    public void m_8038_(ServerLevel serverWorld, LightningBolt lightningBoltEntity) {
        super.m_8038_(serverWorld, lightningBoltEntity);
        this.setCharged(true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, 0.0, 0.7));
        }
        if (this.m_20159_()) {
            if (this.m_146895_() != null) {
                this.dismountTicks = 10;
            } else if (this.dismountTicks > 0) {
                --this.dismountTicks;
            }
            Entity rootVehicle = this.m_20201_();
            if (this.m_5830_() || !rootVehicle.m_217003_(Pose.STANDING) && !rootVehicle.m_217003_(Pose.CROUCHING) || this.dismountTicks <= 0 && rootVehicle.m_6144_() || rootVehicle.m_5833_()) {
                this.m_8127_();
                this.playMountSound(false);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.health < 8 && this.f_19797_ - this.recentlyHit > 80 && this.f_19797_ % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0) {
                this.hatch();
            }
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_36341_() && player.m_217003_(Pose.STANDING)) {
            Entity topPassenger = this.getTopPassenger((Entity)player);
            this.m_7998_(topPassenger, true);
            this.playMountSound(true);
            if (this.f_19853_.f_46443_) {
                Proxy.INSTANCE.showDismountMessage();
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private Entity getTopPassenger(Entity entity) {
        List list = entity.m_20197_();
        return !list.isEmpty() ? this.getTopPassenger((Entity)list.get(0)) : entity;
    }

    private void playMountSound(boolean mount) {
        this.m_5496_(SoundEvents.f_12019_, 0.7f, (mount ? 0.6f : 0.3f) + this.f_19796_.m_188501_() * 0.1f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            this.m_5834_();
            if (source.m_19372_()) {
                this.age = (int)((float)this.age - amount * 80.0f);
                EntityUtil.sendParticlePacket(this, (ParticleOptions)ParticleTypes.f_123750_, (int)(amount / 2.0f));
                return false;
            }
            this.recentlyHit = this.f_19797_;
            this.m_20334_(0.0, 0.2, 0.0);
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                MutatedExplosion.create(this, this.isCharged() ? 2.0f : 0.0f, false, Level.ExplosionInteraction.TNT);
                if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    if (!this.isCharged() && this.f_19796_.m_188503_(3) != 0) {
                        for (int i = 5 + this.f_19796_.m_188503_(6); i > 0; --i) {
                            this.m_19998_((ItemLike)Items.f_42403_);
                        }
                    } else {
                        this.m_19998_((ItemLike)ModRegistry.CREEPER_SHARD_ITEM.get());
                    }
                }
                this.m_146870_();
            }
            return true;
        }
        return false;
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Health", this.health);
        compound.m_128405_("Age", this.age);
        compound.m_128405_("RecentlyHit", this.recentlyHit);
        if (this.isCharged()) {
            compound.m_128379_("Charged", true);
        }
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
        compound.m_128344_("DismountTicks", (byte)this.dismountTicks);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Health")) {
            this.health = compound.m_128451_("Health");
        }
        if (compound.m_128441_("Age")) {
            this.age = compound.m_128451_("Age");
        }
        this.recentlyHit = compound.m_128451_("RecentlyHit");
        this.setCharged(compound.m_128471_("Charged"));
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        } else if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
        }
        this.dismountTicks = compound.m_128445_("DismountTicks");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

