/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class EndersoulClone
extends Monster {
    private MutantEnderman cloner;

    public EndersoulClone(EntityType<? extends EndersoulClone> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.0f;
        this.f_21364_ = this.f_19796_.m_188503_(2);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_CACTUS, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return EndersoulClone.m_33035_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.55f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    public void setCloner(MutantEnderman cloner) {
        this.cloner = cloner;
        this.m_21051_(Attributes.f_22276_).m_22100_((double)cloner.m_21233_());
        this.m_21153_(cloner.m_21223_());
        if (cloner.m_8077_()) {
            this.m_6593_(cloner.m_7770_());
            this.m_20340_(cloner.m_20151_());
        }
    }

    public int m_6056_() {
        return 3;
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 0) {
            EntityUtil.spawnEndersoulParticles((Entity)this, this.f_19796_, 256, 1.8f);
        }
    }

    public void m_8107_() {
        this.f_20899_ = false;
        super.m_8107_();
        if (this.cloner != null && (this.cloner.m_21525_() || !this.cloner.m_6084_() || this.cloner.f_19853_ != this.f_19853_)) {
            this.m_146870_();
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (!this.f_19853_.f_46443_ && this.f_19796_.m_188503_(3) != 0) {
            this.teleportToEntity(entityIn);
        }
        if (flag) {
            this.m_5634_(2.0f);
        }
        this.m_6674_(InteractionHand.MAIN_HAND);
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean remove;
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7639_() instanceof EnderDragon) {
            return false;
        }
        boolean bl = remove = !this.f_19853_.f_46443_ && this.m_6084_() && this.f_19797_ > 10;
        if (remove) {
            if (source.m_7639_() instanceof Player) {
                this.m_6598_((Player)source.m_7639_());
            }
            this.m_6668_(source);
            this.m_21226_();
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
        return remove;
    }

    protected void m_8024_() {
        LivingEntity entity = this.m_5448_();
        if (this.f_19796_.m_188503_(10) == 0 && entity != null && (this.m_20069_() || this.m_20365_((Entity)entity) || this.m_20280_((Entity)entity) > 1024.0 || !this.m_21691_())) {
            this.teleportToEntity((Entity)entity);
        }
        if (this.cloner != null && entity != this.cloner.m_5448_()) {
            this.m_6710_(this.cloner.m_5448_());
        }
    }

    private boolean teleportToEntity(Entity entity) {
        double z;
        double y;
        double x = entity.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
        boolean teleport = EntityUtil.teleportTo((Mob)this, x, y = entity.m_20186_() + (double)this.f_19796_.m_188503_(5) + 4.0, z = entity.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 24.0);
        if (teleport) {
            this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModRegistry.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.get(), this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_((SoundEvent)ModRegistry.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.get(), 1.0f, 1.0f);
            this.m_8127_();
        }
        return teleport;
    }

    protected void m_6138_() {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effectInstanceIn, @Nullable Entity entity) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.cloner != null;
    }

    public void m_6074_() {
        super.m_6074_();
        this.f_19853_.m_7605_((Entity)this, (byte)0);
        this.m_5496_(this.m_5592_(), this.m_6121_(), this.m_6100_());
    }

    public boolean m_7306_(Entity entityIn) {
        return super.m_7306_(entityIn) || entityIn instanceof MutantEnderman;
    }

    public boolean m_20086_(CompoundTag compound) {
        return this.cloner == null && super.m_20086_(compound);
    }

    public boolean m_7307_(Entity entityIn) {
        return this.cloner != null && (this.cloner == entityIn || this.cloner.m_7307_(entityIn)) || super.m_7307_(entityIn);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_ENDERSOUL_CLONE_DEATH_SOUND_EVENT.get();
    }
}

