/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantSkeletonBodyPart
extends Entity {
    private static final EntityDataAccessor<Byte> PART = SynchedEntityData.m_135353_(MutantSkeletonBodyPart.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final boolean yawPositive;
    private final boolean pitchPositive;
    private WeakReference<Mob> owner;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private int despawnTimer;

    public MutantSkeletonBodyPart(EntityType<? extends MutantSkeletonBodyPart> type, Level world) {
        super(type, world);
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        this.f_19859_ = this.m_146908_();
        this.m_146926_(this.f_19796_.m_188501_() * 360.0f);
        this.f_19860_ = this.m_146909_();
        this.yawPositive = this.f_19796_.m_188499_();
        this.pitchPositive = this.f_19796_.m_188499_();
    }

    public MutantSkeletonBodyPart(Level world, Mob owner, int part) {
        this((EntityType<? extends MutantSkeletonBodyPart>)((EntityType)ModRegistry.BODY_PART_ENTITY_TYPE.get()), world);
        this.owner = new WeakReference<Mob>(owner);
        this.setPart(part);
        this.m_6034_(owner.m_20185_(), owner.m_20186_() + (double)(3.2f * (0.25f + this.f_19796_.m_188501_() * 0.5f)), owner.m_20189_());
        this.m_7311_(owner.m_20094_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PART, (Object)0);
    }

    public int getPart() {
        return ((Byte)this.f_19804_.m_135370_(PART)).byteValue();
    }

    private void setPart(int id) {
        this.f_19804_.m_135381_(PART, (Object)((byte)id));
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getLegacyItemByPart());
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_20334_(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void m_6001_(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        this.m_20334_(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.045, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.96));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.7));
        }
        if (!this.f_19861_ && this.f_19865_ == Vec3.f_82478_) {
            this.m_146922_(this.m_146908_() + 10.0f * (float)(this.yawPositive ? 1 : -1));
            this.m_146926_(this.m_146909_() + 15.0f * (float)(this.pitchPositive ? 1 : -1));
            for (Entity entity : this.f_19853_.m_6249_((Entity)this, this.m_20191_(), this::canHarm)) {
                if (!entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)(this.owner != null ? (Entity)this.owner.get() : this)), 4.0f + (float)this.f_19796_.m_188503_(4))) continue;
                entity.m_20254_(this.m_20094_() / 20);
            }
            if (this.despawnTimer > 0) {
                --this.despawnTimer;
            }
        } else {
            ++this.despawnTimer;
        }
        if (!this.f_19853_.f_46443_ && this.despawnTimer >= this.getMaxAge()) {
            this.m_146870_();
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ResourceLocation location;
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_) && (location = this.getItemPartLootTableId()) != null) {
            LootTable lootTable = this.f_19853_.m_7654_().m_129898_().m_79217_(location);
            ObjectArrayList list = lootTable.m_230922_(new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)this).m_230911_(this.f_19853_.f_46441_).m_78975_(ModRegistry.BODY_PART_LOOT_CONTEXT_PARAM_SET));
            for (ItemStack item : list) {
                if (item.m_41619_()) continue;
                this.m_19983_(item).m_32061_();
            }
        }
        this.m_146870_();
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    private boolean canHarm(Entity entity) {
        return entity.m_6087_() && entity.m_6095_() != ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get();
    }

    protected Component m_5677_() {
        return Component.m_237115_((String)this.getLegacyItemByPart().m_5524_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    private Item getLegacyItemByPart() {
        int part = this.getPart();
        if (part == 0) {
            return (Item)ModRegistry.MUTANT_SKELETON_PELVIS_ITEM.get();
        }
        if (part >= 1 && part < 19) {
            return (Item)ModRegistry.MUTANT_SKELETON_RIB_ITEM.get();
        }
        if (part == 19) {
            return (Item)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get();
        }
        if (part >= 21 && part < 29) {
            return (Item)ModRegistry.MUTANT_SKELETON_LIMB_ITEM.get();
        }
        return part != 29 && part != 30 ? Items.f_41852_ : (Item)ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_ITEM.get();
    }

    @Nullable
    public ResourceLocation getItemPartLootTableId() {
        int part = this.getPart();
        if (part == 0) {
            return ModRegistry.MUTANT_SKELETON_PELVIS_LOOT_TABLE;
        }
        if (part >= 1 && part < 19) {
            return ModRegistry.MUTANT_SKELETON_RIB_LOOT_TABLE;
        }
        if (part == 19) {
            return ModRegistry.MUTANT_SKELETON_SKULL_LOOT_TABLE;
        }
        if (part >= 21 && part < 29) {
            return ModRegistry.MUTANT_SKELETON_LIMB_LOOT_TABLE;
        }
        return part != 29 && part != 30 ? null : ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_LOOT_TABLE;
    }

    public int getMaxAge() {
        return 6000;
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128344_("Part", (byte)this.getPart());
        compound.m_128376_("DespawnTimer", (short)this.despawnTimer);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setPart(compound.m_128445_("Part"));
        this.despawnTimer = compound.m_128448_("DespawnTimer");
    }
}

