/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpiderPig
extends TamableAnimal
implements PlayerRideableJumping,
Saddleable,
NeutralMob {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(SpiderPig.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42620_, Items.f_42732_, Items.f_42485_, Items.f_42591_});
    private int leapCooldown;
    private int leapTick;
    private boolean isLeaping;
    private float chargePower;
    private int chargingTick;
    private int chargeExhaustion;
    private boolean chargeExhausted;
    private final List<WebPos> webList = new ArrayList<WebPos>(12);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public SpiderPig(EntityType<? extends SpiderPig> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.1).setMaxAttackTick(16));
        this.f_21345_.m_25352_(2, (Goal)new LeapAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.1, () -> ((SpiderPig)this).m_6162_()));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, true));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42684_}), false));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.1, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(7, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new OwnerTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SpiderPig)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Mob.class, true, SpiderPig::isPigOrSpider));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return SpiderPig.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    private void setBesideClimbableBlock(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.75f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() != MobEffects.f_19614_ && super.m_7301_(potioneffectIn);
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.setBesideClimbableBlock(this.f_19862_);
        if (this.chargeExhaustion >= 120) {
            this.chargeExhausted = true;
        }
        if (this.chargeExhaustion <= 0) {
            this.chargeExhausted = false;
        }
        this.chargeExhaustion = Math.max(0, this.chargeExhaustion - 1);
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
            this.leapCooldown = Math.max(0, this.leapCooldown - 1);
            if (this.leapTick > 10 && this.f_19861_) {
                this.isLeaping = false;
            }
            this.updateWebList(false);
            this.updateChargeState();
            if (this.m_6084_() && this.m_21824_() && this.f_19797_ % 600 == 0) {
                this.m_5634_(1.0f);
            }
        }
    }

    private void updateWebList(boolean onlyCheckSize) {
        WebPos first;
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webList.size(); ++i) {
                WebPos coord = this.webList.get(i);
                if (this.f_19853_.m_8055_((BlockPos)coord) != Blocks.f_50033_.m_49966_()) {
                    this.webList.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webList.isEmpty()) {
                first = this.webList.get(0);
                if (first.timeLeft < 0) {
                    this.webList.remove(0);
                    this.removeWeb(first);
                }
            }
        }
        while (this.webList.size() > 12) {
            first = this.webList.remove(0);
            this.removeWeb(first);
        }
    }

    private void removeWeb(BlockPos pos) {
        if (this.f_19853_.m_8055_(pos).m_60713_(Blocks.f_50033_) && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.f_19853_, (Entity)this)) {
            this.f_19853_.m_46953_(pos, false, (Entity)this);
        }
    }

    private void updateChargeState() {
        if (this.chargingTick > 0) {
            for (LivingEntity livingEntity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_(), EntitySelector.m_20431_((Entity)this))) {
                if (livingEntity == this || livingEntity == this.m_21826_() || !livingEntity.m_5789_()) continue;
                this.m_7327_((Entity)livingEntity);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public InteractionResult m_6071_(Player playerEntity, InteractionHand hand) {
        InteractionResult actionresulttype = super.m_6071_(playerEntity, hand);
        if (!actionresulttype.m_19077_() && this.m_21830_((LivingEntity)playerEntity)) {
            ItemStack itemstack = playerEntity.m_21120_(hand);
            boolean isBreedingItem = this.m_6898_(itemstack);
            if (!isBreedingItem && this.m_6254_() && !this.m_20160_() && !playerEntity.m_36341_()) {
                if (!this.f_19853_.f_46443_) {
                    playerEntity.m_20329_((Entity)this);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (itemstack.m_41720_() == Items.f_42450_) {
                return itemstack.m_41647_(playerEntity, (LivingEntity)this, hand);
            }
            if (itemstack.m_41614_() && isBreedingItem && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(playerEntity, hand, itemstack);
                this.m_5634_(itemstack.m_41720_().m_41473_().m_38744_());
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return actionresulttype;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        return EntityUtil.shouldAttackEntity(this, target, owner, false);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        this.isLeaping = false;
        if (this.f_19796_.m_188503_(2) == 0 && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.f_19853_, (Entity)this)) {
            double dx = entityIn.m_20185_() - entityIn.f_19854_;
            double dz = entityIn.m_20189_() - entityIn.f_19856_;
            BlockPos pos = new BlockPos((int)(entityIn.m_20185_() + dx * 0.5), Mth.m_14107_((double)this.m_20191_().f_82289_), (int)(entityIn.m_20189_() + dz * 0.5));
            Material material = this.f_19853_.m_8055_(pos).m_60767_();
            if (!material.m_76333_() && !material.m_76332_() && material != Material.f_76311_) {
                this.f_19853_.m_46597_(pos, Blocks.f_50033_.m_49966_());
                this.webList.add(new WebPos(pos, this.chargingTick > 0 ? 600 : 1200));
                this.updateWebList(true);
                this.m_20334_(0.0, Math.max(0.25, this.m_20184_().f_82480_), 0.0);
                this.f_19789_ = 0.0f;
            }
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        if (!(entityIn instanceof Spider) && !(entityIn instanceof SpiderPig)) {
            if (this.f_19853_.m_45556_(entityIn.m_20191_()).anyMatch(Blocks.f_50033_.m_49966_()::equals)) {
                damage += 4.0f;
            }
        }
        if (flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage)) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean m_7132_(Player player) {
        return this.m_6254_() && !this.chargeExhausted && !this.f_19862_;
    }

    public void m_7888_(int jumpPowerIn) {
        this.chargeExhaustion += 50 * jumpPowerIn / 100;
        this.chargePower = (float)jumpPowerIn / 100.0f;
    }

    public void m_7199_(int jumpPowerIn) {
        this.chargingTick = 8 * jumpPowerIn / 100;
    }

    public void m_8012_() {
    }

    public boolean m_6741_() {
        return this.m_6084_() && this.m_21824_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource soundCategory) {
        this.setSaddled(true);
        if (soundCategory != null) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12236_, soundCategory, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 2) != 0;
    }

    private void setSaddled(boolean saddled) {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        this.f_19804_.m_135381_(f_21798_, (Object)(saddled ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.m_20160_() && this.m_6254_();
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public boolean canBeControlledByRider() {
        return this.m_6688_() instanceof LivingEntity;
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB axisalignedbb = livingEntity.m_21270_(pose);
            for (int[] aint1 : aint) {
                Vec3 vector3d;
                blockpos$mutable.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                double d0 = this.f_19853_.m_45573_((BlockPos)blockpos$mutable);
                if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)livingEntity, (AABB)axisalignedbb.m_82383_(vector3d = Vec3.m_82514_((Vec3i)blockpos$mutable, (double)d0)))) continue;
                livingEntity.m_20124_(pose);
                return vector3d;
            }
        }
        return super.m_7688_(livingEntity);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20160_() && this.canBeControlledByRider() && this.m_6254_()) {
            LivingEntity passenger = (LivingEntity)this.m_6688_();
            this.f_19793_ = 1.0f;
            this.m_146922_(passenger.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(passenger.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            if (this.chargeExhausted || !(this.chargePower > 0.0f) || !this.f_19861_ && this.m_146900_().m_60819_().m_76178_()) {
                this.chargePower = 0.0f;
            } else {
                double power = (double)1.6f * (double)this.chargePower;
                Vec3 lookVector = this.m_20154_();
                this.m_20334_(lookVector.f_82479_ * power, (double)0.3f * (double)this.m_20098_(), lookVector.f_82481_ * power);
                this.chargePower = 0.0f;
            }
            this.f_20887_ = this.m_6113_() * 0.1f;
            if (this.m_6109_()) {
                float strafe = passenger.f_20900_ * 0.8f;
                float forward = passenger.f_20902_ * 0.6f;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
            } else if (passenger instanceof Player) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                this.m_21043_((LivingEntity)this, false);
            }
        } else {
            this.f_19793_ = 0.6f;
            this.f_20887_ = 0.02f;
            super.m_7023_(travelVector);
        }
    }

    public boolean m_214076_(ServerLevel serverWorld, LivingEntity livingEntity) {
        if (livingEntity instanceof CreeperMinion) {
            CreeperMinion minion = (CreeperMinion)livingEntity;
            if (!this.m_21824_()) {
                LivingEntity owner = minion.m_21826_();
                if (owner instanceof Player && !CommonAbstractions.INSTANCE.onAnimalTame((Animal)this, (Player)owner)) {
                    serverWorld.m_7605_((Entity)this, (byte)7);
                    this.m_21828_((Player)owner);
                    minion.m_146870_();
                    return false;
                }
                serverWorld.m_7605_((Entity)this, (byte)6);
            }
        }
        if (SpiderPig.isPigOrSpider(livingEntity)) {
            EntityUtil.convertMobWithNBT(livingEntity, (EntityType)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), false);
            return false;
        }
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21824_();
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public void m_7601_(BlockState blockState, Vec3 motionMultiplier) {
        if (!blockState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(blockState, motionMultiplier);
        }
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        if (this.f_19796_.m_188503_(20) == 0) {
            return (AgeableMob)EntityType.f_20510_.m_20615_((Level)serverWorld);
        }
        SpiderPig spiderPig = (SpiderPig)((EntityType)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get()).m_20615_((Level)serverWorld);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            spiderPig.m_21816_(uuid);
            spiderPig.m_7105_(true);
        }
        return spiderPig;
    }

    protected void m_5907_() {
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
            this.setSaddled(false);
        }
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.f_20890_ && !this.f_19853_.f_46443_ && !this.webList.isEmpty()) {
            for (WebPos webPos : this.webList) {
                this.removeWeb(webPos);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
        compound.m_128379_("Saddle", this.m_6254_());
        if (!this.webList.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (WebPos coord : this.webList) {
                CompoundTag compound1 = NbtUtils.m_129224_((BlockPos)coord);
                compound1.m_128405_("TimeLeft", coord.timeLeft);
                listnbt.add((Object)compound1);
            }
            compound.m_128365_("Webs", (Tag)listnbt);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.f_19853_ instanceof ServerLevel) {
            this.m_147285_(this.f_19853_, compound);
        }
        this.setSaddled(compound.m_128471_("Saddle") || compound.m_128471_("Saddled"));
        ListTag listnbt = compound.m_128437_("Webs", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compound1 = listnbt.m_128728_(i);
            this.webList.add(i, new WebPos(NbtUtils.m_129239_((CompoundTag)compound1), compound1.m_128451_("TimeLeft")));
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ENTITY_SPIDER_PIG_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_SPIDER_PIG_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_SPIDER_PIG_DEATH_SOUND_EVENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public static boolean isPigOrSpider(LivingEntity livingEntity) {
        return livingEntity.m_6095_() == EntityType.f_20510_ || livingEntity.m_6095_() == EntityType.f_20479_;
    }

    class LeapAttackGoal
    extends Goal {
        LeapAttackGoal() {
        }

        public boolean m_8036_() {
            LivingEntity target = SpiderPig.this.m_5448_();
            return target != null && SpiderPig.this.leapCooldown <= 0 && (SpiderPig.this.f_19861_ || !SpiderPig.this.m_146900_().m_60819_().m_76178_()) && (SpiderPig.this.m_20280_((Entity)target) < 64.0 && SpiderPig.this.f_19796_.m_188503_(8) == 0 || SpiderPig.this.m_20280_((Entity)target) < 6.25);
        }

        public void m_8056_() {
            SpiderPig.this.isLeaping = true;
            SpiderPig.this.leapCooldown = 15;
            LivingEntity target = SpiderPig.this.m_5448_();
            double x = target.m_20185_() - SpiderPig.this.m_20185_();
            double y = target.m_20186_() - SpiderPig.this.m_20186_();
            double z = target.m_20189_() - SpiderPig.this.m_20189_();
            double d = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
            double scale = 2.0f + 0.2f * SpiderPig.this.f_19796_.m_188501_() * SpiderPig.this.f_19796_.m_188501_();
            SpiderPig.this.m_20334_(x / d * scale, (y / d * scale * 0.5 + 0.3) * (double)SpiderPig.this.m_20098_(), z / d * scale);
        }

        public boolean m_8045_() {
            return SpiderPig.this.isLeaping && SpiderPig.this.leapTick < 40;
        }

        public void m_8037_() {
            ++SpiderPig.this.leapTick;
        }

        public void m_8041_() {
            SpiderPig.this.leapTick = 0;
        }
    }

    static class WebPos
    extends BlockPos {
        private int timeLeft;

        public WebPos(BlockPos pos, int timeLeft) {
            super((Vec3i)pos);
            this.timeLeft = timeLeft;
        }
    }
}

