/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1316;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1404;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1429;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_5275;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class SpiderPig
extends class_1321
implements class_1316,
class_5146,
class_5354 {
    private static final class_2940<Boolean> CLIMBING = class_2945.method_12791(SpiderPig.class, (class_2941)class_2943.field_13323);
    private static final class_1856 TEMPTATION_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8179, class_1802.field_8567, class_1802.field_8186, class_1802.field_8389, class_1802.field_8680});
    private int leapCooldown;
    private int leapTick;
    private boolean isLeaping;
    private float chargePower;
    private int chargingTick;
    private int chargeExhaustion;
    private boolean chargeExhausted;
    private final List<WebPos> webList = new ArrayList<WebPos>(12);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public SpiderPig(class_1299<? extends SpiderPig> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.1).setMaxAttackTick(16));
        this.field_6201.method_6277(2, (class_1352)new LeapAttackGoal());
        this.field_6201.method_6277(3, (class_1352)new AvoidDamageGoal((class_1314)this, 1.1, () -> ((SpiderPig)this).method_6109()));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f, true));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.1, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8184}), false));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.1, TEMPTATION_ITEMS, false));
        this.field_6201.method_6277(7, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new OwnerTargetGoal(this));
        this.field_6185.method_6277(1, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((SpiderPig)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1308.class, true, SpiderPig::isPigOrSpider));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, true));
    }

    public static class_5132.class_5133 registerAttributes() {
        return SpiderPig.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CLIMBING, (Object)false);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_6011.method_12789(CLIMBING);
    }

    private void setBesideClimbableBlock(boolean climbing) {
        this.field_6011.method_12778(CLIMBING, (Object)climbing);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return sizeIn.field_18068 * 0.75f;
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new class_1410((class_1308)this, worldIn);
    }

    public boolean method_6049(class_1293 potioneffectIn) {
        return potioneffectIn.method_5579() != class_1294.field_5899 && super.method_6049(potioneffectIn);
    }

    public boolean method_6481(class_1799 stack) {
        return TEMPTATION_ITEMS.method_8093(stack);
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        this.setBesideClimbableBlock(this.field_5976);
        if (this.chargeExhaustion >= 120) {
            this.chargeExhausted = true;
        }
        if (this.chargeExhaustion <= 0) {
            this.chargeExhausted = false;
        }
        this.chargeExhaustion = Math.max(0, this.chargeExhaustion - 1);
        if (!this.field_6002.field_9236) {
            this.method_29510((class_3218)this.field_6002, true);
            this.leapCooldown = Math.max(0, this.leapCooldown - 1);
            if (this.leapTick > 10 && this.field_5952) {
                this.isLeaping = false;
            }
            this.updateWebList(false);
            this.updateChargeState();
            if (this.method_5805() && this.method_6181() && this.field_6012 % 600 == 0) {
                this.method_6025(1.0f);
            }
        }
    }

    private void updateWebList(boolean onlyCheckSize) {
        WebPos first;
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webList.size(); ++i) {
                WebPos coord = this.webList.get(i);
                if (this.field_6002.method_8320((class_2338)coord) != class_2246.field_10343.method_9564()) {
                    this.webList.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webList.isEmpty()) {
                first = this.webList.get(0);
                if (first.timeLeft < 0) {
                    this.webList.remove(0);
                    this.removeWeb(first);
                }
            }
        }
        while (this.webList.size() > 12) {
            first = this.webList.remove(0);
            this.removeWeb(first);
        }
    }

    private void removeWeb(class_2338 pos) {
        if (this.field_6002.method_8320(pos).method_27852(class_2246.field_10343) && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.field_6002, (class_1297)this)) {
            this.field_6002.method_8651(pos, false, (class_1297)this);
        }
    }

    private void updateChargeState() {
        if (this.chargingTick > 0) {
            for (class_1309 livingEntity : this.field_6002.method_8390(class_1309.class, this.method_5829(), class_1301.method_5913((class_1297)this))) {
                if (livingEntity == this || livingEntity == this.method_35057() || !livingEntity.method_6102()) continue;
                this.method_6121((class_1297)livingEntity);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public class_1269 method_5992(class_1657 playerEntity, class_1268 hand) {
        class_1269 actionresulttype = super.method_5992(playerEntity, hand);
        if (!actionresulttype.method_23665() && this.method_6171((class_1309)playerEntity)) {
            class_1799 itemstack = playerEntity.method_5998(hand);
            boolean isBreedingItem = this.method_6481(itemstack);
            if (!isBreedingItem && this.method_6725() && !this.method_5782() && !playerEntity.method_21823()) {
                if (!this.field_6002.field_9236) {
                    playerEntity.method_5804((class_1297)this);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (itemstack.method_7909() == class_1802.field_8175) {
                return itemstack.method_7920(playerEntity, (class_1309)this, hand);
            }
            if (itemstack.method_19267() && isBreedingItem && this.method_6032() < this.method_6063()) {
                this.method_6475(playerEntity, hand, itemstack);
                this.method_6025(itemstack.method_7909().method_19264().method_19230());
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        return actionresulttype;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        return EntityUtil.shouldAttackEntity(this, target, owner, false);
    }

    public boolean method_6121(class_1297 entityIn) {
        boolean flag;
        this.isLeaping = false;
        if (this.field_5974.method_43048(2) == 0 && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.field_6002, (class_1297)this)) {
            double dx = entityIn.method_23317() - entityIn.field_6014;
            double dz = entityIn.method_23321() - entityIn.field_5969;
            class_2338 pos = new class_2338((int)(entityIn.method_23317() + dx * 0.5), class_3532.method_15357((double)this.method_5829().field_1322), (int)(entityIn.method_23321() + dz * 0.5));
            class_3614 material = this.field_6002.method_8320(pos).method_26207();
            if (!material.method_15799() && !material.method_15797() && material != class_3614.field_15913) {
                this.field_6002.method_8501(pos, class_2246.field_10343.method_9564());
                this.webList.add(new WebPos(pos, this.chargingTick > 0 ? 600 : 1200));
                this.updateWebList(true);
                this.method_18800(0.0, Math.max(0.25, this.method_18798().field_1351), 0.0);
                this.field_6017 = 0.0f;
            }
        }
        float damage = (float)this.method_26825(class_5134.field_23721);
        if (!(entityIn instanceof class_1628) && !(entityIn instanceof SpiderPig)) {
            if (this.field_6002.method_29546(entityIn.method_5829()).anyMatch(class_2246.field_10343.method_9564()::equals)) {
                damage += 4.0f;
            }
        }
        if (flag = entityIn.method_5643(this.field_6002.method_48963().method_48812((class_1309)this), damage)) {
            this.method_5723((class_1309)this, entityIn);
        }
        return flag;
    }

    public boolean method_6153() {
        return this.method_6725() && !this.chargeExhausted && !this.field_5976;
    }

    public void method_6154(int jumpPowerIn) {
        this.chargeExhaustion += 50 * jumpPowerIn / 100;
        this.chargePower = (float)jumpPowerIn / 100.0f;
    }

    public void method_6155(int jumpPowerIn) {
        this.chargingTick = 8 * jumpPowerIn / 100;
    }

    public void method_6156() {
    }

    public boolean method_6765() {
        return this.method_5805() && this.method_6181() && !this.method_6109();
    }

    public void method_6576(@Nullable class_3419 soundCategory) {
        this.setSaddled(true);
        if (soundCategory != null) {
            this.field_6002.method_43129(null, (class_1297)this, class_3417.field_14824, soundCategory, 0.5f, 1.0f);
        }
    }

    public boolean method_6725() {
        return ((Byte)this.field_6011.method_12789(field_6322) & 2) != 0;
    }

    private void setSaddled(boolean saddled) {
        byte b0 = (Byte)this.field_6011.method_12789(field_6322);
        this.field_6011.method_12778(field_6322, (Object)(saddled ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5782() && this.method_6725();
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 entity;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1309 ? (entity = (class_1309)class_12972) : null;
    }

    public class_243 method_24829(class_1309 livingEntity) {
        class_2350 direction = this.method_5755();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_24829(livingEntity);
        }
        int[][] aint = class_5275.method_27934((class_2350)direction);
        class_2338 blockpos = this.method_24515();
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (class_4050 pose : livingEntity.method_24831()) {
            class_238 axisalignedbb = livingEntity.method_24833(pose);
            for (int[] aint1 : aint) {
                class_243 vector3d;
                blockpos$mutable.method_10103(blockpos.method_10263() + aint1[0], blockpos.method_10264(), blockpos.method_10260() + aint1[1]);
                double d0 = this.field_6002.method_30347((class_2338)blockpos$mutable);
                if (!class_5275.method_27932((double)d0) || !class_5275.method_27933((class_1941)this.field_6002, (class_1309)livingEntity, (class_238)axisalignedbb.method_997(vector3d = class_243.method_26410((class_2382)blockpos$mutable, (double)d0)))) continue;
                livingEntity.method_18380(pose);
                return vector3d;
            }
        }
        return super.method_24829(livingEntity);
    }

    public void method_6091(class_243 travelVector) {
        if (this.method_5782() && this.method_5642() != null && this.method_6725()) {
            class_1309 passenger = this.method_5642();
            this.method_49477(1.0f);
            this.method_36456(passenger.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(passenger.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6241 = this.field_6283 = this.method_36454();
            if (this.chargeExhausted || !(this.chargePower > 0.0f) || !this.field_5952 && this.method_36601().method_26227().method_15769()) {
                this.chargePower = 0.0f;
            } else {
                double power = (double)1.6f * (double)this.chargePower;
                class_243 lookVector = this.method_5720();
                this.method_18800(lookVector.field_1352 * power, (double)0.3f * (double)this.method_23313(), lookVector.field_1350 * power);
                this.chargePower = 0.0f;
            }
            if (this.method_5787()) {
                float strafe = passenger.field_6212 * 0.8f;
                float forward = passenger.field_6250 * 0.6f;
                this.method_6125((float)this.method_26825(class_5134.field_23719));
                super.method_6091(new class_243((double)strafe, travelVector.field_1351, (double)forward));
            } else if (passenger instanceof class_1657) {
                this.method_18799(class_243.field_1353);
            } else {
                this.method_29242(false);
            }
        } else {
            this.method_49477(0.6f);
            super.method_6091(travelVector);
        }
    }

    public boolean method_5874(class_3218 serverWorld, class_1309 livingEntity) {
        if (livingEntity instanceof CreeperMinion) {
            CreeperMinion minion = (CreeperMinion)livingEntity;
            if (!this.method_6181()) {
                class_1309 owner = minion.method_35057();
                if (owner instanceof class_1657 && !CommonAbstractions.INSTANCE.onAnimalTame((class_1429)this, (class_1657)owner)) {
                    serverWorld.method_8421((class_1297)this, (byte)7);
                    this.method_6170((class_1657)owner);
                    minion.method_31472();
                    return false;
                }
                serverWorld.method_8421((class_1297)this, (byte)6);
            }
        }
        if (SpiderPig.isPigOrSpider(livingEntity)) {
            EntityUtil.convertMobWithNBT(livingEntity, (class_1299)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), false);
            return false;
        }
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_6181();
    }

    public boolean method_6101() {
        return this.isBesideClimbableBlock();
    }

    public void method_5844(class_2680 blockState, class_243 motionMultiplier) {
        if (!blockState.method_27852(class_2246.field_10343)) {
            super.method_5844(blockState, motionMultiplier);
        }
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageableEntity) {
        if (this.field_5974.method_43048(20) == 0) {
            return (class_1296)class_1299.field_6093.method_5883((class_1937)serverWorld);
        }
        SpiderPig spiderPig = (SpiderPig)((class_1299)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get()).method_5883((class_1937)serverWorld);
        UUID uuid = this.method_6139();
        if (uuid != null) {
            spiderPig.method_6174(uuid);
            spiderPig.method_6173(true);
        }
        return spiderPig;
    }

    protected void method_16078() {
        if (this.method_6725()) {
            this.method_5706((class_1935)class_1802.field_8175);
            this.setSaddled(false);
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (this.field_6272 && !this.field_6002.field_9236 && !this.webList.isEmpty()) {
            for (WebPos webPos : this.webList) {
                this.removeWeb(webPos);
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.method_29517(compound);
        compound.method_10556("Saddle", this.method_6725());
        if (!this.webList.isEmpty()) {
            class_2499 listnbt = new class_2499();
            for (WebPos coord : this.webList) {
                class_2487 compound1 = class_2512.method_10692((class_2338)coord);
                compound1.method_10569("TimeLeft", coord.timeLeft);
                listnbt.add((Object)compound1);
            }
            compound.method_10566("Webs", (class_2520)listnbt);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (this.field_6002 instanceof class_3218) {
            this.method_29512(this.field_6002, compound);
        }
        this.setSaddled(compound.method_10577("Saddle") || compound.method_10577("Saddled"));
        class_2499 listnbt = compound.method_10554("Webs", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_2487 compound1 = listnbt.method_10602(i);
            this.webList.add(i, new WebPos(class_2512.method_10691((class_2487)compound1), compound1.method_10550("TimeLeft")));
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModRegistry.ENTITY_SPIDER_PIG_AMBIENT_SOUND_EVENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModRegistry.ENTITY_SPIDER_PIG_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.ENTITY_SPIDER_PIG_DEATH_SOUND_EVENT.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        this.method_5783(class_3417.field_14760, 0.15f, 1.0f);
    }

    public static boolean isPigOrSpider(class_1309 livingEntity) {
        return livingEntity.method_5864() == class_1299.field_6093 || livingEntity.method_5864() == class_1299.field_6079;
    }

    class LeapAttackGoal
    extends class_1352 {
        LeapAttackGoal() {
        }

        public boolean method_6264() {
            class_1309 target = SpiderPig.this.method_5968();
            return target != null && SpiderPig.this.leapCooldown <= 0 && (SpiderPig.this.field_5952 || !SpiderPig.this.method_36601().method_26227().method_15769()) && (SpiderPig.this.method_5858((class_1297)target) < 64.0 && SpiderPig.this.field_5974.method_43048(8) == 0 || SpiderPig.this.method_5858((class_1297)target) < 6.25);
        }

        public void method_6269() {
            SpiderPig.this.isLeaping = true;
            SpiderPig.this.leapCooldown = 15;
            class_1309 target = SpiderPig.this.method_5968();
            double x = target.method_23317() - SpiderPig.this.method_23317();
            double y = target.method_23318() - SpiderPig.this.method_23318();
            double z = target.method_23321() - SpiderPig.this.method_23321();
            double d = class_3532.method_15355((float)((float)(x * x + y * y + z * z)));
            double scale = 2.0f + 0.2f * SpiderPig.this.field_5974.method_43057() * SpiderPig.this.field_5974.method_43057();
            SpiderPig.this.method_18800(x / d * scale, (y / d * scale * 0.5 + 0.3) * (double)SpiderPig.this.method_23313(), z / d * scale);
        }

        public boolean method_6266() {
            return SpiderPig.this.isLeaping && SpiderPig.this.leapTick < 40;
        }

        public void method_6268() {
            ++SpiderPig.this.leapTick;
        }

        public void method_6270() {
            SpiderPig.this.leapTick = 0;
        }
    }

    static class WebPos
    extends class_2338 {
        private int timeLeft;

        public WebPos(class_2338 pos, int timeLeft) {
            super((class_2382)pos);
            this.timeLeft = timeLeft;
        }
    }
}

