/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.puzzleslib.api.entity.v1.AdditionalAddEntityData;
import java.util.OptionalInt;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ThrowableBlock
extends class_1682
implements AdditionalAddEntityData {
    private static final class_2940<OptionalInt> OWNER_ENTITY_ID = class_2945.method_12791(ThrowableBlock.class, (class_2941)class_2943.field_17910);
    private static final class_2940<Boolean> HELD = class_2945.method_12791(ThrowableBlock.class, (class_2941)class_2943.field_13323);
    private class_2680 blockState = class_2246.field_10219.method_9564();
    @Nullable
    private class_1299<?> ownerType;

    public ThrowableBlock(class_1299<? extends ThrowableBlock> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public ThrowableBlock(double x, double y, double z, class_1309 livingEntityIn) {
        super((class_1299)ModRegistry.THROWABLE_BLOCK_ENTITY_TYPE.get(), x, y, z, livingEntityIn.field_6002);
        this.method_7432((class_1297)livingEntityIn);
        this.ownerType = livingEntityIn.method_5864();
    }

    public ThrowableBlock(MutantEnderman enderman, int id) {
        this(enderman.method_23317(), enderman.method_23318() + 4.7, enderman.method_23321(), (class_1309)enderman);
        this.blockState = class_2248.method_9531((int)enderman.getHeldBlock(id));
        boolean outer = id <= 1;
        boolean right = (id & 1) == 0;
        class_1309 attackTarget = enderman.method_5968();
        class_243 forward = EntityUtil.getDirVector(this.method_36454(), outer ? 2.7f : 1.4f);
        class_243 strafe = EntityUtil.getDirVector(this.method_36454() + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.method_5814(this.method_23317() + forward.field_1352 + strafe.field_1352, this.method_23318() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.method_23321() + forward.field_1350 + strafe.field_1350);
        if (attackTarget != null) {
            double d0 = attackTarget.method_23317() - this.method_23317();
            double d1 = attackTarget.method_23323(0.33) - this.method_23318();
            double d2 = attackTarget.method_23321() - this.method_23321();
            double d3 = class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)));
            this.method_7485(d0, d1 + d3 * 0.1, d2, 1.4f, 1.0f);
        } else {
            this.throwBlock((class_1309)enderman);
        }
    }

    public ThrowableBlock(MutantSnowGolem mutantSnowGolem) {
        this(mutantSnowGolem.method_23317(), mutantSnowGolem.method_23318() + 1.955 - 0.1 + 1.0, mutantSnowGolem.method_23321(), (class_1309)mutantSnowGolem);
        this.method_36456(mutantSnowGolem.method_36454());
        this.blockState = class_2246.field_10295.method_9564();
    }

    public ThrowableBlock(class_1657 player, class_2680 blockState, class_2338 pos) {
        this((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, (class_1309)player);
        this.blockState = blockState;
        this.setHeld(true);
    }

    protected void method_5693() {
        this.field_6011.method_12784(OWNER_ENTITY_ID, (Object)OptionalInt.empty());
        this.field_6011.method_12784(HELD, (Object)false);
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Nullable
    public class_1299<?> getOwnerType() {
        return this.ownerType;
    }

    public boolean isHeld() {
        return (Boolean)this.field_6011.method_12789(HELD);
    }

    private void setHeld(boolean held) {
        this.field_6011.method_12778(HELD, (Object)held);
    }

    public void method_7432(class_1297 entityIn) {
        super.method_7432(entityIn);
        if (entityIn != null) {
            this.field_6011.method_12778(OWNER_ENTITY_ID, (Object)OptionalInt.of(entityIn.method_5628()));
        }
    }

    protected float method_7490() {
        if (this.ownerType == class_1299.field_6097) {
            return 0.04f;
        }
        return this.ownerType == ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get() ? 0.06f : 0.01f;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_5863() {
        return this.method_5805() && this.ownerType != ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get();
    }

    public boolean method_5810() {
        return this.isHeld() && this.method_5805();
    }

    public void method_5697(class_1297 entityIn) {
        if (entityIn != this.method_24921()) {
            super.method_5697(entityIn);
        }
    }

    public void method_5711(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681();
                double y = this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682());
                double z = this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681();
                double motx = (this.field_5974.method_43057() - this.field_5974.method_43057()) * 3.0f;
                double moty = 0.5f + this.field_5974.method_43057() * 2.0f;
                double motz = (this.field_5974.method_43057() - this.field_5974.method_43057()) * 3.0f;
                this.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, this.blockState), x, y, z, motx, moty, motz);
            }
        }
    }

    public void method_5773() {
        if (this.isHeld()) {
            if (!this.field_6002.field_9236) {
                this.method_5729(6, this.method_36361());
            }
            this.method_5670();
            class_1297 thrower = this.method_24921();
            if (thrower == null) {
                class_1297 entity;
                OptionalInt optionalInt = (OptionalInt)this.field_6011.method_12789(OWNER_ENTITY_ID);
                if (optionalInt.isPresent() && (entity = this.field_6002.method_8469(optionalInt.getAsInt())) instanceof class_1309) {
                    thrower = entity;
                }
                if (thrower != null) {
                    this.method_7432(thrower);
                }
            } else if (thrower instanceof class_1309) {
                class_243 vec = thrower.method_5720();
                double x = thrower.method_23317() + vec.field_1352 * 1.6 - this.method_23317();
                double y = thrower.method_23320() + vec.field_1351 * 1.6 - this.method_23318();
                double z = thrower.method_23321() + vec.field_1350 * 1.6 - this.method_23321();
                float offset = 0.6f;
                this.method_18800(x * (double)offset, y * (double)offset, z * (double)offset);
                this.method_5784(class_1313.field_6308, this.method_18798());
                if (!(this.field_6002.field_9236 || thrower.method_5805() && !thrower.method_7325() && ((class_1309)thrower).method_24518((class_1792)ModRegistry.ENDERSOUL_HAND_ITEM.get()))) {
                    this.setHeld(false);
                }
            }
        } else {
            super.method_5773();
            this.field_6007 = true;
        }
    }

    protected boolean method_26958(class_1297 entity) {
        if (!super.method_26958(entity)) {
            return false;
        }
        return this.ownerType != ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get() || MutantSnowGolem.canHarm(this.method_24921(), entity);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (itemStack.method_7909() != ModRegistry.ENDERSOUL_HAND_ITEM.get()) {
            return class_1269.field_5811;
        }
        if (this.isHeld()) {
            if (this.method_24921() == player) {
                if (!this.field_6002.field_9236) {
                    this.setHeld(false);
                    this.throwBlock((class_1309)player);
                }
                itemStack.method_7956(1, (class_1309)player, e -> e.method_20236(hand));
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            return class_1269.field_5811;
        }
        if (!this.field_6002.field_9236) {
            this.setHeld(true);
            this.method_7432((class_1297)player);
        }
        return class_1269.method_29236((boolean)this.field_6002.field_9236);
    }

    private void throwBlock(class_1309 thrower) {
        this.method_36456(thrower.method_36454());
        this.method_36457(thrower.method_36455());
        float f = 0.4f;
        this.method_7485(-class_3532.method_15374((float)(this.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(this.method_36455() / 180.0f * (float)Math.PI)) * f, -class_3532.method_15374((float)(this.method_36455() / 180.0f * (float)Math.PI)) * f, class_3532.method_15362((float)(this.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(this.method_36455() / 180.0f * (float)Math.PI)) * f, 1.4f, 1.0f);
    }

    protected void method_7488(class_239 result) {
        class_1309 livingEntity;
        class_1297 thrower = this.method_24921();
        class_1309 class_13092 = livingEntity = thrower instanceof class_1309 ? (class_1309)thrower : null;
        if (this.ownerType == ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get()) {
            class_1297 entity;
            for (class_1308 mobEntity : this.field_6002.method_8390(class_1308.class, this.method_5829().method_1009(2.5, 2.0, 2.5), this::method_26958)) {
                if (!(this.method_5858((class_1297)mobEntity) <= 6.25)) continue;
                mobEntity.method_5643(this.field_6002.method_48963().method_48800((class_1297)this, livingEntity), 4.0f + (float)this.field_5974.method_43048(3));
            }
            if (result.method_17783() == class_239.class_240.field_1331 && (entity = ((class_3966)result).method_17782()).method_5643(this.field_6002.method_48963().method_48811((class_1297)this, (class_1297)livingEntity), 4.0f) && entity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (!this.field_6002.field_9236) {
                this.field_6002.method_8421((class_1297)this, (byte)3);
                this.method_31472();
            }
            this.method_5783(this.blockState.method_26231().method_10595(), 0.8f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.8f);
        } else {
            boolean canOwnerPlace;
            boolean bl = canOwnerPlace = livingEntity instanceof class_1657 && ((class_1657)livingEntity).method_7294() || livingEntity instanceof class_1308 && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.field_6002, (class_1297)livingEntity);
            if (result.method_17783() == class_239.class_240.field_1332) {
                class_3965 blockRayTraceResult = (class_3965)result;
                this.method_24920(blockRayTraceResult);
                if (!this.field_6002.field_9236) {
                    if (canOwnerPlace && this.blockState.method_26184((class_4538)this.field_6002, this.method_24515())) {
                        this.field_6002.method_8501(this.method_24515(), this.blockState);
                        this.blockState.method_26204().method_9567(this.field_6002, this.method_24515(), this.blockState, livingEntity, class_1799.field_8037);
                        class_2498 soundType = this.blockState.method_26231();
                        this.method_5783(soundType.method_10598(), (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
                    } else {
                        this.field_6002.method_20290(2001, this.method_24515(), class_2248.method_9507((class_2680)this.blockState));
                        if (canOwnerPlace && this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                            this.method_5706((class_1935)this.blockState.method_26204());
                        }
                    }
                }
            } else if (result.method_17783() == class_239.class_240.field_1331 && !this.field_6002.field_9236) {
                class_1297 entity = ((class_3966)result).method_17782();
                if (entity.method_5643(this.field_6002.method_48963().method_48811((class_1297)this, (class_1297)livingEntity), 4.0f) && entity.method_5864() == class_1299.field_6091) {
                    return;
                }
                this.field_6002.method_20290(2001, this.method_24515(), class_2248.method_9507((class_2680)this.blockState));
                if (canOwnerPlace && this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                    this.method_5706((class_1935)this.blockState.method_26204());
                }
            }
            for (class_1297 entity : this.field_6002.method_8333((class_1297)this, this.method_5829().method_1014(2.0), this::method_26958)) {
                if (entity.method_5779((class_1297)livingEntity) || !(this.method_5858(entity) <= 4.0)) continue;
                entity.method_5643(this.field_6002.method_48963().method_48800((class_1297)this, livingEntity), (float)(6 + this.field_5974.method_43048(3)));
            }
            if (!this.field_6002.field_9236) {
                this.method_31472();
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        compound.method_10556("Held", this.isHeld());
        if (this.ownerType != null) {
            compound.method_10582("OwnerType", class_7923.field_41177.method_10221(this.ownerType).toString());
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setHeld(compound.method_10577("Held"));
        if (compound.method_10573("BlockState", 10)) {
            this.blockState = class_2512.method_10681((class_7871)this.field_6002.method_45448(class_7924.field_41254), (class_2487)compound.method_10562("BlockState"));
        }
        if (compound.method_10545("OwnerType")) {
            this.ownerType = class_1299.method_5898((String)compound.method_10558("OwnerType")).orElse(null);
        }
    }

    public void writeAdditionalAddEntityData(class_2540 buffer) {
        buffer.method_10804(class_2248.method_9507((class_2680)this.blockState));
        buffer.method_10814(this.ownerType == null ? "" : class_7923.field_41177.method_10221(this.ownerType).toString());
    }

    public void readAdditionalAddEntityData(class_2540 additionalData) {
        this.blockState = class_2248.method_9531((int)additionalData.method_10816());
        this.ownerType = class_1299.method_5898((String)additionalData.method_10800(Short.MAX_VALUE)).orElse(null);
    }

    public class_2596<class_2602> method_18002() {
        return AdditionalAddEntityData.getPacket((class_1297)this);
    }
}

