/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CreeperMinionTrackerScreen
extends Screen {
    private static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/gui/creeper_minion_tracker.png");
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private EditBox name;
    private final CreeperMinion creeperMinion;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;
    private int titleLabelX;
    private int titleLabelY;

    public CreeperMinionTrackerScreen(CreeperMinion creeperMinion) {
        super(creeperMinion.m_6095_().m_20676_());
        this.creeperMinion = creeperMinion;
    }

    protected void m_7856_() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.m_20151_();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.name = new EditBox(this.f_96547_, this.leftPos + 5, this.topPos - 24, this.imageHeight, 20, (Component)Component.m_237119_());
        this.name.m_94202_(-1);
        this.name.m_94205_(-1);
        this.name.m_94199_(50);
        this.name.m_94151_(this::onNameChanged);
        this.name.m_94144_(this.creeperMinion.m_7755_().getString());
        this.m_7787_((GuiEventListener)this.name);
        int buttonWidth = this.imageWidth / 2 - 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.canDestroyBlocks(), button -> {
            this.canDestroyBlocks = !this.canDestroyBlocks;
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionTrackerMessage(this.creeperMinion, 0, this.canDestroyBlocks));
            button.m_93666_(this.canDestroyBlocks());
        }).m_252987_(this.leftPos + 8, this.topPos + this.imageHeight - 78, buttonWidth * 2 + 4, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.alwaysShowName(), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionTrackerMessage(this.creeperMinion, 1, this.alwaysShowName));
            button.m_93666_(this.alwaysShowName());
        }).m_252987_(this.leftPos + 8, this.topPos + this.imageHeight - 54, buttonWidth * 2 + 4, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.canRideOnShoulder(), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionTrackerMessage(this.creeperMinion, 2, this.canRideOnShoulder));
            button.m_93666_(this.canRideOnShoulder());
        }).m_252987_(this.leftPos + 8, this.topPos + this.imageHeight - 30, buttonWidth * 2 + 4, 20).m_253136_());
        if (!this.creeperMinion.m_21830_((LivingEntity)this.f_96541_.f_91074_)) {
            this.f_169369_.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(widget -> {
                widget.f_93623_ = false;
            });
        }
        this.titleLabelX = (this.imageWidth - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.titleLabelY = 6;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.name.m_7933_(keyCode, scanCode, modifiers) || this.name.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        if (!this.creeperMinion.m_6084_()) {
            this.f_96541_.f_91074_.m_6915_();
        }
        this.name.m_94120_();
    }

    private void onNameChanged(String input) {
        if (!(input = input.trim()).equals(this.creeperMinion.m_7755_().getString())) {
            this.creeperMinion.m_6593_((Component)Component.m_237113_((String)input));
            MutantMonsters.NETWORK.sendToServer((MessageV2)new C2SCreeperMinionNameMessage((Entity)this.creeperMinion, input));
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String string = this.name.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.name.m_94144_(string);
    }

    private Component alwaysShowName() {
        return CreeperMinionTrackerScreen.onOffComponent("show_name", this.alwaysShowName);
    }

    private Component canDestroyBlocks() {
        return CreeperMinionTrackerScreen.onOffComponent("destroys_blocks", this.canDestroyBlocks);
    }

    private Component canRideOnShoulder() {
        return CreeperMinionTrackerScreen.onOffComponent("ride_on_shoulder", this.canRideOnShoulder);
    }

    private static Component onOffComponent(String translationKey, boolean on) {
        return Component.m_237115_((String)("gui.mutantmonsters.creeper_minion_tracker." + translationKey)).m_130946_(": ").m_7220_(on ? CommonComponents.f_130653_ : CommonComponents.f_130654_);
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        CreeperMinionTrackerScreen.m_93228_((PoseStack)matrixStack, (int)this.leftPos, (int)this.topPos, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight);
        int health = (int)(this.creeperMinion.m_21223_() * 150.0f / this.creeperMinion.m_21233_());
        CreeperMinionTrackerScreen.m_93228_((PoseStack)matrixStack, (int)(this.leftPos + 13), (int)(this.topPos + 16), (int)0, (int)this.imageHeight, (int)health, (int)6);
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)(this.leftPos + this.titleLabelX), (float)(this.topPos + this.titleLabelY), 0x404040);
        this.name.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.health"), (float)(this.leftPos + 13), (float)(this.topPos + 28), 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.explosion"), (float)(this.leftPos + 13), (float)(this.topPos + 48), 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.blast_radius"), (float)(this.leftPos + 13), (float)(this.topPos + 68), 0x404040);
        StringBuilder sb = new StringBuilder();
        sb.append(this.creeperMinion.m_21223_() / 2.0f).append(" / ").append(this.creeperMinion.m_21233_() / 2.0f);
        CreeperMinionTrackerScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)sb.toString(), (int)(this.leftPos + this.imageWidth / 2 + 38), (int)(this.topPos + 30), (int)0xFFFFFF);
        CreeperMinionTrackerScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)(this.creeperMinion.canExplodeContinuously() ? Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.explosion.continuous") : Component.m_237115_((String)"gui.mutantmonsters.creeper_minion_tracker.explosion.one_time")), (int)(this.leftPos + this.imageWidth / 2 + 38), (int)(this.topPos + 50), (int)0xFFFFFF);
        int temp = (int)(this.creeperMinion.getExplosionRadius() * 10.0f);
        sb = new StringBuilder().append((float)temp / 10.0f);
        CreeperMinionTrackerScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)sb.toString(), (int)(this.leftPos + this.imageWidth / 2 + 38), (int)(this.topPos + 70), (int)0xFFFFFF);
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }
}

