/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.item.ArmorBlockItem;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import java.util.Collection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityEventsHandler {
    public static EventResult onEntityJoinServerLevel(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob creature = (PathfinderMob)entity;
            if (EntityUtil.isFeline((LivingEntity)creature)) {
                creature.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal(creature, MutantCreeper.class, 16.0f, 1.33, 1.33));
            }
            if (creature.m_6095_() == EntityType.f_20510_) {
                creature.f_21345_.m_25352_(2, (Goal)new TemptGoal(creature, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_}), false));
            }
            if (creature.m_6095_() == EntityType.f_20492_) {
                creature.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.8, 0.8));
            }
            if (creature.m_6095_() == EntityType.f_20494_) {
                creature.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.5, 0.5));
            }
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        ItemStack stackInHand;
        Pig pig;
        if (entity instanceof Pig && !(pig = (Pig)entity).m_21023_(MobEffects.f_19590_) && (stackInHand = player.m_21120_(hand)).m_41720_() == Items.f_42592_) {
            if (!player.m_7500_()) {
                stackInHand.m_41774_(1);
            }
            pig.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 600, 13));
            return EventResultHolder.interrupt((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return EventResultHolder.pass();
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        float damage;
        if (entity instanceof Player && entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorBlockItem && !((damage = amount.getAsFloat()) <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack itemstack = entity.m_6844_(EquipmentSlot.HEAD);
            if (!source.m_269533_(DamageTypeTags.f_268745_) || !itemstack.m_41720_().m_41475_()) {
                itemstack.m_41622_((int)damage, entity, livingEntity -> livingEntity.m_21166_(EquipmentSlot.HEAD));
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingDrops(LivingEntity entity, DamageSource source, Collection<ItemEntity> drops, int lootingLevel, boolean recentlyHit) {
        ItemStack itemStack;
        Entity trueSource = source.m_7639_();
        if (SpiderPig.isPigOrSpider(entity) && trueSource instanceof SpiderPig) {
            return EventResult.INTERRUPT;
        }
        if ((trueSource instanceof MutantCreeper && ((MutantCreeper)trueSource).isCharged() || trueSource instanceof CreeperMinion && ((CreeperMinion)trueSource).isCharged()) && source.m_269533_(DamageTypeTags.f_268415_) && !(itemStack = EntityUtil.getSkullDrop(entity.m_6095_())).m_41619_()) {
            drops.add(new ItemEntity(trueSource.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemStack));
        }
        return EventResult.PASS;
    }
}

