/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CreeperShardItem
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public CreeperShardItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.5, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || stack.m_41773_() == 0;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player = (Player)attacker;
        int damage = stack.m_41773_();
        if (damage > 0) {
            stack.m_41721_(damage - 1);
            if (!player.m_7500_() && player.m_217043_().m_188503_(4) == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80 + player.m_217043_().m_188503_(40)));
            }
        }
        target.m_147240_((double)0.9f, player.m_20185_() - target.m_20185_(), player.m_20189_() - target.m_20189_());
        player.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.3f, 0.8f + player.m_217043_().m_188501_() * 0.4f);
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        int maxDmg = stack.m_41776_();
        int dmg = stack.m_41773_();
        if (!worldIn.f_46443_) {
            float damage = 5.0f * (float)(maxDmg - dmg) / 32.0f;
            if (dmg == 0) {
                damage += 2.0f;
            }
            MutatedExplosion.create(worldIn, (Entity)playerIn, playerIn.m_20185_(), playerIn.m_20186_() + 1.0, playerIn.m_20189_(), damage, false, playerIn.m_36326_() ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
        }
        if (!playerIn.m_150110_().f_35937_) {
            stack.m_41721_(maxDmg);
        }
        playerIn.m_36335_().m_41524_((Item)this, (maxDmg - dmg) * 2);
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }

    public boolean m_41386_(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268415_);
    }
}

