/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.entity.SkullSpirit;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutatedExplosion
extends Explosion {
    private final Level world;
    private final float size;

    private MutatedExplosion(Level worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.BlockInteraction modeIn) {
        super(worldIn, exploderIn, null, null, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
        this.world = worldIn;
        this.size = sizeIn;
    }

    public void m_46061_() {
        if (!(this.size <= 0.0f)) {
            double z;
            double y;
            double x;
            int l;
            int k;
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            Entity exploder = CommonAbstractions.INSTANCE.getExplosionExploder(this);
            Vec3 position = CommonAbstractions.INSTANCE.getExplosionPosition(this);
            ExplosionDamageCalculator explosionContext = exploder == null ? new ExplosionDamageCalculator() : new EntityBasedExplosionDamageCalculator(exploder);
            for (int j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    for (l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        x = position.f_82479_;
                        y = position.f_82480_;
                        z = position.f_82481_;
                        float attenuation = 0.3f;
                        for (float intensity = this.size * (0.7f + this.world.f_46441_.m_188501_() * 0.6f); intensity > 0.0f; intensity -= 0.22500001f) {
                            BlockState blockstate;
                            BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                            Optional optional = explosionContext.m_6617_((Explosion)this, (BlockGetter)this.world, blockpos, blockstate = this.world.m_8055_(blockpos), Fluids.f_76191_.m_76145_());
                            if (optional.isPresent()) {
                                intensity -= (((Float)optional.get()).floatValue() + attenuation) * attenuation;
                            }
                            if (intensity > 0.0f && explosionContext.m_6714_((Explosion)this, (BlockGetter)this.world, blockpos, blockstate, intensity)) {
                                set.add(blockpos);
                            }
                            x += d0 * (double)attenuation;
                            y += d1 * (double)attenuation;
                            z += d2 * (double)attenuation;
                        }
                    }
                }
            }
            this.m_46081_().addAll(set);
            float diameter = this.size * 2.0f;
            k = Mth.m_14107_((double)(position.f_82479_ - (double)diameter - 1.0));
            l = Mth.m_14107_((double)(position.f_82479_ + (double)diameter + 1.0));
            int minY = Mth.m_14107_((double)(position.f_82480_ - (double)diameter - 1.0));
            int maxY = Mth.m_14107_((double)(position.f_82480_ + (double)diameter + 1.0));
            int minZ = Mth.m_14107_((double)(position.f_82481_ - (double)diameter - 1.0));
            int maxZ = Mth.m_14107_((double)(position.f_82481_ + (double)diameter + 1.0));
            List list = this.world.m_6249_(exploder, new AABB((double)k, (double)minY, (double)minZ, (double)l, (double)maxY, (double)maxZ), entityx -> {
                if (entityx.m_6128_()) {
                    return false;
                }
                if (exploder instanceof SkullSpirit) {
                    SkullSpirit skullSpirit = (SkullSpirit)exploder;
                    if (entityx == skullSpirit.getTarget()) {
                        return !skullSpirit.isAttached();
                    }
                    return !(entityx instanceof LivingEntity) || ChemicalXMobEffect.IS_APPLICABLE.test((LivingEntity)entityx);
                }
                return true;
            });
            CommonAbstractions.INSTANCE.onExplosionDetonate(this.world, this, list, diameter);
            Iterator var11 = list.iterator();
            while (true) {
                Player playerentity;
                double d0;
                if (!var11.hasNext()) {
                    return;
                }
                Entity entity = (Entity)var11.next();
                double distance = Mth.m_14116_((float)((float)entity.m_20238_(position))) / diameter;
                if (!(distance <= 1.0) || (d0 = (double)Mth.m_14116_((float)((float)((x = entity.m_20185_() - position.f_82479_) * x + (y = entity.m_20188_() - position.f_82480_) * y + (z = entity.m_20189_() - position.f_82481_) * z)))) == 0.0) continue;
                x /= d0;
                y /= d0;
                z /= d0;
                double impact = (1.0 - distance) * (double)MutatedExplosion.m_46064_((Vec3)position, (Entity)entity);
                float damage = (int)((impact * impact + impact) / 2.0 * 6.0 * (double)diameter + 1.0);
                if (!entity.m_6469_(this.m_46077_(), damage) && exploder instanceof MutantCreeper) {
                    MutantCreeper mutantCreeper = (MutantCreeper)exploder;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (((Player)entity).m_21254_()) {
                            if (mutantCreeper.isJumpAttacking()) {
                                EntityUtil.disableShield((LivingEntity)player, mutantCreeper.isCharged() ? 200 : 100);
                                entity.m_6469_(this.m_46077_(), damage * 0.5f);
                            } else {
                                player.m_21211_().m_41622_((int)damage * 2, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
                                entity.m_6469_(this.m_46077_(), damage * 0.5f);
                            }
                        }
                    }
                }
                double exposure = impact;
                if (entity instanceof LivingEntity) {
                    exposure = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)impact);
                }
                if (!(entity instanceof MutantCreeper)) {
                    entity.m_20256_(entity.m_20184_().m_82520_(x * exposure, y * exposure, z * exposure));
                }
                if (!(entity instanceof Player) || (playerentity = (Player)entity).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_) continue;
                this.m_46078_().put(playerentity, new Vec3(x * impact, y * impact, z * impact));
            }
        }
    }

    public static MutatedExplosion create(@NotNull Entity exploderIn, float sizeIn, boolean causesFireIn, Level.ExplosionInteraction interaction) {
        return MutatedExplosion.create(exploderIn.f_19853_, exploderIn, exploderIn.m_20185_(), exploderIn.m_20186_(), exploderIn.m_20189_(), sizeIn, causesFireIn, interaction);
    }

    public static MutatedExplosion create(Level worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Level.ExplosionInteraction interaction) {
        Explosion.BlockInteraction mode = MutatedExplosion.getExplosionInteraction(worldIn, exploderIn, interaction);
        MutatedExplosion explosion = new MutatedExplosion(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, mode);
        if (!CommonAbstractions.INSTANCE.onExplosionStart(worldIn, explosion) && worldIn instanceof ServerLevel) {
            explosion.m_46061_();
            explosion.m_46075_(false);
            if (mode == Explosion.BlockInteraction.KEEP) {
                explosion.m_46080_();
            }
            for (ServerPlayer serverplayerentity : ((ServerLevel)worldIn).m_6907_()) {
                if (!(serverplayerentity.m_20275_(xIn, yIn, zIn) < 4096.0)) continue;
                serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(xIn, yIn, zIn, sizeIn, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverplayerentity)));
            }
        }
        return explosion;
    }

    public static Explosion.BlockInteraction getExplosionInteraction(Level level, @Nullable Entity entity, Level.ExplosionInteraction interaction) {
        return switch (interaction) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> MutatedExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254629_);
            case Level.ExplosionInteraction.MOB -> {
                if (CommonAbstractions.INSTANCE.getMobGriefingEvent(level, entity)) {
                    yield MutatedExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254692_);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> MutatedExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254705_);
        };
    }

    private static Explosion.BlockInteraction getDestroyType(Level level, GameRules.Key<GameRules.BooleanValue> gameRule) {
        return level.m_46469_().m_46207_(gameRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }
}

