/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.CreeperMinionEgg;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class MutantCreeper
extends class_1588 {
    private static final class_2940<Byte> STATUS = class_2945.method_12791(MutantCreeper.class, (class_2941)class_2943.field_13319);
    public static final int MAX_CHARGE_TIME = 100;
    public static final int MAX_DEATH_TIME = 100;
    private int chargeTime;
    private int chargeHits;
    private int lastJumpTick;
    private int jumpTick;
    private boolean summonLightning;
    private class_1282 deathCause;

    public MutantCreeper(class_1299<? extends MutantCreeper> type, class_1937 worldIn) {
        super(type, worldIn);
        this.chargeHits = 3 + this.field_5974.method_43048(3);
        this.method_49477(1.0f);
        this.field_6194 = 30;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new JumpAttackGoal());
        this.field_6201.method_6277(1, (class_1352)new SpawnMinionsGoal());
        this.field_6201.method_6277(1, (class_1352)new ChargeAttackGoal());
        this.field_6201.method_6277(2, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.3));
        this.field_6201.method_6277(3, (class_1352)new AvoidDamageGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(200));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1429.class, 100, true, true, EntityUtil::isFeline));
    }

    public static class_5132.class_5133 registerAttributes() {
        return MutantCreeper.method_26918().method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23719, 0.26).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STATUS, (Object)0);
    }

    public boolean isCharged() {
        return ((Byte)this.field_6011.method_12789(STATUS) & 1) != 0;
    }

    private void setCharged(boolean charged) {
        byte b0 = (Byte)this.field_6011.method_12789(STATUS);
        this.field_6011.method_12778(STATUS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isJumpAttacking() {
        return ((Byte)this.field_6011.method_12789(STATUS) & 2) != 0;
    }

    private void setJumpAttacking(boolean jumping) {
        byte b0 = (Byte)this.field_6011.method_12789(STATUS);
        this.field_6011.method_12778(STATUS, (Object)(jumping ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public boolean isCharging() {
        return ((Byte)this.field_6011.method_12789(STATUS) & 4) != 0;
    }

    private void setCharging(boolean flag) {
        byte b0 = (Byte)this.field_6011.method_12789(STATUS);
        this.field_6011.method_12778(STATUS, (Object)(flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return 2.6f;
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new MutantGroundPathNavigation((class_1308)this, worldIn);
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public boolean method_5753() {
        return this.isCharged() || super.method_5753();
    }

    public boolean method_6121(class_1297 entityIn) {
        boolean flag = entityIn.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
        if (flag) {
            this.method_5723((class_1309)this, entityIn);
        }
        double x = entityIn.method_23317() - this.method_23317();
        double y = entityIn.method_23318() - this.method_23318();
        double z = entityIn.method_23321() - this.method_23321();
        double d = Math.sqrt(x * x + y * y + z * z);
        entityIn.method_5762(x / d * 0.5, y / d * (double)0.05f + (double)0.15f, z / d * 0.5);
        this.method_6104(class_1268.field_5808);
        return flag;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            float healAmount = amount / 2.0f;
            if (this.method_5805() && this.method_6032() < this.method_6063() && !(source.method_5529() instanceof MutantCreeper)) {
                this.method_6025(healAmount);
                EntityUtil.sendParticlePacket((class_1297)this, (class_2394)class_2398.field_11201, (int)(healAmount / 2.0f));
            }
            return false;
        }
        boolean takenDamage = super.method_5643(source, amount);
        if (this.isCharging()) {
            if (!source.method_48789(class_8103.field_42248) && source.method_5526() instanceof class_1309) {
                source.method_5526().method_5643(this.method_48923().method_48818((class_1297)this), 2.0f);
            }
            if (takenDamage && amount > 0.0f) {
                --this.chargeHits;
            }
        }
        return takenDamage;
    }

    public double method_18390(@Nullable class_1297 lookingEntity) {
        return !(lookingEntity instanceof class_1439) && !(lookingEntity instanceof class_5136) ? super.method_18390(lookingEntity) : 0.0;
    }

    public void method_5800(class_3218 serverWorld, class_1538 lightningBolt) {
        this.setCharged(true);
    }

    public int method_5945() {
        return 1;
    }

    protected void method_16827() {
    }

    public void method_5711(byte id) {
        if (id == 6) {
            for (int i = 0; i < 15; ++i) {
                double d0 = this.field_5974.method_43059() * 0.02;
                double d1 = this.field_5974.method_43059() * 0.02;
                double d2 = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
            }
        } else {
            super.method_5711(id);
        }
    }

    public void method_5773() {
        super.method_5773();
        this.lastJumpTick = this.jumpTick;
        if (this.isJumpAttacking()) {
            if (this.jumpTick == 0) {
                this.method_37908().method_43129(null, (class_1297)this, (class_3414)ModRegistry.ENTITY_MUTANT_CREEPER_PRIMED_SOUND_EVENT.get(), this.method_5634(), 2.0f, this.method_6017());
            }
            ++this.jumpTick;
            this.field_17046 = class_243.field_1353;
            if (!(this.method_37908().field_9236 || !this.method_24828() && this.method_36601().method_26227().method_15769())) {
                MutatedExplosion.create((class_1297)this, this.isCharged() ? 6.0f : 4.0f, false, class_1937.class_7867.field_40890);
                this.setJumpAttacking(false);
            }
        } else if (this.jumpTick > 0) {
            this.jumpTick = 0;
        }
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected void method_6060(class_1309 livingEntity) {
        livingEntity.field_6037 = true;
    }

    public float getOverlayColor(float partialTicks) {
        if (this.field_6213 > 0) {
            return (float)this.field_6213 / 100.0f;
        }
        if (this.isCharging()) {
            return this.field_6012 % 20 < 10 ? 0.6f : 0.0f;
        }
        return class_3532.method_16439((float)partialTicks, (float)this.lastJumpTick, (float)this.jumpTick) / 28.0f;
    }

    public void method_6078(class_1282 cause) {
        if (!this.method_37908().field_9236) {
            this.deathCause = cause;
            this.setCharging(false);
            this.method_37908().method_8421((class_1297)this, (byte)3);
            this.method_37908().method_43129(null, (class_1297)this, (class_3414)ModRegistry.ENTITY_MUTANT_CREEPER_DEATH_SOUND_EVENT.get(), this.method_5634(), 2.0f, 1.0f);
            if (this.field_6238 > 0) {
                this.field_6238 += 100;
            }
        }
    }

    protected void method_6108() {
        ++this.field_6213;
        this.method_49477(0.0f);
        float power = this.isCharged() ? 12.0f : 8.0f;
        float radius = power * 1.5f;
        for (class_1297 entity : this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014((double)radius), class_1301.field_6156)) {
            double x = this.method_23317() - entity.method_23317();
            double y = this.method_23318() - entity.method_23318();
            double z = this.method_23321() - entity.method_23321();
            double d = Math.sqrt(x * x + y * y + z * z);
            float scale = (float)this.field_6213 / 100.0f;
            entity.method_18799(entity.method_18798().method_1031(x / d * (double)scale * 0.09, y / d * (double)scale * 0.09, z / d * (double)scale * 0.09));
        }
        this.method_23327(this.method_23317() + (double)(this.field_5974.method_43057() * 0.2f) - (double)0.1f, this.method_23318(), this.method_23321() + (double)(this.field_5974.method_43057() * 0.2f) - (double)0.1f);
        if (this.field_6213 >= 100) {
            if (!this.method_37908().field_9236) {
                MutatedExplosion.create((class_1297)this, power, this.method_5809(), class_1937.class_7867.field_40890);
                super.method_6078(this.deathCause != null ? this.deathCause : this.method_48923().method_48830());
                if (this.method_37908().method_8450().method_8355(class_1928.field_19391) && this.field_6258 != null) {
                    this.method_37908().method_8649((class_1297)new CreeperMinionEgg(this, (class_1297)this.field_6258));
                }
            }
            this.method_31472();
        }
    }

    public float method_5774(class_1927 explosionIn, class_1922 worldIn, class_2338 pos, class_2680 blockStateIn, class_3610 fluidState, float resistance) {
        return this.isCharged() && blockStateIn.method_26214(worldIn, pos) > -1.0f ? Math.min(0.8f, resistance) : resistance;
    }

    public void method_5966() {
        if (this.method_5968() == null) {
            super.method_5966();
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_CREEPER_AMBIENT_SOUND_EVENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModRegistry.ENTITY_MUTANT_CREEPER_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_CREEPER_HURT_SOUND_EVENT.get();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("JumpAttacking", this.isJumpAttacking());
        compound.method_10556("Charging", this.isCharging());
        compound.method_10569("ChargeTime", this.chargeTime);
        compound.method_10569("ChargeHits", this.chargeHits);
        compound.method_10556("SummonLightning", this.summonLightning);
        if (this.isCharged()) {
            compound.method_10556("Powered", true);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setCharged(compound.method_10577("powered") || compound.method_10577("Powered"));
        this.setJumpAttacking(compound.method_10577("JumpAttacking"));
        this.setCharging(compound.method_10577("Charging"));
        this.chargeTime = compound.method_10550("ChargeTime");
        this.chargeHits = compound.method_10550("ChargeHits");
        this.summonLightning = compound.method_10577("SummonLightning");
    }

    class JumpAttackGoal
    extends class_1352 {
        JumpAttackGoal() {
        }

        public boolean method_6264() {
            return MutantCreeper.this.method_5968() != null && MutantCreeper.this.method_24828() && MutantCreeper.this.method_5858((class_1297)MutantCreeper.this.method_5968()) <= 1024.0 && !MutantCreeper.this.isJumpAttacking() && !MutantCreeper.this.isCharging() && MutantCreeper.this.field_5974.method_43057() * 100.0f < 0.9f;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            MutantCreeper.this.setJumpAttacking(true);
            MutantCreeper.this.method_18800((MutantCreeper.this.method_5968().method_23317() - MutantCreeper.this.method_23317()) * 0.2, 1.4 * (double)MutantCreeper.this.method_23313(), (MutantCreeper.this.method_5968().method_23321() - MutantCreeper.this.method_23321()) * 0.2);
        }
    }

    class SpawnMinionsGoal
    extends class_1352 {
        SpawnMinionsGoal() {
        }

        public boolean method_6264() {
            float chance = MutantCreeper.this.method_6150() && (MutantCreeper.this.method_6081() == null || !MutantCreeper.this.method_6081().method_48789(class_8103.field_42247)) ? 0.6f : 0.9f;
            return MutantCreeper.this.method_5968() != null && MutantCreeper.this.method_5858((class_1297)MutantCreeper.this.method_5968()) <= 1024.0 && !MutantCreeper.this.isCharging() && !MutantCreeper.this.isJumpAttacking() && MutantCreeper.this.field_5974.method_43057() * 100.0f < chance;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            for (int i = (int)Math.ceil((double)(MutantCreeper.this.method_6032() / MutantCreeper.this.method_6063()) * 4.0); i > 0; --i) {
                CreeperMinion minion = (CreeperMinion)((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get()).method_5883(MutantCreeper.this.method_37908());
                double x = MutantCreeper.this.method_23317() + (double)MutantCreeper.this.field_5974.method_43057() - (double)MutantCreeper.this.field_5974.method_43057();
                double y = MutantCreeper.this.method_23318() + (double)(MutantCreeper.this.field_5974.method_43057() * 0.5f);
                double z = MutantCreeper.this.method_23321() + (double)MutantCreeper.this.field_5974.method_43057() - (double)MutantCreeper.this.field_5974.method_43057();
                double xx = MutantCreeper.this.method_5968().method_23317() - MutantCreeper.this.method_23317();
                double yy = MutantCreeper.this.method_5968().method_23318() - MutantCreeper.this.method_23318();
                double zz = MutantCreeper.this.method_5968().method_23321() - MutantCreeper.this.method_23321();
                minion.method_18800(xx * (double)0.15f + (double)(MutantCreeper.this.field_5974.method_43057() * 0.05f), yy * (double)0.15f + (double)(MutantCreeper.this.field_5974.method_43057() * 0.05f), zz * (double)0.15f + (double)(MutantCreeper.this.field_5974.method_43057() * 0.05f));
                minion.method_5814(x, y, z);
                minion.method_5980(MutantCreeper.this.method_5968());
                minion.method_6174(MutantCreeper.this.field_6021);
                if (MutantCreeper.this.isCharged()) {
                    minion.setCharged(true);
                }
                MutantCreeper.this.method_37908().method_8649((class_1297)minion);
            }
        }
    }

    class ChargeAttackGoal
    extends class_1352 {
        public ChargeAttackGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 target = MutantCreeper.this.method_5968();
            return target != null && !MutantCreeper.this.isJumpAttacking() && !(MutantCreeper.this.method_6063() - MutantCreeper.this.method_6032() < MutantCreeper.this.method_6063() / 6.0f) && MutantCreeper.this.method_5858((class_1297)target) >= 25.0 && MutantCreeper.this.method_5858((class_1297)target) <= 1024.0 && MutantCreeper.this.field_5974.method_43057() * 100.0f < 0.7f || MutantCreeper.this.isCharging();
        }

        public boolean method_6266() {
            if (MutantCreeper.this.summonLightning && MutantCreeper.this.method_5968() != null && MutantCreeper.this.method_5858((class_1297)MutantCreeper.this.method_5968()) < 25.0) {
                return false;
            }
            return MutantCreeper.this.chargeTime < 100 && MutantCreeper.this.chargeHits > 0;
        }

        public void method_6269() {
            MutantCreeper.this.setCharging(true);
            if (MutantCreeper.this.field_5974.method_43048(MutantCreeper.this.method_37908().method_8546() ? 2 : 6) == 0 && !MutantCreeper.this.isCharged()) {
                MutantCreeper.this.summonLightning = true;
            }
        }

        public void method_6268() {
            MutantCreeper.this.method_5942().method_6340();
            int i = MutantCreeper.this.chargeTime % 20;
            if (i == 0) {
                MutantCreeper.this.method_5783((class_3414)ModRegistry.ENTITY_MUTANT_CREEPER_CHARGE_SOUND_EVENT.get(), 0.6f, 0.7f + MutantCreeper.this.field_5974.method_43057() * 0.6f);
            }
            ++MutantCreeper.this.chargeTime;
        }

        public void method_6270() {
            if (MutantCreeper.this.summonLightning && MutantCreeper.this.method_5968() != null && MutantCreeper.this.method_5858((class_1297)MutantCreeper.this.method_5968()) < 25.0 && MutantCreeper.this.method_37908().method_8311(MutantCreeper.this.method_24515())) {
                class_1538 lightningBoltEntity = (class_1538)class_1299.field_6112.method_5883(MutantCreeper.this.method_37908());
                lightningBoltEntity.method_24203(MutantCreeper.this.method_23317(), MutantCreeper.this.method_23318(), MutantCreeper.this.method_23321());
                MutantCreeper.this.method_37908().method_8649((class_1297)lightningBoltEntity);
            } else if (MutantCreeper.this.chargeTime >= 100) {
                MutantCreeper.this.method_6025(30.0f);
                MutantCreeper.this.method_37908().method_8421((class_1297)MutantCreeper.this, (byte)6);
            }
            MutantCreeper.this.chargeTime = 0;
            MutantCreeper.this.chargeHits = 4 + MutantCreeper.this.field_5974.method_43048(3);
            MutantCreeper.this.setCharging(false);
            MutantCreeper.this.summonLightning = false;
        }
    }
}

