/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EndersoulHandItem
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public EndersoulHandItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (context.m_7078_()) {
            return InteractionResult.PASS;
        }
        if (!MutantEnderman.canBlockBeHeld(level, pos, blockState, ModRegistry.ENDERSOUL_HAND_HOLDABLE_IMMUNE_BLOCK_TAG)) {
            return InteractionResult.PASS;
        }
        if (!level.m_7966_(player, pos)) {
            return InteractionResult.PASS;
        }
        if (!player.m_36204_(pos, context.m_43719_(), itemStack)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            level.m_7967_((Entity)new ThrowableBlock(player, blockState, pos));
            level.m_7471_(pos, false);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!playerIn.m_36341_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        HitResult result = playerIn.m_19907_(128.0, 1.0f, false);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            playerIn.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".teleport_failed")), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.f_46443_) {
            BlockPos startPos = ((BlockHitResult)result).m_82425_();
            BlockPos endPos = startPos.m_121945_(((BlockHitResult)result).m_82434_());
            BlockPos posDown = startPos.m_7495_();
            if (!level.m_46859_(posDown) || !level.m_8055_(posDown).m_280555_()) {
                for (int tries = 0; tries < 3; ++tries) {
                    BlockPos checkPos = startPos.m_6630_(tries + 1);
                    if (!level.m_46859_(checkPos)) continue;
                    endPos = checkPos;
                    break;
                }
            }
            level.m_6263_(null, playerIn.f_19854_, playerIn.f_19855_, playerIn.f_19856_, SoundEvents.f_11757_, playerIn.m_5720_(), 1.0f, 1.0f);
            playerIn.m_6021_((double)endPos.m_123341_() + 0.5, (double)endPos.m_123342_(), (double)endPos.m_123343_() + 0.5);
            level.m_5594_(null, endPos, SoundEvents.f_11757_, playerIn.m_5720_(), 1.0f, 1.0f);
            MutantEnderman.teleportAttack((LivingEntity)playerIn);
            EntityUtil.sendParticlePacket((Entity)playerIn, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), 256);
            playerIn.m_36335_().m_41524_((Item)this, 40);
            stack.m_41622_(4, (LivingEntity)playerIn, e -> e.m_21190_(handIn));
        }
        playerIn.f_19789_ = 0.0f;
        playerIn.m_6674_(handIn);
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }
}

