/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.FleeRainGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1427;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4291;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_6908;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class MutantSnowGolem
extends class_1427
implements class_1603,
class_5147 {
    private static final class_2940<Optional<UUID>> OWNER_UNIQUE_ID = class_2945.method_12791(MutantSnowGolem.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Byte> STATUS = class_2945.method_12791(MutantSnowGolem.class, (class_2941)class_2943.field_13319);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolem(class_1299<? extends MutantSnowGolem> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_5941(class_7.field_18, -1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SwimJumpGoal(this));
        this.field_6201.method_6277(1, (class_1352)new FleeRainGoal((class_1314)this, 1.1));
        this.field_6201.method_6277(2, (class_1352)new class_1381((class_1603)this, 1.1, 30, 12.0f));
        this.field_6201.method_6277(3, (class_1352)new ThrowIceGoal());
        this.field_6201.method_6277(4, (class_1352)new AvoidDamageGoal((class_1314)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1370((class_1314)this, 1.1));
        this.field_6201.method_6277(6, (class_1352)new class_4291((class_1314)this, 1.0, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 1.0000001E-5f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1308.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1308.class, 10, true, false, entity -> entity instanceof class_1569 && (!(entity instanceof class_1548) || ((class_1548)entity).method_5968() == this)));
    }

    public static class_5132.class_5133 registerAttributes() {
        return MutantSnowGolem.method_26828().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.26);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OWNER_UNIQUE_ID, Optional.empty());
        this.field_6011.method_12784(STATUS, (Object)1);
    }

    @Nullable
    public class_1657 getOwner() {
        return this.getOwnerId().map(arg_0 -> ((class_1937)this.method_37908()).method_18470(arg_0)).orElse(null);
    }

    public Optional<UUID> getOwnerId() {
        return (Optional)this.field_6011.method_12789(OWNER_UNIQUE_ID);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean hasJackOLantern() {
        return ((Byte)this.field_6011.method_12789(STATUS) & 1) != 0;
    }

    public void setJackOLantern(boolean jackOLantern) {
        byte b0 = (Byte)this.field_6011.method_12789(STATUS);
        this.field_6011.method_12778(STATUS, (Object)(jackOLantern ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.field_6011.method_12789(STATUS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJumping) {
        byte b0 = (Byte)this.field_6011.method_12789(STATUS);
        this.field_6011.method_12778(STATUS, (Object)(swimJumping ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new MutantGroundPathNavigation((class_1308)this, worldIn);
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return 2.0f;
    }

    public boolean method_18395(class_1309 target) {
        return super.method_18395(target) && target instanceof class_1569;
    }

    public float method_6144(class_2338 pos, class_4538 worldIn) {
        if (worldIn.method_23753(pos).method_40220(class_6908.field_41753)) {
            return -10.0f;
        }
        return worldIn.method_8320(pos).method_26204() == class_2246.field_10477 ? 10.0f : 0.0f;
    }

    public void method_5773() {
        int x;
        super.method_5773();
        if (this.method_37908().field_9236 && this.getSwimJump()) {
            for (x = 0; x < 6; ++x) {
                double d0 = this.field_5974.method_43059() * 0.02;
                double d1 = this.field_5974.method_43059() * 0.02;
                double d2 = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10477.method_9564()), this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                d0 = this.field_5974.method_43059() * 0.02;
                d1 = this.field_5974.method_43059() * 0.02;
                d2 = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
            }
        }
        if (this.isThrowing) {
            ++this.throwingTick;
            if (this.throwingTick >= 20) {
                this.isThrowing = false;
                this.throwingTick = 0;
            }
        }
        if (this.method_37908().method_8597().comp_644() || this.method_37908().method_23753(this.method_24515()).method_40220(class_6908.field_41753)) {
            if (this.field_5974.method_43057() > Math.min(80.0f, this.method_6032()) * 0.01f) {
                this.method_37908().method_8406((class_2394)class_2398.field_18306, this.method_23322(0.6), this.method_23319() - 0.15, this.method_23325(0.6), 0.0, 0.0, 0.0);
            }
            if (this.field_6012 % 60 == 0) {
                this.method_5643(this.method_37908().method_48963().method_48813(), 1.0f);
            }
        }
        if (this.field_6012 % 80 == 0 && this.method_5805() && this.method_6032() < this.method_6063() && this.isSnowingAt(this.method_24515())) {
            this.method_6025(1.0f);
        }
        if (!this.method_37908().field_9236 && this.method_24828() && !this.method_37908().method_8597().comp_644() && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.method_37908(), (class_1297)this)) {
            x = class_3532.method_15357((double)this.method_23317());
            int y = class_3532.method_15357((double)this.method_5829().field_1322);
            int z = class_3532.method_15357((double)this.method_23321());
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    boolean placeIce;
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    class_2338 pos = new class_2338(x + i, y, z + j);
                    class_2338 posDown = pos.method_10074();
                    class_2338 posAbove = pos.method_10084();
                    boolean placeSnow = this.method_37908().method_22347(pos) && class_2246.field_10477.method_9564().method_26184((class_4538)this.method_37908(), pos);
                    boolean bl = placeIce = this.method_37908().method_22351(posDown) && this.method_37908().method_8320(posDown).method_26204() instanceof class_2404;
                    if (this.method_37908().method_8316(pos).method_15772() == class_3612.field_15909) {
                        this.method_37908().method_8501(pos, class_2246.field_10295.method_9564());
                    }
                    if (this.method_37908().method_8316(posAbove).method_15772() == class_3612.field_15909) {
                        this.method_37908().method_8501(posAbove, class_2246.field_10295.method_9564());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_5974.method_43048(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_5974.method_43048(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_5974.method_43048(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_5974.method_43048(6) != 0)) continue;
                    if (placeSnow) {
                        this.method_37908().method_8501(pos, class_2246.field_10477.method_9564());
                    }
                    if (!placeIce) continue;
                    this.method_37908().method_8501(posDown, class_2246.field_10295.method_9564());
                }
            }
        }
    }

    private boolean isSnowingAt(class_2338 position) {
        if (!this.method_37908().method_8419()) {
            return false;
        }
        if (!this.method_37908().method_8311(position)) {
            return false;
        }
        if (this.method_37908().method_8598(class_2902.class_2903.field_13197, position).method_10264() > position.method_10264()) {
            return false;
        }
        return ((class_1959)this.method_37908().method_23753(position).comp_349()).method_48162(position) == class_1959.class_1963.field_9383;
    }

    public boolean method_29503() {
        return true;
    }

    public boolean method_27072() {
        return this.method_5805() && this.hasJackOLantern();
    }

    public void method_6636(class_3419 source) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_22273, source, 1.0f, 1.0f);
        if (!this.method_37908().method_8608()) {
            this.setJackOLantern(false);
            this.method_5699(new class_1799((class_1935)class_1802.field_8693), 1.7f);
        }
    }

    protected void method_5958() {
        if (!this.method_5934()) {
            class_1657 owner = this.getOwner();
            if (owner != null && owner.method_5805()) {
                this.method_18408(owner.method_24515(), this.method_5968() == null ? 8 : 16);
            } else if (this.method_18410()) {
                this.method_18408(class_2338.field_10980, -1);
            }
        }
    }

    public boolean isThrowing() {
        return this.isThrowing;
    }

    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
        this.throwingTick = 0;
        this.method_37908().method_8421((class_1297)this, (byte)(isThrowing ? 1 : 0));
    }

    public void method_5711(byte id) {
        if (id != 0 && id != 1) {
            super.method_5711(id);
            if (id == 2 || id == 33 || id == 36 || id == 37 || id == 44) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10477.method_9564()), this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else {
            this.isThrowing = id == 1;
            this.throwingTick = 0;
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_5526() instanceof class_1680) {
            if (this.method_5805() && this.method_6032() < this.method_6063()) {
                this.method_6025(1.0f);
                double d0 = this.field_5974.method_43059() * 0.02;
                double d1 = this.field_5974.method_43059() * 0.02;
                double d2 = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d0, d1, d2);
            }
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        if (!this.isThrowing) {
            this.setThrowing(true);
        }
    }

    public static boolean canHarm(class_1297 attacker, class_1297 target) {
        if (!(attacker instanceof MutantSnowGolem)) {
            return true;
        }
        if (target instanceof CreeperMinion) {
            return !((CreeperMinion)target).method_6181();
        }
        return target instanceof class_1569 || target instanceof class_1308 && ((class_1308)target).method_5968() == attacker || ((MutantSnowGolem)attacker).method_5968() == target;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1269 actionresulttype = itemStack.method_7920(player, (class_1309)this, hand);
        if (actionresulttype.method_23665()) {
            return actionresulttype;
        }
        if (!(this.getOwnerId().isPresent() && player != this.getOwner() || itemStack.method_7909() == class_1802.field_8543)) {
            if (!this.method_37908().field_9236) {
                this.setOwnerId(!this.getOwnerId().isPresent() ? player.method_5667() : null);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.9f * this.method_5751()), (double)this.method_17681() * (double)0.2f);
    }

    public void method_6078(class_1282 cause) {
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
            this.getOwner().method_43496(this.method_6066().method_5548());
        }
        super.method_6078(cause);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("JackOLantern", this.hasJackOLantern());
        this.getOwnerId().ifPresent(uuid -> compound.method_25927("Owner", uuid));
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Pumpkin") || compound.method_10545("JackOLantern")) {
            this.setJackOLantern(compound.method_10577("Pumpkin") || compound.method_10577("JackOLantern"));
        }
        if (compound.method_25928("OwnerUUID")) {
            this.setOwnerId(compound.method_25926("OwnerUUID"));
        } else if (compound.method_25928("Owner")) {
            this.setOwnerId(compound.method_25926("Owner"));
        }
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModRegistry.ENTITY_MUTANT_SNOW_GOLEM_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.ENTITY_MUTANT_SNOW_GOLEM_DEATH_SOUND_EVENT.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        this.method_5783(class_3417.field_15060, 0.15f, 1.0f);
    }

    static class SwimJumpGoal
    extends class_1352 {
        private final MutantSnowGolem golem;
        private int jumpTick = 20;
        private boolean waterReplaced;
        private class_2338.class_2339 prevPos;

        public SwimJumpGoal(MutantSnowGolem golem) {
            this.golem = golem;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407));
            golem.field_6189.method_6354(true);
        }

        public boolean method_6264() {
            return this.golem.method_5799();
        }

        public void method_6269() {
            this.prevPos = new class_2338.class_2339(this.golem.method_23317(), this.golem.method_5829().field_1322 - 1.0, this.golem.method_23321());
            this.golem.method_18800((this.golem.field_5974.method_43057() - this.golem.field_5974.method_43057()) * 0.9f, 1.5, (this.golem.field_5974.method_43057() - this.golem.field_5974.method_43057()) * 0.9f);
            this.golem.method_5643(this.golem.method_37908().method_48963().method_48824(), 16.0f);
            this.golem.setSwimJump(true);
        }

        public boolean method_6266() {
            return this.jumpTick > 0;
        }

        public void method_6268() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.method_5799() && this.jumpTick < 17 && CommonAbstractions.INSTANCE.getMobGriefingEvent(this.golem.method_37908(), (class_1297)this.golem)) {
                this.prevPos.method_33098(this.getWaterSurfaceHeight(this.golem.method_37908(), (class_2338)this.prevPos));
                if ((double)this.prevPos.method_10264() > this.golem.method_23318()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2)) continue;
                            class_2338 pos = this.prevPos.method_10069(x, y, z);
                            if (!this.golem.method_37908().method_22347(pos) && !this.golem.method_37908().method_22351(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.field_5974.method_43048(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.field_5974.method_43048(3) == 0)) continue;
                            this.golem.method_37908().method_8501(pos, class_2246.field_10295.method_9564());
                        }
                    }
                }
                class_2338 topPos = this.prevPos.method_10086(2);
                if (this.golem.method_37908().method_22347(topPos)) {
                    this.golem.method_37908().method_8501(topPos, class_2246.field_10295.method_9564());
                }
                this.waterReplaced = true;
            }
        }

        public void method_6270() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.golem.setSwimJump(false);
            this.prevPos = null;
        }

        private int getWaterSurfaceHeight(class_1937 world, class_2338 coord) {
            int y = coord.method_10264();
            while (world.method_22351(new class_2338(coord.method_10263(), y + 1, coord.method_10260()))) {
                ++y;
            }
            return y;
        }
    }

    class ThrowIceGoal
    extends class_1352 {
        private class_1309 attackTarget;

        ThrowIceGoal() {
        }

        public boolean method_6264() {
            this.attackTarget = MutantSnowGolem.this.method_5968();
            return this.attackTarget != null && MutantSnowGolem.this.isThrowing;
        }

        public boolean method_6266() {
            return MutantSnowGolem.this.isThrowing && MutantSnowGolem.this.throwingTick < 20;
        }

        public void method_6268() {
            MutantSnowGolem.this.method_5942().method_6340();
            MutantSnowGolem.this.field_6283 = MutantSnowGolem.this.method_36454();
            if (MutantSnowGolem.this.throwingTick == 7) {
                ThrowableBlock block = new ThrowableBlock(MutantSnowGolem.this);
                double x = this.attackTarget.method_23317() - block.method_23317();
                double y = this.attackTarget.method_23318() - block.method_23318();
                double z = this.attackTarget.method_23321() - block.method_23321();
                double xz = Math.sqrt(x * x + z * z);
                block.method_7485(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                MutantSnowGolem.this.method_37908().method_8649((class_1297)block);
            }
        }

        public void method_6270() {
        }

        public boolean method_38846() {
            return true;
        }
    }
}

