/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.handler.EntityEventsHandler;
import fuzs.mutantmonsters.handler.PlayerEventsHandler;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CAnimationMessage;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTossCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.init.v2.PotionBrewingRegistry;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutantMonsters
implements ModConstructor {
    public static final String MOD_ID = "mutantmonsters";
    public static final String MOD_NAME = "Mutant Monsters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mutant Monsters");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"mutantmonsters").common(CommonConfig.class);
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"mutantmonsters");

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public void onConstructMod() {
        ModRegistry.touch();
        MutantMonsters.registerMessages();
        MutantMonsters.registerHandlers();
    }

    private static void registerMessages() {
        NETWORK.register(C2SCreeperMinionTrackerMessage.class, C2SCreeperMinionTrackerMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CMutantLevelParticlesMessage.class, S2CMutantLevelParticlesMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SCreeperMinionNameMessage.class, C2SCreeperMinionNameMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CAnimationMessage.class, S2CAnimationMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(S2CSeismicWaveFluidParticlesMessage.class, S2CSeismicWaveFluidParticlesMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(S2CMutantEndermanHeldBlockMessage.class, S2CMutantEndermanHeldBlockMessage::new, MessageDirection.TO_CLIENT);
    }

    private static void registerHandlers() {
        LivingHurtCallback.EVENT.register(EntityEventsHandler::onLivingHurt);
        UseItemEvents.TICK.register(PlayerEventsHandler::onItemUseTick);
        ArrowLooseCallback.EVENT.register(PlayerEventsHandler::onArrowLoose);
        PlayerInteractEvents.USE_ENTITY.register(EntityEventsHandler::onEntityInteract);
        PlayerTickEvents.END.register(PlayerEventsHandler::onPlayerTick$End);
        ServerEntityLevelEvents.LOAD.register(EntityEventsHandler::onEntityJoinServerLevel);
        LivingDropsCallback.EVENT.register(EntityEventsHandler::onLivingDrops);
        ItemTossCallback.EVENT.register(PlayerEventsHandler::onItemToss);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        context.enqueueWork(() -> PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43601_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.get(), (ItemLike)ModRegistry.HULK_HAMMER_ITEM.get(), (ItemLike)ModRegistry.CREEPER_SHARD_ITEM.get(), (ItemLike)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get()}), (Potion)ModRegistry.CHEMICAL_X_POTION.get()));
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get(), CreeperMinion.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get(), EndersoulClone.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get(), MutantCreeper.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get(), MutantEnderman.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get(), MutantSnowGolem.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), SpiderPig.registerAttributes());
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isForge()) {
            context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), MutantSkeleton.registerAttributes());
            context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), MutantZombie.registerAttributes());
        }
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        context.registerSpawnPlacement((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MutantEnderman::canSpawn);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.SPIDER_PIG_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Animal::m_218104_);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> true, biomeModificationContext -> {
            MobSpawnSettingsContext spawnSettings = biomeModificationContext.mobSpawnSettings();
            CommonConfig config = (CommonConfig)CONFIG.get(CommonConfig.class);
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantCreeperSpawnWeight, MobCategory.MONSTER, EntityType.f_20558_, (EntityType)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantEndermanSpawnWeight, MobCategory.MONSTER, EntityType.f_20566_, (EntityType)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantSkeletonSpawnWeight, MobCategory.MONSTER, EntityType.f_20524_, (EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get());
            MutantMonsters.addMutantSpawn(spawnSettings, config.mutantZombieSpawnWeight, MobCategory.MONSTER, EntityType.f_20501_, (EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get());
        });
    }

    private static void addMutantSpawn(MobSpawnSettingsContext spawnSettings, double spawnWeight, MobCategory mobCategory, EntityType<?> entityType, EntityType<?> mutantEntityType) {
        if (spawnWeight == 0.0) {
            return;
        }
        spawnSettings.getSpawnerData(mobCategory).stream().filter(data -> data.f_48404_ == entityType).findAny().ifPresent(spawnerData -> spawnSettings.addSpawn(mobCategory, new MobSpawnSettings.SpawnerData(mutantEntityType, Math.max(1, (int)((double)spawnerData.m_142631_().m_146281_() * spawnWeight)), 1, 1)));
        MobSpawnSettings.MobSpawnCost mobSpawnCost = spawnSettings.getSpawnCost(entityType);
        if (mobSpawnCost != null) {
            spawnSettings.setSpawnCost(mutantEntityType, mobSpawnCost.f_48386_() / spawnWeight, mobSpawnCost.f_48385_() * spawnWeight);
        }
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new ItemStack((ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.get())).displayItems((itemDisplayParameters, output) -> {
            output.m_246326_((ItemLike)ModRegistry.CREEPER_MINION_TRACKER_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.CREEPER_SHARD_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.HULK_HAMMER_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_ARMS_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_LIMB_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_PELVIS_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_RIB_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_RIB_CAGE_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_LEGGINGS_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_BOOTS_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.CREEPER_MINION_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_CREEPER_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_ENDERMAN_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SNOW_GOLEM_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_ZOMBIE_SPAWN_EGG_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.SPIDER_PIG_SPAWN_EGG_ITEM.get());
        }).appendEnchantmentsAndPotions());
    }
}

