/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.animation.AnimatedEntity;
import fuzs.mutantmonsters.animation.Animation;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import fuzs.puzzleslib.api.entity.v1.AdditionalAddEntityData;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantEnderman
extends AbstractMutantMonster
implements NeutralMob,
AnimatedEntity {
    private static final EntityDataAccessor<Optional<BlockPos>> TELEPORT_POSITION = SynchedEntityData.m_135353_(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Byte> ACTIVE_ARM = SynchedEntityData.m_135353_(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> CLONE = SynchedEntityData.m_135353_(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Animation MELEE_ANIMATION = new Animation(10);
    public static final Animation THROW_ANIMATION = new Animation(14);
    public static final Animation STARE_ANIMATION = new Animation(100);
    public static final Animation TELEPORT_ANIMATION = new Animation(10);
    public static final Animation SCREAM_ANIMATION = new Animation(165);
    public static final Animation CLONE_ANIMATION = new Animation(600);
    public static final Animation TELESMASH_ANIMATION = new Animation(30);
    public static final Animation DEATH_ANIMATION = new Animation(280);
    private static final Animation[] ANIMATIONS = new Animation[]{MELEE_ANIMATION, THROW_ANIMATION, STARE_ANIMATION, TELEPORT_ANIMATION, SCREAM_ANIMATION, CLONE_ANIMATION, TELESMASH_ANIMATION, DEATH_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private int screamDelayTick;
    private int[] heldBlock = new int[4];
    private int[] heldBlockTick = new int[4];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    @Nullable
    private List<Entity> capturedEntities;
    private DamageSource deathCause;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public MutantEnderman(EntityType<? extends MutantEnderman> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 40;
        this.m_274367_(1.4f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ThrowBlockGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new StareGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TeleportGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ScreamGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new CloneGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TeleSmashGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2).setMaxAttackTick(15));
        this.f_21345_.m_25352_(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new FindTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantEnderman.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 96.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TELEPORT_POSITION, Optional.empty());
        this.f_19804_.m_135372_(ACTIVE_ARM, (Object)0);
        this.f_19804_.m_135372_(CLONE, (Object)false);
    }

    public Optional<BlockPos> getTeleportPosition() {
        return (Optional)this.f_19804_.m_135370_(TELEPORT_POSITION);
    }

    private void setTeleportPosition(@Nullable BlockPos pos) {
        this.f_19804_.m_135381_(TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public int getHeldBlock(int index) {
        return this.heldBlock[index];
    }

    public void setHeldBlock(int index, int blockId, int tick) {
        this.heldBlock[index] = blockId;
        this.heldBlockTick[index] = tick;
        if (!this.m_9236_().f_46443_) {
            MutantMonsters.NETWORK.sendToAllTracking((MessageV2)new S2CMutantEndermanHeldBlockMessage(this, blockId, index), (Entity)this);
        }
    }

    public int getHeldBlockTick(int arm) {
        return this.heldBlockTick[arm];
    }

    public int getActiveArm() {
        return ((Byte)this.f_19804_.m_135370_(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.f_19804_.m_135381_(ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Boolean)this.f_19804_.m_135370_(CLONE);
    }

    private void setClone(boolean isClone) {
        this.f_19804_.m_135381_(CLONE, (Object)isClone);
        this.m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_MORPH_SOUND_EVENT.get(), 2.0f, this.m_6100_());
        this.m_9236_().m_7605_((Entity)this, (byte)0);
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.isClone() ? 2.55f : 3.9f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isClone() ? ((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get()).m_20680_() : super.m_6972_(poseIn);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    protected float m_5632_(float renderYawOffset, float distance) {
        return this.f_20919_ > 0 ? distance : super.m_5632_(renderYawOffset, distance);
    }

    public int m_5792_() {
        return 1;
    }

    public int m_6056_() {
        return this.isClone() ? 3 : super.m_6056_();
    }

    public boolean m_6087_() {
        return super.m_6087_() && this.animation != TELEPORT_ANIMATION;
    }

    protected void m_7562_() {
    }

    public boolean m_6126_() {
        return this.f_19797_ % 100 == 0 && !this.isClone();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (CLONE.equals(key)) {
            this.m_6210_();
        }
        if (TELEPORT_POSITION.equals(key) && this.getTeleportPosition().isPresent() && this.m_9236_().f_46443_) {
            this.animation = TELEPORT_ANIMATION;
            this.animationTick = 0;
            this.spawnTeleportParticles();
        }
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
        this.m_21561_(entitylivingbaseIn != null);
    }

    public float getArmScale(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        this.prevArmScale = this.armScale;
        if (this.m_5912_()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.m_9236_().f_46443_) {
            boolean mobGriefing = CommonAbstractions.INSTANCE.getMobGriefingEvent(this.m_9236_(), (Entity)this);
            for (int i = 0; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0 || this.heldBlockTick[i] != 0) continue;
                BlockPos startPos = BlockPos.m_274561_((double)(this.m_20185_() - 1.5 + this.f_19796_.m_188500_() * 4.0), (double)(this.m_20186_() - 0.5 + this.f_19796_.m_188500_() * 2.5), (double)(this.m_20189_() - 1.5 + this.f_19796_.m_188500_() * 4.0));
                BlockState heldState = Block.m_49931_((BlockState)Block.m_49803_((int)this.heldBlock[i]), (LevelAccessor)this.m_9236_(), (BlockPos)startPos);
                if (mobGriefing && this.canPlaceBlock(this.m_9236_(), startPos, heldState, startPos.m_7495_())) {
                    this.m_9236_().m_46597_(startPos, heldState);
                    SoundType soundType = heldState.m_60827_();
                    this.m_9236_().m_5594_(null, startPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                    this.setHeldBlock(i, 0, 0);
                    continue;
                }
                if (mobGriefing && this.f_19796_.m_188503_(50) != 0) continue;
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private boolean canPlaceBlock(Level world, BlockPos startPos, BlockState heldState, BlockPos belowPos) {
        return world.m_46859_(startPos) && !world.m_46859_(belowPos) && world.m_8055_(belowPos).m_60838_((BlockGetter)world, belowPos) && heldState.m_60710_((LevelReader)world, startPos) && world.m_45933_((Entity)this, new AABB(startPos)).isEmpty();
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.animation == SCREAM_ANIMATION && this.animationTick >= 40 && this.animationTick <= 160) {
            if (this.animationTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(20.0, 12.0, 20.0), EndersoulFragment.IS_VALID_TARGET);
            } else {
                Iterator<Entity> iterator = this.capturedEntities.iterator();
                while (iterator.hasNext()) {
                    Entity entity = iterator.next();
                    if (!(this.m_20280_(entity) > 400.0) && !entity.m_5833_()) {
                        entity.m_146926_(entity.m_146909_() + (this.f_19796_.m_188501_() - 0.3f) * 6.0f);
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 0) {
            this.spawnTeleportParticles();
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public void m_8107_() {
        this.f_20899_ = false;
        super.m_8107_();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == DEATH_ANIMATION) {
            this.f_20919_ = this.animationTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        if (this.m_9236_().f_46443_ && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() + (double)(this.f_20919_ > 0 ? 1.0f : 0.0f) - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.m_5448_() != null && !this.isAnimationPlaying()) {
            if (this.blockFrenzy == 0 && (this.m_21225_() != null && this.m_21225_().m_269014_() || this.f_19796_.m_188503_(!this.m_21691_() ? 300 : 600) == 0)) {
                this.blockFrenzy = 200 + this.f_19796_.m_188503_(80);
            }
            if (this.blockFrenzy > 0 && this.f_19796_.m_188503_(8) == 0) {
                int index = this.getFavorableHand();
                BlockPos pos = BlockPos.m_274561_((double)(this.m_20185_() - 2.5 + this.f_19796_.m_188500_() * 5.0), (double)(this.m_20186_() - 0.5 + this.f_19796_.m_188500_() * 3.0), (double)(this.m_20189_() - 2.5 + this.f_19796_.m_188500_() * 5.0));
                BlockState blockState = this.m_9236_().m_8055_(pos);
                if (index != -1 && MutantEnderman.canBlockBeHeld(this.m_9236_(), pos, blockState, ModRegistry.MUTANT_ENDERMAN_HOLDABLE_IMMUNE_BLOCK_TAG)) {
                    this.setHeldBlock(index, Block.m_49956_((BlockState)blockState), 0);
                    if (CommonAbstractions.INSTANCE.getMobGriefingEvent(this.m_9236_(), (Entity)this)) {
                        this.m_9236_().m_7471_(pos, false);
                    }
                }
            }
        }
    }

    public static boolean canBlockBeHeld(Level level, BlockPos pos, BlockState state, TagKey<Block> tag) {
        return state.m_60838_((BlockGetter)level, pos) && !state.m_155947_() && (state.m_60713_(Blocks.f_50259_) || !state.m_204336_(tag));
    }

    private void updateTeleport() {
        LivingEntity entity = this.m_5448_();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (this.m_20069_() || this.f_19789_ > 3.0f || entity != null && (this.m_20365_((Entity)entity) || this.m_20280_((Entity)entity) > 1024.0 || !this.m_21691_())) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void m_8024_() {
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.f_19796_.m_188503_(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.f_19796_.m_188503_(outer.size()));
        }
        return (Integer)inner.get(this.f_19796_.m_188503_(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.f_19796_.m_188503_(inner.size()));
        }
        return (Integer)outer.get(this.f_19796_.m_188503_(outer.size()));
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.m_9236_().f_46443_ && !this.isAnimationPlaying()) {
            int arm = this.getAvailableHand();
            if (!this.teleportByChance(6, entityIn)) {
                if (arm != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[0] == 0 && this.heldBlock[1] == 0;
                    if (allHandsFree && entityIn.m_6095_() != EntityType.f_20496_ && this.f_19796_.m_188503_(10) == 0) {
                        this.animation = CLONE_ANIMATION;
                    } else if (allHandsFree && this.f_19796_.m_188503_(7) == 0) {
                        this.animation = TELESMASH_ANIMATION;
                    } else {
                        this.setActiveArm(arm);
                        this.animation = MELEE_ANIMATION;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            boolean flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            if (!this.m_9236_().f_46443_ && this.f_19796_.m_188503_(2) == 0) {
                double x = entityIn.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
                double y = entityIn.m_20186_() + (double)this.f_19796_.m_188503_(5) + 4.0;
                double z = entityIn.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
                this.teleportToPosition(x, y, z);
            }
            if (flag) {
                this.m_5634_(2.0f);
                this.m_19970_((LivingEntity)this, entityIn);
            }
            this.m_6674_(InteractionHand.MAIN_HAND);
            return flag;
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!(source.m_7639_() instanceof EnderDragon) && !(source.m_7639_() instanceof MutantEnderman)) {
            if (!(this.animation != TELEPORT_ANIMATION && this.animation != SCREAM_ANIMATION || source.m_276093_(DamageTypes.f_268724_))) {
                return false;
            }
            boolean damaged = super.m_6469_(source, amount);
            if (damaged && this.animation == STARE_ANIMATION) {
                this.animation = Animation.NONE;
                return damaged;
            }
            if (!this.m_9236_().f_46443_ && !this.isAnimationPlaying() && this.m_6084_()) {
                boolean betterDodge;
                Entity entity = source.m_7639_();
                boolean bl = betterDodge = entity == null;
                if (source.m_269533_(DamageTypeTags.f_268524_) || source.m_269533_(DamageTypeTags.f_268415_) || source.m_276093_(DamageTypes.f_268671_)) {
                    betterDodge = true;
                }
                if (this.teleportByChance(betterDodge ? 3 : 6, entity) && !source.m_276093_(DamageTypes.f_268724_)) {
                    if (entity instanceof LivingEntity) {
                        this.m_6703_((LivingEntity)entity);
                    }
                    return false;
                }
                boolean betterTeleport = source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268612_);
                this.teleportByChance(betterTeleport ? 3 : 5, entity);
            }
            return damaged;
        }
        return false;
    }

    public boolean m_147207_(MobEffectInstance effectInstanceIn, @Nullable Entity entity) {
        return !this.isClone() && super.m_147207_(effectInstanceIn, entity);
    }

    private boolean teleportByChance(int chance, @Nullable Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        if (this.f_19796_.m_188503_(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 * radius;
        double y = this.m_20186_() + (double)this.f_19796_.m_188503_((int)radius * 2) - radius;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 * radius;
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (this.m_20280_(entity) < 100.0) {
            x = entity.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 * radius;
            y = entity.m_20186_() + this.f_19796_.m_188500_() * radius;
            z = entity.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 * radius;
        } else {
            Vec3 vec = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
            vec = vec.m_82541_();
            x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec.f_82479_ * radius;
            y = this.m_20186_() + (double)this.f_19796_.m_188503_(8) - vec.f_82480_ * radius;
            z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec.f_82481_ * radius;
        }
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToPosition(double x, double y, double z) {
        if (!this.m_21515_()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((Mob)this, x, y, z);
            if (flag) {
                this.m_8127_();
                if (!this.m_20067_()) {
                    this.m_9236_().m_7785_(this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModRegistry.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.get(), this.m_5720_(), 1.0f, 1.0f, false);
                    this.m_5496_((SoundEvent)ModRegistry.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.get(), 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (this.isAnimationPlaying()) {
            return false;
        }
        this.animation = TELEPORT_ANIMATION;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        boolean success = false;
        if (this.m_9236_().m_46749_((BlockPos)pos)) {
            do {
                pos.m_122173_(Direction.DOWN);
            } while (pos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_());
            pos.m_122173_(Direction.UP);
            AABB bb = this.m_6095_().m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (this.m_9236_().m_45756_((Entity)this, bb) && !this.m_9236_().m_46855_(bb)) {
                success = true;
            }
        }
        if (!success) {
            this.animation = Animation.NONE;
            return false;
        }
        this.setTeleportPosition((BlockPos)pos);
        return true;
    }

    public static void teleportAttack(LivingEntity attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.m_217043_().m_188503_(60);
        DamageSource damageSource = attacker.m_269291_().m_269333_(attacker);
        if (attacker instanceof Player) {
            radius = 2.0;
            duration = 100;
            damageSource = attacker.m_269291_().m_269075_((Player)attacker);
        }
        for (Entity entity : attacker.m_9236_().m_6249_((Entity)attacker, attacker.m_20191_().m_82400_(radius), EndersoulFragment.IS_VALID_TARGET)) {
            if (entity instanceof LivingEntity && entity.m_6469_(damageSource, 4.0f) && attacker.m_217043_().m_188503_(3) == 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration));
            }
            double x = entity.m_20185_() - attacker.m_20185_();
            double z = entity.m_20189_() - attacker.m_20189_();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            entity.m_20334_((radius * signX * 2.0 - x) * (double)0.2f, (double)0.2f, (radius * signZ * 2.0 - z) * (double)0.2f);
            EntityUtil.sendPlayerVelocityPacket(entity);
        }
    }

    private void spawnTeleportParticles() {
        BlockPos teleportPos = this.getTeleportPosition().orElse(null);
        int amount = teleportPos != null ? 512 : 256;
        for (int i = 0; i < amount; ++i) {
            boolean useCurrentPos = teleportPos == null || i < amount / 2;
            double tempX = (useCurrentPos ? this.m_20185_() : (double)teleportPos.m_123341_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double tempY = (useCurrentPos ? this.m_20186_() : (double)teleportPos.m_123342_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20206_() + 1.5;
            double tempZ = (useCurrentPos ? this.m_20189_() : (double)teleportPos.m_123343_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            this.m_9236_().m_7106_((ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), tempX, tempY, tempZ, (this.f_19796_.m_188500_() - 0.5) * 1.8, (this.f_19796_.m_188500_() - 0.5) * 1.8, (this.f_19796_.m_188500_() - 0.5) * 1.8);
        }
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(3.0);
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (this.isClone()) {
            super.m_6731_(livingEntity);
        } else {
            livingEntity.f_19864_ = true;
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.capturedEntities = null;
        if (!this.m_9236_().f_46443_) {
            this.deathCause = cause;
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            AnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION);
            if (this.f_20889_ > 0) {
                this.f_20889_ += DEATH_ANIMATION.duration();
            }
        }
    }

    protected void m_6153_() {
        this.m_20334_(0.0, Math.min(this.m_20184_().f_82480_, 0.0), 0.0);
        if (this.f_20919_ == 80) {
            this.m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_DEATH_SOUND_EVENT.get(), 5.0f, this.m_6100_());
        }
        if (this.f_20919_ >= 60) {
            if (this.f_20919_ < 80 && this.capturedEntities == null) {
                this.capturedEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(10.0, 8.0, 10.0), EndersoulFragment.IS_VALID_TARGET);
            }
            if (!this.m_9236_().f_46443_ && this.f_19796_.m_188503_(3) != 0) {
                EndersoulFragment orb = new EndersoulFragment(this.m_9236_(), this);
                orb.m_6034_(this.m_20185_(), this.m_20186_() + 3.8, this.m_20189_());
                orb.m_20334_((this.f_19796_.m_188500_() - 0.5) * 1.5, (this.f_19796_.m_188500_() - 0.5) * 1.5, (this.f_19796_.m_188500_() - 0.5) * 1.5);
                this.m_9236_().m_7967_((Entity)orb);
            }
        }
        if (this.f_20919_ >= 80 && this.f_20919_ < DEATH_ANIMATION.duration() - 20 && this.capturedEntities != null) {
            Iterator<Entity> iterator = this.capturedEntities.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (entity.f_19789_ > 4.5f) {
                    entity.f_19789_ = 4.5f;
                }
                if (!(this.m_20280_(entity) > 64.0)) continue;
                if (!EndersoulFragment.isProtected(entity) && !entity.m_5833_()) {
                    double x = this.m_20185_() - entity.m_20185_();
                    double y = entity.m_20184_().f_82480_;
                    double z = this.m_20189_() - entity.m_20189_();
                    double d = Math.sqrt(x * x + z * z);
                    if (this.m_20186_() + 4.0 > entity.m_20186_()) {
                        y = Math.max(entity.m_20184_().f_82480_, (double)0.4f);
                    }
                    entity.m_20334_((double)0.8f * x / d, y, (double)0.8f * z / d);
                    continue;
                }
                iterator.remove();
            }
        }
        if (!this.m_9236_().f_46443_ && this.f_20919_ >= 100 && this.f_20919_ < 150 && this.f_20919_ % 6 == 0 && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            super.m_7625_(this.deathCause != null ? this.deathCause : this.m_9236_().m_269111_().m_269264_(), this.f_20889_ > 0);
        }
        if (this.f_20919_ >= DEATH_ANIMATION.duration()) {
            this.m_21226_();
            this.m_146870_();
        }
    }

    protected void m_7625_(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public boolean m_6149_() {
        return this.f_20919_ > 0;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        return this.f_20919_ > 0 ? this.m_5552_(stack, 3.84f) : super.m_19983_(stack);
    }

    public static boolean canSpawn(EntityType<MutantEnderman> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return randomIn.m_188503_(3) == 0 && MutantEnderman.m_219013_(type, (ServerLevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    protected Component m_5677_() {
        return this.isClone() ? ((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get()).m_20676_() : super.m_5677_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
        compound.m_128405_("BlockFrenzy", this.blockFrenzy);
        compound.m_128405_("ScreamDelay", this.screamDelayTick);
        ListTag listNBT = new ListTag();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            CompoundTag compoundNBT = NbtUtils.m_129202_((BlockState)Block.m_49803_((int)this.heldBlock[i]));
            compound.m_128344_("Index", (byte)i);
            compoundNBT.m_128405_("Tick", this.heldBlockTick[i]);
            listNBT.add((Object)compoundNBT);
        }
        if (!listNBT.isEmpty()) {
            compound.m_128365_("HeldBlocks", (Tag)listNBT);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_9236_() instanceof ServerLevel) {
            this.m_147285_(this.m_9236_(), compound);
        }
        this.blockFrenzy = compound.m_128451_("BlockFrenzy");
        this.screamDelayTick = compound.m_128451_("ScreamDelay");
        if (compound.m_128425_("HeldBlocks", 9)) {
            ListTag listNBT = compound.m_128437_("HeldBlocks", 9);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.m_128728_(i);
                BlockState blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundNBT);
                this.setHeldBlock(compoundNBT.m_128445_("Index"), Block.m_49956_((BlockState)blockState), compound.m_128451_("Tick"));
            }
        }
        if (this.f_20919_ > 0) {
            this.animation = DEATH_ANIMATION;
            this.animationTick = this.f_20919_;
        }
    }

    public int m_8100_() {
        return 200;
    }

    public void m_8032_() {
        if (!this.isClone()) {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.get();
    }

    private boolean isBeingLookedAtBy(LivingEntity target) {
        if (!(target instanceof Mob)) {
            Vec3 lookVec = target.m_20252_(1.0f).m_82541_();
            Vec3 targetVec = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20188_() - target.m_20188_(), this.m_20189_() - target.m_20189_());
            double length = targetVec.m_82553_();
            double d = lookVec.m_82526_(targetVec = targetVec.m_82541_());
            return d > 1.0 - 0.08 / length && target.m_142582_((Entity)this);
        }
        return ((Mob)target).m_5448_() == this && target.m_142582_((Entity)this);
    }

    @Override
    public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.m_130130_(this.hasTarget);
        buffer.m_130130_(this.armScale);
        buffer.m_130089_(this.heldBlock);
        buffer.m_130089_(this.heldBlockTick);
    }

    @Override
    public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.hasTarget = additionalData.m_130242_();
        this.armScale = additionalData.m_130242_();
        this.heldBlock = additionalData.m_130100_();
        this.heldBlockTick = additionalData.m_130100_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return AdditionalAddEntityData.getPacket((Entity)this);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantEnderman> {
        public MeleeGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void m_8037_() {
            if (((MutantEnderman)this.mob).animationTick == 3) {
                ((MutantEnderman)this.mob).m_5496_(SoundEvents.f_12316_, 1.0f, ((MutantEnderman)this.mob).m_6100_());
                boolean lower = ((MutantEnderman)this.mob).getActiveArm() >= 2;
                float attackDamage = (float)((MutantEnderman)this.mob).m_21133_(Attributes.f_22281_);
                for (LivingEntity livingEntity : ((MutantEnderman)this.mob).m_9236_().m_45976_(LivingEntity.class, ((MutantEnderman)this.mob).m_20191_().m_82400_(4.0))) {
                    if (livingEntity instanceof MutantEnderman || livingEntity instanceof EndersoulClone) continue;
                    double dist = ((MutantEnderman)this.mob).m_20270_((Entity)livingEntity);
                    double x = ((MutantEnderman)this.mob).m_20185_() - livingEntity.m_20185_();
                    double z = ((MutantEnderman)this.mob).m_20189_() - livingEntity.m_20189_();
                    if (!(((MutantEnderman)this.mob).m_20191_().f_82289_ <= livingEntity.m_20191_().f_82292_) || !(dist <= 4.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    livingEntity.m_6469_(((MutantEnderman)this.mob).m_269291_().m_269333_((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f);
                    float power = 0.4f + ((MutantEnderman)this.mob).f_19796_.m_188501_() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    livingEntity.m_20334_(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((Entity)livingEntity);
                }
            }
        }
    }

    static class ThrowBlockGoal
    extends AnimationGoal<MutantEnderman> {
        public ThrowBlockGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            if (((MutantEnderman)this.mob).isAnimationPlaying()) {
                return false;
            }
            if (!((MutantEnderman)this.mob).triggerThrowBlock && ((MutantEnderman)this.mob).m_217043_().m_188503_(28) != 0) {
                return false;
            }
            if (((MutantEnderman)this.mob).m_5448_() != null && !((MutantEnderman)this.mob).m_142582_((Entity)((MutantEnderman)this.mob).m_5448_())) {
                return false;
            }
            int id = ((MutantEnderman)this.mob).getThrowingHand();
            if (id == -1) {
                return false;
            }
            ((MutantEnderman)this.mob).setActiveArm(id);
            return true;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            int id = ((MutantEnderman)this.mob).getActiveArm();
            ((MutantEnderman)this.mob).m_9236_().m_7967_((Entity)new ThrowableBlock((MutantEnderman)this.mob, id));
            ((MutantEnderman)this.mob).setHeldBlock(id, 0, 0);
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            ((MutantEnderman)this.mob).triggerThrowBlock = false;
        }
    }

    static class StareGoal
    extends AnimationGoal<MutantEnderman> {
        private LivingEntity attackTarget;

        public StareGoal(MutantEnderman mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return STARE_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            this.attackTarget = ((MutantEnderman)this.mob).m_5448_();
            return this.attackTarget != null && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ((MutantEnderman)this.mob).f_21363_ = -((MutantEnderman)this.mob).m_8100_();
            ((MutantEnderman)this.mob).m_9236_().m_6269_(null, (Entity)this.mob, (SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_STARE_SOUND_EVENT.get(), ((MutantEnderman)this.mob).m_5720_(), 2.5f, 0.7f + ((MutantEnderman)this.mob).f_19796_.m_188501_() * 0.2f);
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && this.attackTarget.m_6084_() && ((MutantEnderman)this.mob).isBeingLookedAtBy(this.attackTarget);
        }

        public void m_8037_() {
            ((MutantEnderman)this.mob).m_21573_().m_26573_();
            ((MutantEnderman)this.mob).f_21365_.m_24960_((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.attackTarget.m_8127_();
            this.attackTarget.m_6469_(DamageSourcesHelper.source((LevelReader)((MutantEnderman)this.mob).m_9236_(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 2.0f);
            this.attackTarget.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 160 + ((MutantEnderman)this.mob).f_19796_.m_188503_(140)));
            double x = ((MutantEnderman)this.mob).m_20185_() - this.attackTarget.m_20185_();
            double z = ((MutantEnderman)this.mob).m_20189_() - this.attackTarget.m_20189_();
            this.attackTarget.m_20334_(x * (double)0.1f, (double)0.3f, z * (double)0.1f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class TeleportGoal
    extends AnimationGoal<MutantEnderman> {
        public TeleportGoal(MutantEnderman mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return TELEPORT_ANIMATION;
        }

        @Override
        public void m_8056_() {
            ((MutantEnderman)this.mob).animation = TELEPORT_ANIMATION;
            ((MutantEnderman)this.mob).animationTick = 0;
            MutantEnderman.teleportAttack((LivingEntity)this.mob);
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5));
            if (!((MutantEnderman)this.mob).m_20067_()) {
                ((MutantEnderman)this.mob).m_9236_().m_6263_(null, ((MutantEnderman)this.mob).f_19854_, ((MutantEnderman)this.mob).f_19855_, ((MutantEnderman)this.mob).f_19856_, (SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.get(), ((MutantEnderman)this.mob).m_5720_(), 1.0f, 1.0f);
                ((MutantEnderman)this.mob).m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.get(), 1.0f, 1.0f);
            }
            MutantEnderman.teleportAttack((LivingEntity)this.mob);
            ((MutantEnderman)this.mob).m_6034_(((MutantEnderman)this.mob).f_19854_, ((MutantEnderman)this.mob).f_19855_, ((MutantEnderman)this.mob).f_19856_);
        }

        public void m_8037_() {
            ((MutantEnderman)this.mob).m_21573_().m_26573_();
        }

        @Override
        public void m_8041_() {
            ((MutantEnderman)this.mob).m_8127_();
            ((MutantEnderman)this.mob).f_19789_ = 0.0f;
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).m_6021_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5));
            super.m_8041_();
            ((MutantEnderman)this.mob).setTeleportPosition(null);
        }
    }

    static class ScreamGoal
    extends AnimationGoal<MutantEnderman> {
        public ScreamGoal(MutantEnderman mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return SCREAM_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            if (((MutantEnderman)this.mob).m_5448_() != null && !((MutantEnderman)this.mob).isAnimationPlaying()) {
                return ((MutantEnderman)this.mob).screamDelayTick <= 0 && ((MutantEnderman)this.mob).m_20280_((Entity)((MutantEnderman)this.mob).m_5448_()) < 400.0 && ((MutantEnderman)this.mob).f_19796_.m_188503_(((MutantEnderman)this.mob).m_20070_() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void m_8037_() {
            ((MutantEnderman)this.mob).m_21573_().m_26573_();
            if (((MutantEnderman)this.mob).animationTick == 40) {
                ((MutantEnderman)this.mob).f_21363_ = -((MutantEnderman)this.mob).m_8100_();
                ((MutantEnderman)this.mob).m_9236_().m_6106_().m_5565_(false);
                ((MutantEnderman)this.mob).m_9236_().m_7605_((Entity)this.mob, (byte)0);
                ((MutantEnderman)this.mob).m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ENDERMAN_SCREAM_SOUND_EVENT.get(), 5.0f, 0.7f + ((MutantEnderman)this.mob).f_19796_.m_188501_() * 0.2f);
                for (Entity entity : ((MutantEnderman)this.mob).m_9236_().m_6249_((Entity)this.mob, ((MutantEnderman)this.mob).m_20191_().m_82377_(20.0, 12.0, 20.0), EndersoulFragment.IS_VALID_TARGET)) {
                    if (!(((MutantEnderman)this.mob).m_20280_(entity) < 400.0)) continue;
                    entity.m_6469_(DamageSourcesHelper.source((LevelReader)((MutantEnderman)this.mob).m_9236_(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 4.0f);
                    if (!(entity instanceof Mob)) continue;
                    Mob mobEntity = (Mob)entity;
                    mobEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 3));
                    if (((MutantEnderman)this.mob).f_19796_.m_188503_(2) != 0) {
                        mobEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120 + ((MutantEnderman)this.mob).f_19796_.m_188503_(180), ((MutantEnderman)this.mob).f_19796_.m_188503_(2)));
                    }
                    if (((MutantEnderman)this.mob).f_19796_.m_188503_(4) != 0) {
                        mobEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300 + ((MutantEnderman)this.mob).f_19796_.m_188503_(300), ((MutantEnderman)this.mob).f_19796_.m_188503_(2)));
                    }
                    if (((MutantEnderman)this.mob).f_19796_.m_188503_(3) != 0) {
                        mobEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 120 + ((MutantEnderman)this.mob).f_19796_.m_188503_(60), 10 + ((MutantEnderman)this.mob).f_19796_.m_188503_(2)));
                    }
                    if (((MutantEnderman)this.mob).f_19796_.m_188503_(4) == 0) continue;
                    mobEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 120 + ((MutantEnderman)this.mob).f_19796_.m_188503_(400)));
                }
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            ((MutantEnderman)this.mob).screamDelayTick = 600;
        }
    }

    static class CloneGoal
    extends AnimationGoal<MutantEnderman> {
        private final List<EndersoulClone> cloneList = new ArrayList<EndersoulClone>();
        private LivingEntity attackTarget;

        public CloneGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return CLONE_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            this.attackTarget = ((MutantEnderman)this.mob).m_5448_();
            if (this.attackTarget == null) {
                return false;
            }
            if (this.attackTarget.m_6095_() != EntityType.f_20496_ && ((MutantEnderman)this.mob).heldBlock[0] == 0 && ((MutantEnderman)this.mob).heldBlock[1] == 0) {
                return ((MutantEnderman)this.mob).f_20916_ == 0 && (super.m_8036_() || !((MutantEnderman)this.mob).isAnimationPlaying() && ((MutantEnderman)this.mob).f_19797_ % 3 == 0 && ((MutantEnderman)this.mob).f_19796_.m_188503_(300) == 0);
            }
            return false;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ((MutantEnderman)this.mob).f_19802_ = 20;
            ((MutantEnderman)this.mob).m_274367_(1.0f);
            ((MutantEnderman)this.mob).setClone(true);
            ((MutantEnderman)this.mob).m_20095_();
            ((MutantEnderman)this.mob).m_21219_();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.m_20185_() + (((MutantEnderman)this.mob).f_19796_.m_188500_() - 0.5) * 24.0;
                double y = this.attackTarget.m_20186_() + 8.0;
                double z = this.attackTarget.m_20189_() + (((MutantEnderman)this.mob).f_19796_.m_188500_() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            this.createClone(((MutantEnderman)this.mob).f_19854_, ((MutantEnderman)this.mob).f_19855_, ((MutantEnderman)this.mob).f_19856_);
            double x = this.attackTarget.m_20185_() + (((MutantEnderman)this.mob).f_19796_.m_188500_() - 0.5) * 24.0;
            double y = this.attackTarget.m_20186_() + 8.0;
            double z = this.attackTarget.m_20189_() + (((MutantEnderman)this.mob).f_19796_.m_188500_() - 0.5) * 24.0;
            ((MutantEnderman)this.mob).teleportToPosition(x, y, z);
            EntityUtil.divertAttackers(this.mob, (LivingEntity)this.getRandomClone());
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && ((MutantEnderman)this.mob).m_5448_() != null && !this.cloneList.isEmpty() && ((MutantEnderman)this.mob).f_20916_ == 0;
        }

        public void m_8037_() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                EndersoulClone clone = this.cloneList.get(i);
                if (clone.m_6084_() && clone.m_9236_() == ((MutantEnderman)this.mob).m_9236_()) continue;
                this.cloneList.remove(i);
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            ((MutantEnderman)this.mob).setClone(false);
            ((MutantEnderman)this.mob).m_274367_(1.4f);
            for (EndersoulClone clone : this.cloneList) {
                if (!clone.m_6084_()) continue;
                clone.m_146870_();
                EntityUtil.divertAttackers((Mob)clone, (LivingEntity)this.mob);
            }
            this.cloneList.clear();
            ((MutantEnderman)this.mob).m_21573_().m_26573_();
            this.attackTarget.m_6703_((LivingEntity)this.mob);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulClone clone = (EndersoulClone)((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get()).m_20615_(((MutantEnderman)this.mob).m_9236_());
            clone.setCloner((MutantEnderman)this.mob);
            this.cloneList.add(clone);
            if (!EntityUtil.teleportTo((Mob)clone, x, y, z)) {
                clone.m_20359_((Entity)this.mob);
            }
            ((MutantEnderman)this.mob).m_9236_().m_7967_((Entity)clone);
        }

        private Mob getRandomClone() {
            return this.cloneList.isEmpty() ? this.mob : (Mob)this.cloneList.get(((MutantEnderman)this.mob).f_19796_.m_188503_(this.cloneList.size()));
        }
    }

    static class TeleSmashGoal
    extends AnimationGoal<MutantEnderman> {
        private LivingEntity attackTarget;

        public TeleSmashGoal(MutantEnderman mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return TELESMASH_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            this.attackTarget = ((MutantEnderman)this.mob).m_5448_();
            return this.attackTarget != null && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.attackTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 5));
            this.attackTarget.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 160 + this.attackTarget.m_217043_().m_188503_(160)));
        }

        public void m_8037_() {
            ((MutantEnderman)this.mob).m_21573_().m_26573_();
            if (((MutantEnderman)this.mob).animationTick < 20) {
                ((MutantEnderman)this.mob).f_21365_.m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantEnderman)this.mob).animationTick == 17) {
                this.attackTarget.m_8127_();
            }
            if (((MutantEnderman)this.mob).animationTick == 18) {
                double x = this.attackTarget.m_20185_() + (this.attackTarget.m_217043_().m_188500_() - 0.5) * 14.0;
                double y = this.attackTarget.m_20186_() + this.attackTarget.m_217043_().m_188500_() + (this.attackTarget instanceof Player ? 13.0 : 7.0);
                double z = this.attackTarget.m_20189_() + (this.attackTarget.m_217043_().m_188500_() - 0.5) * 14.0;
                EntityUtil.stunRavager(this.attackTarget);
                EntityUtil.sendParticlePacket((Entity)this.attackTarget, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), 256);
                this.attackTarget.m_6021_(x, y, z);
                ((MutantEnderman)this.mob).m_9236_().m_6263_(null, x, y, z, SoundEvents.f_11913_, this.attackTarget.m_5720_(), 1.2f, 0.9f + this.attackTarget.m_217043_().m_188501_() * 0.2f);
                this.attackTarget.m_6469_(DamageSourcesHelper.source((LevelReader)((MutantEnderman)this.mob).m_9236_(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 6.0f);
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.attackTarget = null;
        }
    }

    static class FindTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public FindTargetGoal(MutantEnderman mutantEnderman) {
            super((Mob)mutantEnderman, LivingEntity.class, 10, false, false, target -> (mutantEnderman.m_21674_((LivingEntity)target) || mutantEnderman.isBeingLookedAtBy((LivingEntity)target) || EndersoulFragment.isProtected((Entity)target)) && target.m_5789_());
        }

        public boolean m_8036_() {
            boolean flag;
            boolean bl = flag = !((MutantEnderman)this.f_26135_).isAnimationPlaying() && super.m_8036_();
            if (flag && ((MutantEnderman)this.f_26135_).isBeingLookedAtBy(this.f_26050_)) {
                ((MutantEnderman)this.f_26135_).animation = STARE_ANIMATION;
            }
            return flag;
        }

        protected AABB m_7255_(double targetDistance) {
            return this.f_26135_.m_20191_().m_82377_(targetDistance, targetDistance / 2.0, targetDistance);
        }
    }
}

