/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.animation.AnimatedEntity;
import fuzs.mutantmonsters.animation.Animation;
import fuzs.mutantmonsters.core.SeismicWave;
import fuzs.mutantmonsters.core.ZombieResurrection;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import fuzs.puzzleslib.api.entity.v1.AdditionalAddEntityData;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MutantZombie
extends AbstractMutantMonster
implements AnimatedEntity {
    public static final int MAX_VANISH_TIME = 100;
    public static final int MAX_DEATH_TIME = 140;
    public static final Animation SLAM_GROUND_ANIMATION = new Animation(25);
    public static final Animation THROW_ANIMATION = new Animation(15);
    public static final Animation ROAR_ANIMATION = new Animation(120);
    private static final EntityDataAccessor<Integer> LIVES = SynchedEntityData.m_135353_(MutantZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> THROW_ATTACK_STATE = SynchedEntityData.m_135353_(MutantZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Animation[] ANIMATIONS = new Animation[]{SLAM_GROUND_ANIMATION, THROW_ANIMATION, ROAR_ANIMATION};
    private final List<SeismicWave> seismicWaveList;
    private final List<ZombieResurrection> resurrectionList;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private Animation animation = Animation.NONE;
    private int animationTick;
    private DamageSource deathCause;

    public MutantZombie(EntityType<? extends MutantZombie> type, Level worldIn) {
        super(type, worldIn);
        this.seismicWaveList = new ArrayList<SeismicWave>();
        this.resurrectionList = new ArrayList<ZombieResurrection>();
        this.m_274367_(1.0f);
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantZombie.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SlamGroundGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RoarGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new ThrowAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2).setMaxAttackTick(0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, WitherBoss.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIVES, (Object)3);
        this.f_19804_.m_135372_(THROW_ATTACK_STATE, (Object)0);
    }

    public int getLives() {
        return (Integer)this.f_19804_.m_135370_(LIVES);
    }

    private void setLives(int lives) {
        this.f_19804_.m_135381_(LIVES, (Object)lives);
    }

    public boolean hasThrowAttackHit() {
        return ((Byte)this.f_19804_.m_135370_(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean hit) {
        byte b0 = (Byte)this.f_19804_.m_135370_(THROW_ATTACK_STATE);
        this.f_19804_.m_135381_(THROW_ATTACK_STATE, (Object)(hit ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isThrowAttackFinished() {
        return ((Byte)this.f_19804_.m_135370_(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean finished) {
        byte b0 = (Byte)this.f_19804_.m_135370_(THROW_ATTACK_STATE);
        this.f_19804_.m_135381_(THROW_ATTACK_STATE, (Object)(finished ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.8f;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    protected float m_5632_(float renderYawOffset, float distance) {
        return this.f_20919_ > 0 ? distance : super.m_5632_(renderYawOffset, distance);
    }

    public int m_5792_() {
        return 1;
    }

    public int m_6056_() {
        return this.m_5448_() != null ? (int)this.m_20270_((Entity)this.m_5448_()) : 3;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_6094_() {
        return !this.m_6147_();
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = player.m_21120_(hand);
        ItemStack itemInHandCopy = itemInHand.m_41777_();
        InteractionResult interactionResult = this.deadMobInteract(player, hand);
        if (interactionResult.m_19077_()) {
            if (player.m_150110_().f_35937_ && itemInHand == player.m_21120_(hand) && itemInHand.m_41613_() < itemInHandCopy.m_41613_()) {
                itemInHand.m_41764_(itemInHandCopy.m_41613_());
            }
            if (itemInHand.m_41619_() && !player.m_150110_().f_35937_) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            this.m_146850_(GameEvent.f_223708_);
            return interactionResult;
        }
        return super.m_7111_(player, vec, hand);
    }

    private InteractionResult deadMobInteract(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_204117_(ItemTags.f_262757_) && !this.m_6084_() && !this.m_6060_() && !this.m_20070_()) {
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.m_20254_(8);
                if (!itemInHand.m_41763_()) {
                    itemInHand.m_41774_(1);
                } else {
                    itemInHand.m_41622_(1, (LivingEntity)player, livingEntity -> livingEntity.m_21190_(hand));
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemInHand.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.isAnimationPlaying()) {
            if (entityIn.m_20202_() != this && this.f_19796_.m_188503_(5) != 0) {
                if (this.m_20096_() || !this.m_146900_().m_60819_().m_76178_()) {
                    this.animation = SLAM_GROUND_ANIMATION;
                }
            } else {
                this.animation = THROW_ANIMATION;
            }
        }
        return true;
    }

    protected void m_8024_() {
        if (!this.isAnimationPlaying() && this.m_5448_() != null && Math.abs(this.m_20186_() - this.m_5448_().m_20186_()) <= 1.0 && this.m_20280_((Entity)this.m_5448_()) <= 49.0 && this.f_19796_.m_188503_(20) == 0) {
            this.animation = SLAM_GROUND_ANIMATION;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        return (entity == null || this.canHarm(entity) && (this.animation != THROW_ANIMATION || entity != this.m_5448_())) && super.m_6469_(source, amount);
    }

    protected void m_7562_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        if (this.m_9236_().m_46462_() && this.f_19797_ % 100 == 0 && this.m_6084_() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove((Object)zr);
        }
        if (this.m_21223_() > 0.0f) {
            this.f_20919_ = 0;
            this.vanishTime = 0;
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.f_20885_ - this.f_20883_; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.animation == SLAM_GROUND_ANIMATION) {
            offset = 0.2f;
        }
        this.f_20883_ += yaw * offset;
    }

    private void updateAnimation() {
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.m_9236_().f_46443_) {
            if (this.animation == THROW_ANIMATION) {
                if (this.hasThrowAttackHit()) {
                    if (this.throwHitTick == -1) {
                        this.throwHitTick = 0;
                    }
                    ++this.throwHitTick;
                }
                if (this.isThrowAttackFinished()) {
                    if (this.throwFinishTick == -1) {
                        this.throwFinishTick = 0;
                    }
                    ++this.throwFinishTick;
                }
            } else {
                this.throwHitTick = -1;
                this.throwFinishTick = -1;
            }
        }
    }

    private void updateMeleeGrounds() {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(this.m_9236_(), (Entity)this);
            AABB box = new AABB((double)wave.m_123341_(), (double)wave.m_123342_() + 1.0, (double)wave.m_123343_(), (double)wave.m_123341_() + 1.0, (double)wave.m_123342_() + 2.0, (double)wave.m_123343_() + 1.0);
            if (wave.isFirst()) {
                double addScale = this.f_19796_.m_188500_() * 0.75;
                box = box.m_82377_(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            DamageSource source = DamageSourcesHelper.source((LevelReader)this.m_9236_(), ModRegistry.EFFECTS_BYPASSING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this);
            for (Entity entity : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20406_.and(this::canHarm))) {
                if (entity instanceof LivingEntity && entity.m_6469_(source, wave.isFirst() ? (float)(9 + this.f_19796_.m_188503_(4)) : (float)(6 + this.f_19796_.m_188503_(3))) && this.f_19796_.m_188503_(5) == 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19612_, 160, 1));
                }
                double x = entity.m_20185_() - this.m_20185_();
                double z = entity.m_20189_() - this.m_20189_();
                double d = Math.sqrt(x * x + z * z);
                entity.m_20334_(x / d * 0.3, 0.04, z / d * 0.3);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
        }
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(1.0);
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        livingEntity.f_19864_ = true;
    }

    public void m_6667_(DamageSource cause) {
        if (!this.m_9236_().f_46443_) {
            this.deathCause = cause;
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            this.m_21335_((Entity)this.m_21188_());
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            if (this.f_20889_ > 0) {
                this.f_20889_ += 140;
            }
        }
    }

    protected void m_6153_() {
        if (this.f_20919_ <= 25 || !this.m_6060_() || this.f_20919_ >= 100) {
            ++this.f_20919_;
        }
        if (this.m_6060_()) {
            if (this.vanishTime == 0) {
                EntityUtil.sendMetadataPacket((Entity)this);
            }
            ++this.vanishTime;
        } else {
            this.vanishTime = Math.max(0, this.vanishTime - 1);
        }
        if (this.f_20919_ >= 140) {
            this.f_20919_ = 0;
            this.vanishTime = 0;
            this.deathCause = null;
            this.setLives(this.getLives() - 1);
            if (this.m_21214_() != null) {
                this.m_21214_().m_6703_((LivingEntity)this);
            }
            this.m_21153_(Math.round(this.m_21233_() / 3.75f));
        }
        if (this.vanishTime >= 100 || this.getLives() <= 0 && this.f_20919_ > 25) {
            if (!this.m_9236_().f_46443_) {
                super.m_6667_(this.deathCause != null ? this.deathCause : this.m_9236_().m_269111_().m_269264_());
            }
            for (int i = 0; i < 30; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)(this.m_6060_() ? ParticleTypes.f_123744_ : ParticleTypes.f_123759_), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            this.m_146870_();
        }
    }

    public void m_6074_() {
        super.m_6074_();
        this.setLives(0);
    }

    private boolean canHarm(Entity entity) {
        return entity.m_6095_() != EntityType.f_20501_ && entity.m_6095_() != EntityType.f_20530_ && entity.m_6095_() != EntityType.f_20458_ && entity.m_6095_() != EntityType.f_20562_ && !(entity instanceof MutantZombie);
    }

    public boolean m_214076_(ServerLevel serverWorld, LivingEntity livingEntity) {
        if ((serverWorld.m_46791_() == Difficulty.NORMAL && this.f_19796_.m_188499_() || serverWorld.m_46791_() == Difficulty.HARD) && livingEntity instanceof Villager) {
            EntityUtil.convertMobWithNBT(livingEntity, EntityType.f_20530_, false);
            if (!livingEntity.m_20067_()) {
                serverWorld.m_5898_(null, 1026, livingEntity.m_20183_(), 0);
            }
            return false;
        }
        return true;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Lives", this.getLives());
        compound.m_128376_("VanishTime", (short)this.vanishTime);
        if (!this.resurrectionList.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (ZombieResurrection resurrection : this.resurrectionList) {
                CompoundTag compoundNBT = NbtUtils.m_129224_((BlockPos)resurrection);
                compoundNBT.m_128405_("Tick", resurrection.getTick());
                listnbt.add((Object)compoundNBT);
            }
            compound.m_128365_("Resurrections", (Tag)listnbt);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Lives")) {
            this.setLives(compound.m_128451_("Lives"));
        }
        this.vanishTime = compound.m_128448_("VanishTime");
        ListTag listNBT = compound.m_128437_("Resurrections", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundTag compoundNBT = listNBT.m_128728_(i);
            this.resurrectionList.add(i, new ZombieResurrection(this.m_9236_(), NbtUtils.m_129239_((CompoundTag)compoundNBT), compoundNBT.m_128451_("Tick")));
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_ZOMBIE_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_ZOMBIE_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_ZOMBIE_DEATH_SOUND_EVENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.f_20919_ == 0) {
            this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.m_130130_(this.f_20919_);
        buffer.m_130130_(this.vanishTime);
        buffer.m_130130_(this.throwHitTick);
        buffer.m_130130_(this.throwFinishTick);
    }

    @Override
    public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.f_20919_ = additionalData.m_130242_();
        this.vanishTime = additionalData.m_130242_();
        this.throwHitTick = additionalData.m_130242_();
        this.throwFinishTick = additionalData.m_130242_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return AdditionalAddEntityData.getPacket((Entity)this);
    }

    static class SlamGroundGoal
    extends AnimationGoal<MutantZombie> {
        private double dirX = -1.0;
        private double dirZ = -1.0;
        private LivingEntity attackTarget;

        public SlamGroundGoal(MutantZombie mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return SLAM_GROUND_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            this.attackTarget = ((MutantZombie)this.mob).m_5448_();
            return this.attackTarget != null && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ((MutantZombie)this.mob).f_21363_ = -((MutantZombie)this.mob).m_8100_();
            ((MutantZombie)this.mob).m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ZOMBIE_ATTACK_SOUND_EVENT.get(), 0.3f, 0.8f + ((MutantZombie)this.mob).f_19796_.m_188501_() * 0.4f);
        }

        public void m_8037_() {
            ((MutantZombie)this.mob).m_21573_().m_26573_();
            if (((MutantZombie)this.mob).animationTick < 8) {
                ((MutantZombie)this.mob).f_21365_.m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 8) {
                double x = this.attackTarget.m_20185_() - ((MutantZombie)this.mob).m_20185_();
                double z = this.attackTarget.m_20189_() - ((MutantZombie)this.mob).m_20189_();
                double d = Math.sqrt(x * x + z * z);
                this.dirX = x / d;
                this.dirZ = z / d;
            }
            if (((MutantZombie)this.mob).animationTick == 12) {
                int x = Mth.m_14107_((double)(((MutantZombie)this.mob).m_20185_() + this.dirX * 2.0));
                int y = Mth.m_14107_((double)((MutantZombie)this.mob).m_20191_().f_82289_);
                int z = Mth.m_14107_((double)(((MutantZombie)this.mob).m_20189_() + this.dirZ * 2.0));
                int x1 = Mth.m_14107_((double)(((MutantZombie)this.mob).m_20185_() + this.dirX * 8.0));
                int z1 = Mth.m_14107_((double)(((MutantZombie)this.mob).m_20189_() + this.dirZ * 8.0));
                SeismicWave.createWaves(((MutantZombie)this.mob).m_9236_(), ((MutantZombie)this.mob).seismicWaveList, x, z, x1, z1, y);
                ((MutantZombie)this.mob).m_5496_(SoundEvents.f_11913_, 0.5f, 0.8f + ((MutantZombie)this.mob).f_19796_.m_188501_() * 0.4f);
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.dirX = -1.0;
            this.dirZ = -1.0;
            this.attackTarget = null;
        }
    }

    static class RoarGoal
    extends AnimationGoal<MutantZombie> {
        public RoarGoal(MutantZombie mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return ROAR_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            return ((MutantZombie)this.mob).f_19797_ % 3 == 0 && !((MutantZombie)this.mob).isAnimationPlaying() && ((MutantZombie)this.mob).m_5448_() != null && ((MutantZombie)this.mob).m_20096_() && ((MutantZombie)this.mob).resurrectionList.isEmpty() && ((MutantZombie)this.mob).m_20280_((Entity)((MutantZombie)this.mob).m_5448_()) > 16.0 && ((MutantZombie)this.mob).f_19796_.m_188501_() * 100.0f < 0.35f;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ((MutantZombie)this.mob).f_19802_ = 20;
            ((MutantZombie)this.mob).f_21363_ = -((MutantZombie)this.mob).m_8100_();
        }

        public void m_8037_() {
            ((MutantZombie)this.mob).m_21573_().m_26573_();
            if (((MutantZombie)this.mob).animationTick < 75 && ((MutantZombie)this.mob).m_5448_() != null) {
                ((MutantZombie)this.mob).f_21365_.m_24960_((Entity)((MutantZombie)this.mob).m_5448_(), 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 10) {
                ((MutantZombie)this.mob).m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ZOMBIE_ROAR_SOUND_EVENT.get(), 3.0f, 0.7f + ((MutantZombie)this.mob).f_19796_.m_188501_() * 0.2f);
                for (Entity entity : ((MutantZombie)this.mob).m_9236_().m_45933_((Entity)this.mob, ((MutantZombie)this.mob).m_20191_().m_82377_(12.0, 8.0, 12.0))) {
                    if (!((MutantZombie)this.mob).canHarm(entity) || !(((MutantZombie)this.mob).m_20280_(entity) <= 196.0)) continue;
                    double x = entity.m_20185_() - ((MutantZombie)this.mob).m_20185_();
                    double z = entity.m_20189_() - ((MutantZombie)this.mob).m_20189_();
                    double d = Math.sqrt(x * x + z * z);
                    entity.m_20334_(x / d * (double)0.7f, (double)0.3f, z / d * (double)0.7f);
                    entity.m_6469_(DamageSourcesHelper.source((LevelReader)((MutantZombie)this.mob).m_9236_(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), (float)(2 + ((MutantZombie)this.mob).f_19796_.m_188503_(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (((MutantZombie)this.mob).animationTick >= 20 && ((MutantZombie)this.mob).animationTick < 80 && ((MutantZombie)this.mob).animationTick % 10 == 0) {
                int x = Mth.m_14107_((double)((MutantZombie)this.mob).m_20185_());
                int y = Mth.m_14107_((double)((MutantZombie)this.mob).m_20191_().f_82289_);
                int z = Mth.m_14107_((double)((MutantZombie)this.mob).m_20189_());
                y = ZombieResurrection.getSuitableGround(((MutantZombie)this.mob).m_9236_(), x += (1 + ((MutantZombie)this.mob).f_19796_.m_188503_(8)) * (((MutantZombie)this.mob).f_19796_.m_188499_() ? 1 : -1), y - 1, z += (1 + ((MutantZombie)this.mob).f_19796_.m_188503_(8)) * (((MutantZombie)this.mob).f_19796_.m_188499_() ? 1 : -1));
                if (y != -1) {
                    ((MutantZombie)this.mob).resurrectionList.add(new ZombieResurrection(((MutantZombie)this.mob).m_9236_(), x, y, z));
                }
            }
        }
    }

    static class ThrowAttackGoal
    extends AnimationGoal<MutantZombie> {
        private LivingEntity attackTarget;
        private int finish = -1;

        public ThrowAttackGoal(MutantZombie mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            this.attackTarget = ((MutantZombie)this.mob).m_5448_();
            return this.attackTarget != null && super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.attackTarget.m_8127_();
            double x = this.attackTarget.m_20185_() - ((MutantZombie)this.mob).m_20185_();
            double z = this.attackTarget.m_20189_() - ((MutantZombie)this.mob).m_20189_();
            double d = Math.sqrt(x * x + z * z);
            this.attackTarget.m_20334_(x / d * (double)0.8f, (double)1.6f, z / d * (double)0.8f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
        }

        @Override
        public boolean m_8045_() {
            return super.m_8036_() && this.finish < 10;
        }

        public void m_8037_() {
            ((MutantZombie)this.mob).m_21573_().m_26573_();
            ((MutantZombie)this.mob).f_21365_.m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            if (((MutantZombie)this.mob).animationTick == THROW_ANIMATION.duration()) {
                ((MutantZombie)this.mob).f_19865_ = Vec3.f_82478_;
                double d1 = this.attackTarget.m_20185_() - ((MutantZombie)this.mob).m_20185_();
                double d2 = this.attackTarget.m_20186_() - ((MutantZombie)this.mob).m_20186_();
                double x = this.attackTarget.m_20189_() - ((MutantZombie)this.mob).m_20189_();
                double z = Math.sqrt(d1 * d1 + d2 * d2 + x * x);
                ((MutantZombie)this.mob).m_20334_(d1 / z * (double)3.4f, d2 / z * (double)1.4f, x / z * (double)3.4f);
            } else if (((MutantZombie)this.mob).animationTick > THROW_ANIMATION.duration()) {
                double d1 = ((MutantZombie)this.mob).m_20205_() * 2.0f * ((MutantZombie)this.mob).m_20205_() * 2.0f;
                double d2 = ((MutantZombie)this.mob).m_20275_(this.attackTarget.m_20185_(), this.attackTarget.m_20191_().f_82289_, this.attackTarget.m_20189_());
                if (d2 < d1 && !((MutantZombie)this.mob).hasThrowAttackHit()) {
                    ((MutantZombie)this.mob).setThrowAttackHit(true);
                    if (!this.attackTarget.m_6469_(((MutantZombie)this.mob).m_9236_().m_269111_().m_269333_((LivingEntity)this.mob), (float)((MutantZombie)this.mob).m_21133_(Attributes.f_22281_))) {
                        EntityUtil.disableShield(this.attackTarget, 150);
                    }
                    double x = this.attackTarget.m_20185_() - ((MutantZombie)this.mob).m_20185_();
                    double z = this.attackTarget.m_20189_() - ((MutantZombie)this.mob).m_20189_();
                    double d = Math.sqrt(x * x + z * z);
                    this.attackTarget.m_20334_(x / d * (double)0.6f, (double)-1.2f, z / d * (double)0.6f);
                    this.attackTarget.f_19802_ = 10;
                    EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
                    EntityUtil.stunRavager(this.attackTarget);
                    ((MutantZombie)this.mob).m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_ZOMBIE_GRUNT_SOUND_EVENT.get(), 0.3f, 0.8f + ((MutantZombie)this.mob).f_19796_.m_188501_() * 0.4f);
                }
                if (!(!((MutantZombie)this.mob).m_20096_() && ((MutantZombie)this.mob).m_146900_().m_60819_().m_76178_() || ((MutantZombie)this.mob).isThrowAttackFinished())) {
                    this.finish = 0;
                    ((MutantZombie)this.mob).setThrowAttackFinished(true);
                }
                if (this.finish >= 0) {
                    ++this.finish;
                }
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.finish = -1;
            ((MutantZombie)this.mob).setThrowAttackHit(false);
            ((MutantZombie)this.mob).setThrowAttackFinished(false);
            this.attackTarget = null;
        }
    }
}

